/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase15;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.sybase12.Sybase12CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.sybase15.Sybase15CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.sybase15.Sybase15CaptureQueries;

public class Sybase15Capturer
extends AbstractOnlineCapturer {
    private String m_modelName;
    public static final String MY_LANGUAGE_ID = "STSQL";
    protected Sybase12CaptureObjectsOnlineCapturer s_CaptureObjectsOnlineCapturer = null;
    private static String s_SybaseDatabaseToUse = null;
    private static Sybase15CaptureQueries s_captureQueries;

    public Sybase15Capturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        this.s_CaptureObjectsOnlineCapturer = new Sybase15CaptureObjectsOnlineCapturer(migrationStorer, connection);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new Sybase15CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        try {
            this.s_CaptureObjectsOnlineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                this.m_modelName = databaseMetaData.getUserName() + "\\" + this.m_sourceConnection.getCatalog() + " (" + "Sybase15" + ")";
            }
            catch (SQLException sQLException) {
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }
}

