/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationPainter;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.table.TableToolbar;

class IconValidationPainter
implements ValidationPainter {
    IconValidationPainter() {
    }

    public void paintComponent(ValidationComponent comp) {
        Component ui = comp.getComponent();
        if (ui instanceof JComponent) {
            StatusIndicator indicator = (StatusIndicator)((JComponent)ui).getClientProperty("status-indicator");
            if (indicator == null) {
                if (ui instanceof TableToolbar) {
                    indicator = new StatusIndicator();
                    ((TableToolbar)ui).setStatusIndicator(indicator);
                } else if (ui instanceof ComponentWithTitlebar) {
                    indicator = new StatusIndicator();
                    ((ComponentWithTitlebar)ui).setStatusIndicator(indicator);
                }
            }
            if (indicator != null) {
                indicator.setStatus(comp.isValid() ? StatusIndicator.Status.OK : StatusIndicator.Status.ERROR);
                Template template = null;
                if (!comp.isValid() && comp instanceof DBValidationComponent) {
                    template = DBValidationManager.createInfoTipContent(((DBValidationComponent)comp).getValidationExceptions());
                }
                indicator.setInfoTipContent(template);
            } else if (ui instanceof JLabel) {
                ((JLabel)ui).setIcon(DBValidationManager.getLabelIcon(((JLabel)ui).getIcon(), comp.isValid()));
            } else if (ui instanceof JButton) {
                ((JButton)ui).setIcon(DBValidationManager.getLabelIcon(((JButton)ui).getIcon(), comp.isValid()));
            }
        }
    }

    public static boolean supportsComponent(ValidationComponent comp) {
        Component ui = comp.getComponent();
        return ui instanceof JComponent && ((JComponent)ui).getClientProperty("status-indicator") != null || ui instanceof JLabel || ui instanceof JButton || ui instanceof TableToolbar || ui instanceof ComponentWithTitlebar;
    }
}

