/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.MutExChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class ColumnSequencePanel
extends MutExChildObjectEditorPanel<Column, Table> {
    public ColumnSequencePanel() {
        super("ColumnSequencePanel", "columns");
    }

    @Override
    protected void initialiseChildComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.addChildren(this.getOrCreateWrapper("AUTO_GENERATED_SEQUENCE_TRIGGER"), new Integer[0]);
        layout.nextRow();
        layout.addChildren(this.getOrCreateWrapper("AUTO_GENERATED_SEQUENCE"), new Integer[0]);
        layout.nextRow();
        layout.add(this.getOrCreateWrapper("ColumnSequenceExpander.TriggerNullCheck"));
        layout.nextRowWithGap();
        layout.add(this.getOrCreateWrapper("ColumnSequenceExpander.ReuseSequence"));
        layout.pushUp();
        layout.layout();
    }

    @Override
    public String getChildValidationProperty() {
        return "AUTO_GENERATED_SEQUENCE_TRIGGER";
    }

    @Override
    public void initialiseProperty(Column col, DBEditorConfig config) {
        col.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)Boolean.TRUE);
        if (!config.isInFlatEditor()) {
            Relation rel = col.getRelation();
            String trigName = config.getProvider().getUniqueName("TRIGGER", (DBObject)rel.getSchema(), rel.getName() + "_TRG");
            col.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)new ReferenceID("TRIGGER", rel.getSchema(), trigName));
            String seqName = config.getProvider().getUniqueName("SEQUENCE", (DBObject)rel.getSchema(), rel.getName() + "_SEQ");
            col.setProperty("AUTO_GENERATED_SEQUENCE", (Object)new ReferenceID("SEQUENCE", rel.getSchema(), seqName));
        }
    }

    @Override
    public void clearProperty(Column col) {
        ColumnSequenceProcessor.clearColumnSequenceProps((Column)col);
    }

    @Override
    public boolean accept(Column col) {
        DataTypeUsage dtu;
        Relation rel = col.getRelation();
        if (DBUtil.needsBuilding((DBObject)rel, (String)"AUTO_GENERATED_SEQUENCE_TRIGGER") && (dtu = col.getDataTypeUsage()) != null) {
            try {
                DataType datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
                PredefinedDataType.ValueType valueType = DataTypeHelper.getValueType((DataType)datatype);
                if (PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)valueType) || valueType == PredefinedDataType.ValueType.CHAR) {
                    DBUtil.ensureObjectBuilt((DBObject)rel, (String[])new String[]{"AUTO_GENERATED_SEQUENCE_TRIGGER"});
                    for (Column tempCol : rel.getColumns()) {
                        ColumnSequenceProcessor.refreshColumnSequenceProps((Column)tempCol);
                    }
                }
            }
            catch (DBException e) {
                this.getLogger().warning(e.getMessage());
            }
        }
        return ColumnSequenceProcessor.hasColumnSequenceProps((Column)col);
    }
}

