/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.WhereEditor;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class WhereObjectPanel
extends BaseSQLQueryBuilderPanel {
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("WHERE_DESC"));
    private JLabel m_labelWHERE = new JLabel();
    private JPanel m_wherePanel;
    private SQLQueryBuilder m_builder;
    private WhereEditor m_whereEditor = new WhereEditor("WhereObjectPanel", this);

    @Override
    protected String getLayoutOnlyMessage(SQLQuery query, SQLQueryBuilder builder) {
        String retval = super.getLayoutOnlyMessage(query, builder);
        if (retval == null && query.getSetOperator() != null) {
            retval = UIBundle.get("WHERE_AND_SET_CANT_SET");
        }
        return retval;
    }

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        DBUIResourceHelper reshelp = new DBUIResourceHelper("WhereObjectPanel");
        this.m_wherePanel = new JPanel();
        this.m_wherePanel.setLayout(new GridBagLayout());
        reshelp.setName(this.m_wherePanel, "WherePanel");
        reshelp.resLabel(this.m_labelWHERE, this.m_whereEditor.getDefaultComponent(), "&WHERE", "Where");
        this.m_labelWHERE.setText("<html><b><u>W</u>HERE</b></html>");
        this.m_wherePanel.add((Component)this.m_labelWHERE, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_wherePanel.add((Component)this.m_whereEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_wherePanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        this.m_whereEditor.setBindVariables(this.getBindVariables());
        this.m_whereEditor.setTemplates(this.m_builder.listAllFromObjects(), this.m_builder.listAvailableFKs());
        SQLQuery query = this.m_builder.getSQLQuery();
        WhereObject where = query.getWhereObject();
        this.m_whereEditor.setDBObjectProvider(this.getProvider());
        this.m_whereEditor.init(where, this.m_builder);
    }

    private Collection<String> getBindVariables() {
        Collection bindVars = (Collection)this.getDataContext().get("bindVariables");
        HashSet<String> rejigged = null;
        if (bindVars != null && bindVars.size() > 0) {
            rejigged = new HashSet<String>(bindVars.size());
            for (String bindVar : bindVars) {
                if (!bindVar.startsWith(":")) {
                    bindVar = ":" + bindVar;
                }
                rejigged.add(bindVar);
            }
        }
        return rejigged;
    }

    @Override
    public void commitPanel() throws TraversalException {
        if (this.m_builder != null && this.m_whereEditor.hasTextChanged()) {
            String sql = this.m_whereEditor.getWhereText().trim();
            if (sql != null && ModelUtil.hasLength((String)sql)) {
                try {
                    SQLFragment frag = this.m_builder.parseWhereExpression(sql);
                    WhereObject where = frag instanceof WhereObject ? (WhereObject)frag : new WhereObject(frag);
                    this.m_builder.setWhereObject(where);
                }
                catch (SQLQueryException sqe) {
                    throw new TraversalException(sqe.getMessage());
                }
            } else {
                this.m_builder.setWhereObject(null);
            }
        }
    }
}

