/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.ui.table.GenericTableCellRenderer;

class PlSqlParametersPanel
extends ChildTableEditorPanel<PlSqlParameter, Procedure> {
    private DTRefCellRenderer m_renderer;

    PlSqlParametersPanel() {
        super("PlSqlParametersPanel");
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        if (this.m_renderer == null) {
            this.m_renderer = new DTRefCellRenderer();
            this.setDefaultRenderer(PlSqlReference.class, (TableCellRenderer)((Object)this.m_renderer));
        }
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"name", "mode", "noCopy", "dataTypeReference", "defaultValue"};
    }

    @Override
    protected PlSqlParameter newChild() {
        PlSqlParameter param = (PlSqlParameter)this.getProvider().getObjectFactory().newObject(this.getChildClass());
        param.setName(DBUtil.getUniqueName(this.getWrapperTableModel().getRowNames(), (String)this.getNewChildBaseName()));
        param.setMode(PlSqlParameter.Mode.IN);
        DataTypeUsage dtu = this.getProvider().getDescriptor().createDefaultTypeUsage();
        String datatypeName = DBUtil.getDBObjectName((DBObjectID)dtu.getDataTypeID());
        PlSqlReference ref = DataTypeHelper.getDataTypeRefForString((DBObjectProvider)this.getProvider(), null, (String)datatypeName);
        param.setDataTypeReference(ref);
        return param;
    }

    protected void removeChild(PlSqlParameter child) {
        ((Procedure)this.getUpdatedObject()).removeParameter(child);
    }

    @Override
    protected String getChildProperty() {
        return "parameters";
    }

    @Override
    protected Class<PlSqlParameter> getChildClass() {
        return PlSqlParameter.class;
    }

    @Override
    protected String getNewChildBaseName() {
        return "PARAM1";
    }

    @Override
    protected boolean shouldRequstFocusOnInitialisePanel() {
        if (this.m_renderer == null) {
            return super.shouldRequstFocusOnInitialisePanel();
        }
        return false;
    }

    @Override
    protected void validateObject() throws TraversalException {
        if (((Procedure)this.getUpdatedObject()).getSource() != null) {
            super.validateObject();
        }
    }

    private class DTRefCellRenderer
    extends GenericTableCellRenderer {
        private DTRefCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof PlSqlReference) {
                PlSqlReference ref = (PlSqlReference)value;
                DBObjectProvider pro = PlSqlParametersPanel.this.getProvider();
                Schema schema = null;
                try {
                    schema = pro.getDefaultSchema();
                }
                catch (DBException e) {
                    PlSqlParametersPanel.this.getLogger().warning(e.getMessage());
                }
                String typeString = DataTypeHelper.getTypeStringFromRef((PlSqlReference)ref, (Schema)schema, (DBObjectProvider)pro);
                ((JLabel)cell).setText(typeString);
            }
            return cell;
        }
    }
}

