/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.TablePartition;

class LocalIndexPartitionDetailsPanel
extends ChildObjectEditorPanel<IndexPartition, Index> {
    LocalIndexPartitionDetailsPanel() {
        super("LocalIndexPartitionDetailsPanel", PartitionProperty.INDEX_PARTITIONS);
    }

    @Override
    protected void initialiseChildComponents() {
        super.initialiseChildComponents();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwName = this.getOrCreateWrapper("name");
        layout.add(cwName);
        layout.nextRow();
        ComponentWrapper cwParams = this.getOrCreateWrapper("domainParameters");
        layout.add(cwParams);
        layout.getConstraints((Component)cwParams.getComponent()).fill = 1;
        layout.nextRow();
        ComponentWrapper cwCompress = this.getOrCreateWrapper("useKeyCompression");
        layout.add(cwCompress);
        layout.nextRow();
        ComponentWrapper cwStorage = this.getOrCreateButtonWrapper("segmentAttributes");
        layout.nextColumn();
        layout.add(cwStorage.getComponent(), 1, 1, false, false);
        layout.getConstraints((Component)cwStorage.getComponent()).anchor = 13;
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        ComponentWrapper cwParams = this.getComponentFactory().findComponentWrapper("domainParameters");
        if (cwParams != null) {
            cwParams.setVisible(((Index)this.getUpdatedObject()).getIndexType() == Index.IndexType.DOMAIN);
        }
        this.enableWrappers();
    }

    private void enableWrappers() {
        OracleIndexPartitions oip;
        boolean enable;
        IndexPartition ip = (IndexPartition)this.getChildObject();
        boolean bl = enable = DBUtil.findParentOfType((DBObject)ip, Index.class) != null;
        if (enable && this.getProvider() instanceof Database && (oip = (OracleIndexPartitions)ip.getParent()) != null && oip.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
            OracleIndexPartitions origIndexPartitions;
            Index originalIndex = (Index)TemporaryObjectID.findOriginalObject((DBObject)DBUtil.findParentOfType((DBObject)oip, Index.class));
            OracleIndexPartitions oracleIndexPartitions = origIndexPartitions = originalIndex == null ? null : (OracleIndexPartitions)originalIndex.getProperty("OracleIndexPartitions");
            if (origIndexPartitions != null) {
                TablePartition correspondingTp = LocalIndexPartitionHelper.getBaseTablePartition((IndexPartition)ip);
                enable = correspondingTp != null;
            }
        }
        this.enableWrapper("name", enable);
        this.enableWrapper("domainParameters", enable);
        this.enableWrapper("useKeyCompression", ((Index)this.getUpdatedObject()).getKeyCompression() != null && enable);
        this.enableWrapper("segmentAttributes", enable);
    }

    private void enableWrapper(String propName, boolean enable) {
        ComponentWrapper wrap = this.getComponentFactory().findComponentWrapper(propName);
        if (wrap != null) {
            wrap.setEnabled(enable);
        }
    }

    @Override
    protected void refreshComponents() {
        OracleIndexPartitions oip;
        IndexPartition ip = (IndexPartition)this.getChildObject();
        String childPropertyPath = PartitionProperty.INDEX_PARTITIONS;
        if (ip != null && (oip = (OracleIndexPartitions)ip.getParent()) != null && oip.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
            childPropertyPath = PartitionProperty.SUBPARTITIONS_FOR_INDEX_PARTITION;
        }
        this.getComponentFactory().setBasePath(childPropertyPath);
        super.refreshComponents();
    }
}

