/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.property.Property;

public class HiveBucketsPanel
extends BaseEditorPanel<Table> {
    public HiveBucketsPanel() {
        super("HiveBucketsPanel");
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper bucketColsWrap = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "bucketColumns"}));
        bucketColsWrap.addListener(evt -> this.columnsChanged(evt));
        Component bucketCols = bucketColsWrap.getComponent();
        layout.add(bucketCols, 2, 1, true, this.isInFlatEditor());
        layout.nextRowWithGap();
        Component bucketSortCols = this.getSortColsWrapper().getComponent();
        layout.add(bucketSortCols, 2, 1, true, true);
        layout.nextRowWithGap();
        if (this.isInFlatEditor()) {
            bucketCols.setPreferredSize(new Dimension(200, 100));
            bucketSortCols.setPreferredSize(new Dimension(200, 100));
        }
        layout.add(this.getNumberWrapper());
        layout.layout();
    }

    private ComponentWrapper getSortColsWrapper() {
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "bucketSortColumns"}));
    }

    private ComponentWrapper getNumberWrapper() {
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveBucketProperties", "numberOfBuckets"}));
    }

    @Override
    protected void initialisePanel() {
        HiveBucketProperties hbp = (HiveBucketProperties)((Table)this.getUpdatedObject()).getProperty("HiveBucketProperties");
        this.checkEnabled(hbp == null ? null : hbp.getBucketColumns());
    }

    private void columnsChanged(PropertyChangeEvent evt) {
        if (this.isEntered()) {
            DBObjectID[] newCols = (DBObjectID[])evt.getNewValue();
            if (newCols == null || newCols.length == 0) {
                this.getSortColsWrapper().resetPropertyValue(null);
                this.getNumberWrapper().resetPropertyValue(null);
            }
            this.checkEnabled(newCols);
        }
    }

    private void checkEnabled(DBObjectID[] cols) {
        boolean enabled = cols != null && cols.length != 0;
        this.getSortColsWrapper().setEnabled(enabled);
        this.getNumberWrapper().setEnabled(enabled);
    }
}

