/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.bigdata.BigDataField;
import oracle.javatools.db.ora.bigdata.BigDataFields;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.ModelUtil;

public class BigDataFieldsTable
extends ExtendedTable {
    public BigDataFieldsTable() {
        super(PropertyDisplayRegistry.getDisplayName("bigDataFields"), "BigDataFieldsTable");
    }

    @Override
    protected boolean isReorderable() {
        return true;
    }

    public void setFields(BigDataFields fields) {
        this.getComponent().getReorderableBar().setBackground(this.getTable().getBackground());
        Vector<Vector> data = new Vector<Vector>();
        if (fields != null) {
            for (BigDataField field : fields.getBigDataFields()) {
                Vector<String> row = new Vector<String>();
                row.add(field.getName());
                row.add(field.getFieldDataType());
                row.add((String)field.getProperty("Comment"));
                data.add(row);
            }
        }
        this.setModel(new ExtendedTable.StringTableModel(this, data, this.getPropertyColumnNames("name", "fieldDataType", "Comment")));
    }

    public BigDataFields getFields() {
        this.stopCellEditing();
        BigDataFields retval = new BigDataFields();
        for (Object row : this.getModel().getDataVector()) {
            String name = (String)((Vector)row).get(0);
            String type = (String)((Vector)row).get(1);
            String comment = (String)((Vector)row).get(2);
            BigDataField field = new BigDataField();
            field.setName(name);
            if (ModelUtil.hasLength((String)type)) {
                field.setFieldDataType(type);
            }
            if (ModelUtil.hasLength((String)comment)) {
                field.setProperty("Comment", (Object)comment);
            }
            retval.addBigDataField(field);
        }
        return retval;
    }

    @Override
    protected void addNewRow() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object row : this.getModel().getDataVector()) {
            names.add((String)((Vector)row).get(0));
        }
        String name = DBUtil.getUniqueName(names, (String)"field1");
        this.getModel().addRow(new Object[]{name, null, null});
    }

    @Override
    protected void modelReplaced() {
        this.getTable().getColumnModel().getColumn(1).setCellEditor(new DataTypeCellEditor());
    }

    private class DataTypeCellEditor
    extends ExtendedTable.EditableComboCellEditor {
        DataTypeCellEditor() {
            super((ExtendedTable)BigDataFieldsTable.this, "fieldDataType", "array<>", "bigint", "binary", "boolean", "decimal", "double", "float", "int", "map<,>", "smallint", "string", "struct<>", "timestamp", "tinyint", "uniontype<>");
            this.getCombo().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String selected;
                    boolean pop = DataTypeCellEditor.this.getCombo().isPopupVisible();
                    if (e.getStateChange() == 1 && pop && (selected = (String)e.getItem()).indexOf(60) >= 0) {
                        DataTypeCellEditor.this.editCellAndInsertCaretInsideAngles();
                    }
                }
            });
        }

        private void editCellAndInsertCaretInsideAngles() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTable table = BigDataFieldsTable.this.getTable();
                    if (table.isVisible()) {
                        table.editCellAt(table.getSelectedRow(), table.getSelectedColumn());
                        DataTypeCellEditor.this.insertCaretInsideAngles();
                    }
                }
            });
        }

        private void insertCaretInsideAngles() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int i;
                    final JTextComponent ed = DataTypeCellEditor.this.getEditorComponent();
                    if (ed.isVisible() && (i = ed.getText().indexOf(60) + 1) > 0) {
                        ed.requestFocusInWindow();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ed.select(i, i);
                                ed.setCaretPosition(i);
                            }
                        });
                    }
                }
            });
        }
    }
}

