/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.event.DocumentListener;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.NumberTextFieldUnlimited;

public class UnlimitedNumberComponentWrapper
extends AsynchronousComponentWrapper<NumberTextFieldUnlimited> {
    private DocumentListener m_docList = new AsynchronousComponentWrapper.AsynchronousDocumentListener();

    public UnlimitedNumberComponentWrapper() {
        super(new NumberTextFieldUnlimited());
    }

    public UnlimitedNumberComponentWrapper(int unlimitedValue) {
        super(new NumberTextFieldUnlimited(unlimitedValue));
    }

    @Override
    public void setPropertyValue(Object value) {
        ((NumberTextFieldUnlimited)this.getActiveComponent()).getDocument().removeDocumentListener(this.m_docList);
        ((NumberTextFieldUnlimited)this.getActiveComponent()).setNumber((Number)value);
        ((NumberTextFieldUnlimited)this.getActiveComponent()).getDocument().addDocumentListener(this.m_docList);
    }

    @Override
    public Object getPropertyValue() {
        return ((NumberTextFieldUnlimited)this.getActiveComponent()).getNumber();
    }

    @Override
    protected void initialiseComponent() {
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        ((NumberTextFieldUnlimited)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UnlimitedNumberComponentWrapper.this.isActive()) {
                    UnlimitedNumberComponentWrapper.this.fireChangeEvent();
                }
            }
        });
    }

    public void setUseBigIntegers(boolean useBigIntegers) {
        if (useBigIntegers) {
            ((NumberTextFieldUnlimited)this.getActiveComponent()).getNumberTextField().setDataType(BigInteger.class);
            ((NumberTextFieldUnlimited)this.getActiveComponent()).getNumberTextField().setScientific(true);
        } else {
            ((NumberTextFieldUnlimited)this.getActiveComponent()).getNumberTextField().setDataType(Integer.class);
            ((NumberTextFieldUnlimited)this.getActiveComponent()).getNumberTextField().setScientific(false);
        }
    }

    @Override
    protected void losingFocus() {
        super.losingFocus();
        ((NumberTextFieldUnlimited)this.getActiveComponent()).getDocument().removeDocumentListener(this.m_docList);
    }

    @Override
    protected void gainingFocus() {
        super.gainingFocus();
        ((NumberTextFieldUnlimited)this.getActiveComponent()).getDocument().removeDocumentListener(this.m_docList);
        ((NumberTextFieldUnlimited)this.getActiveComponent()).getDocument().addDocumentListener(this.m_docList);
    }

    @Override
    public Component[] getFocusComponents() {
        return ((NumberTextFieldUnlimited)this.getActiveComponent()).getComponents();
    }
}

