/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.controls.DBObjectIDShuttlePanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.ui.ResizeComponent;

public abstract class IdArrayWrapper
extends ComponentWrapper<DBObjectIDShuttlePanel> {
    private DBObjectProviderListener m_proListener = null;
    private boolean m_listenerDone = false;

    public IdArrayWrapper(Class<? extends DBObject> clz, DBObjectFilter filter, boolean addOrderButtons, Integer buttonMask) {
        super(new DBObjectIDShuttlePanel(clz, filter, addOrderButtons, buttonMask));
    }

    @Override
    protected Component createComponentForLayout() {
        JComponent retval = (JComponent)this.getActiveComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            retval = new ResizeComponent(retval);
        }
        retval.putClientProperty("oracle.ideimpl.db.DBUILayoutHelper.SHUTTLE", true);
        return retval;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return ((DBObjectIDShuttlePanel)this.getActiveComponent()).getToComponent();
    }

    @Override
    public Object getPropertyValue() {
        return ((DBObjectIDShuttlePanel)this.getActiveComponent()).getSelectedIDs();
    }

    @Override
    protected Component getDefaultValidationComponent() {
        return ((DBObjectIDShuttlePanel)this.getActiveComponent()).getToLabel();
    }

    @Override
    public void setPropertyValue(Object val) {
        DBObjectID[] ids = new DBObjectID[]{};
        if (val instanceof DBObjectID[]) {
            ids = (DBObjectID[])val;
        }
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).setSelectedIDs(ids);
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent event) {
                IdArrayWrapper.this.fireChangeEvent();
            }

            public void shuttleItemsRemoved(ShuttleEvent event) {
                IdArrayWrapper.this.fireChangeEvent();
            }

            public void shuttleItemsReordered(ShuttleEvent event) {
                IdArrayWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        ((DBObjectIDShuttlePanel)this.getActiveComponent()).initialiseIDs(this.getAvailableList());
    }

    protected abstract List<DBObject> getAvailableList();

    @Override
    protected void setActiveImpl(boolean active) {
        boolean refresh;
        if (active) {
            if (!this.m_listenerDone) {
                refresh = true;
                if (this.getComponentContext().isInFlatEditor()) {
                    this.m_proListener = this.createProviderListenerForRefresh();
                }
                this.m_listenerDone = true;
            } else {
                refresh = this.forceRefreshOnActivate();
            }
        } else {
            refresh = false;
        }
        if (this.m_proListener != null) {
            this.getProvider().removeProviderListener(this.m_proListener);
            if (active) {
                this.getProvider().addProviderListener(this.m_proListener);
            }
        }
        if (refresh) {
            this.refreshUI();
        }
    }

    protected boolean forceRefreshOnActivate() {
        return this.getComponentContext().isInFlatEditor();
    }

    protected abstract DBObjectProviderListener createProviderListenerForRefresh();

    protected final void refreshUI() {
        this.refreshUI(this.getAvailableList());
    }

    protected final void refreshUI(final List<DBObject> availableList) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.isActive()) {
                ((DBObjectIDShuttlePanel)this.getActiveComponent()).initialiseIDs(availableList, false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdArrayWrapper.this.refreshUI(availableList);
                }
            });
        }
    }
}

