/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.components.IdArrayWrapper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.property.Property;

public class ExternalChildIdArrayWrapper
extends IdArrayWrapper {
    private final String[] m_props;
    private DBObjectListener m_objListener;

    public ExternalChildIdArrayWrapper(Class<? extends DBObject> clz, DBObjectFilter filter, Integer buttonMask, boolean addOrderButtons, String ... propPath) {
        super(clz, filter, addOrderButtons, buttonMask);
        this.m_props = propPath;
    }

    @Override
    protected List<DBObject> getAvailableList() {
        Object val = this.getPropertyHelper().getPropertyValue((Object)this.getUpdatedObject(), Property.createPath((String[])this.m_props));
        return this.getAvailableList(val);
    }

    private List<DBObject> getAvailableList(Object val) {
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        if (val instanceof Object[]) {
            Object[] arr = (Object[])val;
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof DBObject)) continue;
                retval.add((DBObject)arr[i]);
            }
        }
        return retval;
    }

    @Override
    protected DBObjectProviderListener createProviderListenerForRefresh() {
        return new DBObjectProviderListener(){

            public void objectUpdated(DBObjectChange change) {
                DBObject dbo = change.getDBObject();
                if (ExternalChildIdArrayWrapper.this.getOriginalObject().getProperty(ExternalChildIdArrayWrapper.this.m_props[0]) instanceof DBObjectID && dbo.getID().equals((DBObjectID)ExternalChildIdArrayWrapper.this.getOriginalObject().getProperty(ExternalChildIdArrayWrapper.this.m_props[0]), false)) {
                    ExternalChildIdArrayWrapper.this.refreshUI();
                }
            }
        };
    }

    @Override
    protected void setActiveImpl(boolean active) {
        if (this.getComponentContext().isInFlatEditor()) {
            super.setActiveImpl(active);
        } else {
            if (this.m_objListener == null) {
                this.m_objListener = new SwingDBObjectPropertyListener(new String[]{this.m_props[0]}){

                    @Override
                    protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                        Object newListVal;
                        Object newVal = pce.getNewValue();
                        if (newVal == null) {
                            newListVal = null;
                        } else {
                            String restOfPath = Property.stripStartingPath((String)Property.createPath((String[])ExternalChildIdArrayWrapper.this.m_props), (String[])new String[]{ExternalChildIdArrayWrapper.this.m_props[0]});
                            newListVal = ExternalChildIdArrayWrapper.this.getPropertyHelper().getPropertyValue(newVal, restOfPath);
                        }
                        ExternalChildIdArrayWrapper.this.setPropertyValue(null);
                        ExternalChildIdArrayWrapper.this.refreshUI(ExternalChildIdArrayWrapper.this.getAvailableList(newListVal));
                    }
                };
            }
            this.getUpdatedObject().removeObjectListener(this.m_objListener);
            if (active) {
                this.getUpdatedObject().addObjectListener(this.m_objListener);
            }
        }
    }
}

