/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

public class ConstraintIndexIDComponentWrapper
extends ComponentWrapper<DBObjectChooser> {
    private DBObjectID m_default;
    private final DBObjectListener m_objListener = new SwingDBObjectListener(){

        @Override
        protected void updateUI(DBObjectChange change) {
            if (ConstraintIndexIDComponentWrapper.this.isActive()) {
                PropertyChangeEvent colsChange;
                Map changes = change.getPropertiesChanged();
                PropertyChangeEvent indexIDChange = (PropertyChangeEvent)changes.get("indexID");
                if (indexIDChange != null) {
                    ConstraintIndexIDComponentWrapper.this.reset();
                    ConstraintIndexIDComponentWrapper.this.setPropertyValue(indexIDChange.getNewValue());
                }
                if ((colsChange = (PropertyChangeEvent)changes.get("columnIDs")) != null) {
                    ConstraintIndexIDComponentWrapper.this.reset();
                    ConstraintIndexHelper.clearIndexIDIfInvalid((UniqueConstraint)((UniqueConstraint)change.getDBObject()), (DBObjectProvider)ConstraintIndexIDComponentWrapper.this.getProvider());
                }
                if (changes.containsKey("enabled") || colsChange != null) {
                    ConstraintIndexIDComponentWrapper.this.checkEnabled();
                }
            }
        }
    };
    private final DBObjectChooser.ChangeListener m_changeListener = new DBObjectChooser.ChangeListener(){

        @Override
        public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
            ConstraintIndexIDComponentWrapper.this.fireChangeEvent();
            if (id != null && !id.equals(ConstraintIndexIDComponentWrapper.this.m_default, true)) {
                ConstraintIndexIDComponentWrapper.this.m_default = null;
            }
        }
    };

    public ConstraintIndexIDComponentWrapper() {
        super(new DBObjectChooser("INDEX"));
    }

    @Override
    public Object getPropertyValue() {
        return this.m_default == null ? ((DBObjectChooser)this.getActiveComponent()).getDBObjectID() : this.m_default;
    }

    @Override
    public void setPropertyValue(Object val) {
        this.reset();
        DBObjectID id = null;
        if (val instanceof DBObjectID) {
            id = (DBObjectID)val;
        }
        DBObjectChooser chooser = (DBObjectChooser)this.getActiveComponent();
        if (id == null) {
            chooser.setNullText(UIBundle.get("STRING_DEFAULT_PROMPT"));
        } else {
            chooser.setNullText(null);
        }
        ((DBObjectChooser)this.getActiveComponent()).removeChangeListener(this.m_changeListener);
        chooser.setDBObjectID(id);
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(this.m_changeListener);
        this.checkEnabled();
    }

    private void checkEnabled() {
        DBObject obj = this.getUpdatedObject();
        if (obj instanceof UniqueConstraint) {
            this.setEnabled(((UniqueConstraint)obj).isEnabled() && ((UniqueConstraint)obj).getColumnIDs().length > 0);
        }
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(this.m_changeListener);
    }

    @Override
    protected void initialiseComponent() {
        DBObjectFilter indexFilter = new DBObjectFilter(){

            public boolean accept(DBObject obj) {
                DBObject uk = ConstraintIndexIDComponentWrapper.this.getUpdatedObject();
                if (uk instanceof UniqueConstraint && obj instanceof Index) {
                    return ConstraintIndexHelper.indexValidForConstraint((Index)((Index)obj), (UniqueConstraint)((UniqueConstraint)uk), (DBObjectProvider)ConstraintIndexIDComponentWrapper.this.getProvider());
                }
                return false;
            }
        };
        DBObjectChooser chooser = (DBObjectChooser)this.getActiveComponent();
        chooser.setProvider(this.getProvider());
        chooser.setFilter(indexFilter);
    }

    private void reset() {
        DBObjectChooser chooser = (DBObjectChooser)this.getActiveComponent();
        chooser.resetCaches();
        chooser.setContextDBObjectID(this.getComponentContext().getUpdatedSystemObject().getID());
        this.m_default = null;
    }

    @Override
    protected void setActiveImpl(boolean active) {
        DBObject obj = this.getUpdatedObject();
        if (obj instanceof UniqueConstraint) {
            obj.removeObjectListener(this.m_objListener);
            if (active) {
                obj.addObjectListener(this.m_objListener);
            }
        }
        if (!active) {
            ((DBObjectChooser)this.getActiveComponent()).cancel();
        }
    }
}

