/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class PlSqlSpecAndBodySynchronizer {
    private PlSqlSpecAndBodySynchronizer() {
    }

    public static void launch(BaseDBObjectTextNode node, Integer offset) {
        PlSqlSpecAndBodySynchronizer.process(node, offset, null);
    }

    public static void add(BaseDBObjectTextNode node, PlSqlSubProgram frag) {
        PlSqlSpecAndBodySynchronizer.process(node, null, frag);
    }

    private static void process(final BaseDBObjectTextNode node, final Integer offset, final PlSqlSubProgram codeFrag) {
        final Holder holder = new Holder();
        if (SwingUtilities.isEventDispatchThread()) {
            final ProgressBar pbar = new ProgressBar((Component)Ide.getMainWindow(), StringUtils.stripMnemonic((String)UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_ACTION")), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    holder.set((Object)PlSqlSpecAndBodySynchronizer.getSyncContext(node, offset, codeFrag));
                    pbar.setDoneStatus();
                }
            };
            pbar.setRunnable(runnable);
            pbar.setCancelable(true);
            pbar.start(null, null, 1500);
            if (!pbar.hasUserCancelled()) {
                PlSqlSpecAndBodySynchronizer.updateUI((SyncContext)holder.get());
            }
        } else {
            holder.set((Object)PlSqlSpecAndBodySynchronizer.getSyncContext(node, offset, codeFrag));
            if (!Thread.currentThread().isInterrupted()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlSpecAndBodySynchronizer.updateUI((SyncContext)holder.get());
                    }
                });
            }
        }
    }

    private static SyncContext getSyncContext(BaseDBObjectTextNode node, Integer offset, PlSqlSubProgram codeFrag) {
        SyncContext retval;
        block25: {
            retval = new SyncContext();
            try {
                PlSqlSchemaObject otherObject;
                DBObjectProvider pro = node.getProvider();
                PlSqlSourceObject so = (PlSqlSourceObject)node.getDBObjectFromBuffer();
                retval.m_pro = pro;
                boolean useDialog = true;
                if (!(so instanceof PlSqlSchemaObject)) break block25;
                BaseDBObjectTextNode otherNode = DBObjectNodeUtil.getCompanionNode((PlSqlSchemaObject)so, pro);
                if (otherNode != null) {
                    if (otherNode.isOpen()) {
                        otherObject = (PlSqlSourceObject)otherNode.getDBObjectFromBuffer();
                    } else {
                        otherObject = (PlSqlSourceObject)otherNode.getDBObject();
                        if (otherObject == null) {
                            otherNode = null;
                            useDialog = false;
                        }
                    }
                } else {
                    otherObject = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)((PlSqlSchemaObject)so), (DBObjectProvider)pro);
                    if (so instanceof PlSqlSchemaObjectSpec) {
                        useDialog = false;
                    } else {
                        DBLog.getLogger(PlSqlSpecAndBodySynchronizer.class).warning("Body with no spec found.  Not suppoted.");
                        return null;
                    }
                }
                if (so instanceof PlSqlSchemaObjectSpec) {
                    retval.m_spec = (PlSqlSchemaObjectSpec)so;
                    retval.m_specNode = node;
                    retval.m_body = (PlSqlSchemaObjectBody)otherObject;
                    retval.m_bodyNode = otherNode;
                    retval.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(offset, node, (PlSqlSchemaObject)retval.m_spec);
                    retval.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(null, otherNode, (PlSqlSchemaObject)retval.m_body);
                } else {
                    retval.m_spec = (PlSqlSchemaObjectSpec)otherObject;
                    retval.m_specNode = otherNode;
                    retval.m_body = (PlSqlSchemaObjectBody)so;
                    retval.m_bodyNode = node;
                    retval.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(null, otherNode, (PlSqlSchemaObject)retval.m_spec);
                    retval.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(offset, node, (PlSqlSchemaObject)retval.m_body);
                }
                CancelledException.checkInterrupt();
                if (retval.m_body != null) {
                    PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)retval.m_body, (DBObjectProvider)pro);
                    if (parser == null) {
                        retval.m_cancelled = true;
                        return retval;
                    }
                    if (parser.isWrapped()) {
                        retval.m_errorMessage = UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_BODY_WRAPPED");
                        return retval;
                    }
                } else if (retval.m_body == null && !retval.m_spec.canHaveBody()) {
                    if (retval.m_spec instanceof Type && "COLLECTION".equals(((Type)retval.m_spec).getTypeCode())) {
                        retval.m_errorMessage = UIBundle.get("FIND_OR_CREATE_BODY_COLLECTION_ERROR");
                    } else {
                        retval.m_errorMessage = UIBundle.format("FIND_OR_CREATE_BODY_OTHER_ERROR", retval.m_spec.getType(), retval.m_spec.getName());
                    }
                    return retval;
                }
                if (codeFrag != null && otherNode != null) {
                    StringBuilder sb = PlSqlSpecAndBodySynchronizer.getBuilder(Collections.singletonList(codeFrag), (PlSqlSchemaObject)so, pro);
                    if (otherObject instanceof PlSqlSchemaObjectBody) {
                        retval.m_bodyOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(offset, otherNode, otherObject);
                        retval.m_bodyText = sb.toString();
                    } else {
                        retval.m_specOffset = PlSqlSpecAndBodySynchronizer.ensureOffset(offset, otherNode, otherObject);
                        retval.m_specText = sb.toString();
                    }
                    break block25;
                }
                if (!useDialog) {
                    if (retval.m_spec instanceof Package) {
                        retval.m_body = (PlSqlSchemaObjectBody)pro.getObjectFactory().newObject(PackageBody.class);
                    } else {
                        retval.m_body = (PlSqlSchemaObjectBody)pro.getObjectFactory().newObject(TypeBody.class);
                    }
                    retval.m_body.setSpecID(retval.m_spec.getID());
                    retval.m_newBody = true;
                    String bodySrc = PlSqlUtil.getDefaultBodyForSpec((PlSqlSourceObject)retval.m_spec, (String)pro.getExternalName(retval.m_spec.getName()), (DBObjectProvider)pro);
                    retval.m_body.setSource(bodySrc);
                    retval.m_body.setName(retval.m_spec.getName());
                    retval.m_body.setSchema(retval.m_spec.getSchema());
                    break block25;
                }
                retval.m_specList = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)pro, (PlSqlSchemaObject)retval.m_spec, (PlSqlSchemaObject)retval.m_body);
                if (retval.m_body != null) {
                    retval.m_bodyList = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)pro, (PlSqlSchemaObject)retval.m_body, (PlSqlSchemaObject)retval.m_spec);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlSpecAndBodySynchronizer.showDialog(retval);
                    }
                });
                return null;
            }
            catch (CancelledException ce) {
                retval.m_cancelled = true;
            }
        }
        return retval;
    }

    private static void updateUI(SyncContext ctx) {
        if (ctx != null && !ctx.m_cancelled) {
            if (ctx.m_errorMessage != null) {
                DBMessageDialog.showErrorDialog(ctx.m_errorMessage, ctx.m_spec, Level.INFO, UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), null);
            } else if (ctx.m_newBody) {
                DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((SchemaObject)ctx.m_body, ctx.m_pro);
                if (fac != null) {
                    DBEditorConfig edconfig = DBEditorConfig.newCreateConfig(ctx.m_pro, (DBObject)ctx.m_body);
                    fac.launchDialog(edconfig);
                }
            } else {
                if (ModelUtil.hasLength((String)ctx.m_specText)) {
                    PlSqlSpecAndBodySynchronizer.insertIntoBuffer(ctx.m_specText, ctx.m_specNode, (PlSqlSchemaObject)ctx.m_spec, ctx.m_specOffset);
                }
                if (ModelUtil.hasLength((String)ctx.m_bodyText)) {
                    PlSqlSpecAndBodySynchronizer.insertIntoBuffer(ctx.m_bodyText, ctx.m_bodyNode, (PlSqlSchemaObject)ctx.m_body, ctx.m_bodyOffset);
                }
            }
        }
    }

    private static void showDialog(final SyncContext ctx) {
        final SyncPanel panel = new SyncPanel(ctx);
        panel.setHelpID("f1_synchspecbody_html");
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), (Traversable)panel, new Namespace());
        JEWTDialog dialog = launcher.initDialog();
        dialog.setContent((Component)((Object)panel));
        dialog.setPreferredSize(400, 300);
        dialog.setResizable(true);
        dialog.setName("PlSqlSpecAndBodySynchronizer");
        if (launcher.showDialog()) {
            final ProgressBar pbar = new ProgressBar((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_ACTION"), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        StringBuilder bodySb = PlSqlSpecAndBodySynchronizer.getBuilder(panel.getAddToBodyFragments(), (PlSqlSchemaObject)ctx.m_spec, ctx.m_pro);
                        ctx.m_bodyText = bodySb == null ? null : bodySb.toString();
                        StringBuilder specSb = PlSqlSpecAndBodySynchronizer.getBuilder(panel.getAddToSpecFragments(), (PlSqlSchemaObject)ctx.m_body, ctx.m_pro);
                        ctx.m_specText = specSb == null ? null : specSb.toString();
                    }
                    catch (CancelledException ce) {
                        ctx.m_cancelled = true;
                    }
                    pbar.setDoneStatus();
                }
            };
            pbar.setRunnable(runnable);
            pbar.setCancelable(true);
            pbar.start(null, null, 1500);
        } else {
            ctx.m_cancelled = true;
        }
        PlSqlSpecAndBodySynchronizer.updateUI(ctx);
    }

    private static StringBuilder getBuilder(List<PlSqlSubProgram> frags, PlSqlSchemaObject source, DBObjectProvider pro) throws CancelledException {
        PlSqlParser parser;
        StringBuilder sb = new StringBuilder();
        Object subProgramSearch = source instanceof PackageBody ? new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}") : (source instanceof TypeBody ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : null);
        if (frags.size() > 0 && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)source, (DBObjectProvider)pro)) != null) {
            for (PlSqlSubProgram frag : frags) {
                PlSqlToken startTk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
                if (source instanceof PlSqlSchemaObjectSpec) {
                    sb.append(PlSqlUtil.getDefaultImplementation((PlSqlSourceObject)source, (PlSqlSubProgram)frag, (DBObjectProvider)pro));
                    continue;
                }
                if (!subProgramSearch.matches(startTk)) continue;
                sb.append("  ");
                sb.append(subProgramSearch.getStartToken().getSource(false, (Token)subProgramSearch.getEndToken()));
                sb.append(";\n\n");
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoBuffer(String text, BaseDBObjectTextNode node, PlSqlSchemaObject target, Integer offset) {
        try {
            Context context = Context.newIdeContext((Node)node);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
            TextBuffer tb = node.acquireTextBuffer();
            int line = tb.getLineMap().getLineFromOffset(offset.intValue());
            int insertAt = tb.getLineMap().getLineStartOffset(line);
            tb.beginEdit();
            tb.insert(insertAt, text.toCharArray());
            tb.endEdit();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, insertAt, 0);
            point.setPreferredEditorType(null);
            NavigationManager mgr = NavigationManager.getNavigationManager();
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception exception) {
        }
        finally {
            node.releaseTextBuffer();
        }
    }

    private static Integer ensureOffset(Integer offset, BaseDBObjectTextNode node, PlSqlSchemaObject target) throws CancelledException {
        PlSqlParser parser;
        if (node != null && target != null && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)target, (DBObjectProvider)node.getProvider())) != null) {
            PlSqlToken tk;
            PlSqlSubProgram[] subs;
            DBObjectPlSqlFragment frag;
            if (offset != null && ((frag = target.getChildAtOffset(offset.intValue())) != target || offset < parser.getStartOffsetOfObject() || offset > parser.getEndOffsetOfObject())) {
                offset = null;
            }
            if (offset == null && target instanceof PackageBody && (subs = target.getSubPrograms()).length > 0) {
                offset = subs[subs.length - 1].getEndOffset();
                tk = parser.getTokenAtOffset(offset.intValue());
                tk = (PlSqlToken)tk.getNextCodeToken();
                offset = tk.getStart();
            }
            if (offset == null) {
                PlSqlToken endTk = parser.getTokenAtOffset(parser.getEndOffsetOfObject());
                if (!endTk.isCode()) {
                    endTk = (PlSqlToken)endTk.getPrevCodeToken();
                }
                tk = endTk;
                for (int i = 0; i < 3; ++i) {
                    if (tk.matches("end")) {
                        endTk = tk;
                        break;
                    }
                    tk = (PlSqlToken)tk.getPrevCodeToken();
                }
                offset = endTk.getStart();
            }
        }
        return offset;
    }

    private static class SyncContext {
        private DBObjectProvider m_pro;
        private boolean m_cancelled;
        private boolean m_newBody;
        private String m_errorMessage;
        private PlSqlSchemaObjectSpec m_spec;
        private BaseDBObjectTextNode m_specNode;
        private Integer m_specOffset;
        private String m_specText;
        private List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> m_specList;
        private PlSqlSchemaObjectBody m_body;
        private BaseDBObjectTextNode m_bodyNode;
        private Integer m_bodyOffset;
        private String m_bodyText;
        private List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> m_bodyList;

        private SyncContext() {
        }
    }

    private static class SyncPanel
    extends DefaultTraversablePanel {
        private final LocalTreeNode m_rootNode = new LocalTreeNode("root");
        private LocalTreeNode m_addToBodyNode = null;
        private LocalTreeNode m_addToSpecNode = null;

        public SyncPanel(SyncContext ctx) {
            DBObjectProvider pro = ctx.m_pro;
            PlSqlSchemaObjectSpec spec = ctx.m_spec;
            List specList = ctx.m_specList;
            PlSqlSchemaObjectBody body = ctx.m_body;
            List bodyList = ctx.m_bodyList;
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)((Object)this.m_rootNode));
            for (Tuple pair : specList) {
                if (pair.getSecond() != null) continue;
                LocalTreeNode addToBodyNode = this.getAddToBodyNode(spec);
                LocalTreeNode node = new LocalTreeNode(pair.getFirst());
                node.setNodeState(TriStateNode.NodeState.YES);
                addToBodyNode.setNodeState(TriStateNode.NodeState.YES);
                addToBodyNode.add((MutableTreeNode)((Object)node));
            }
            if (bodyList != null) {
                for (Tuple pair : bodyList) {
                    if (pair.getSecond() != null) continue;
                    LocalTreeNode node = new LocalTreeNode(pair.getFirst());
                    LocalTreeNode addToSpecNode = this.getAddToSpecNode(body);
                    addToSpecNode.add((MutableTreeNode)((Object)node));
                }
            }
            CheckboxTree tree = new CheckboxTree((TreeModel)model);
            tree.setRootVisible(false);
            for (int row = 0; tree.getRowCount() > row; ++row) {
                tree.expandRow(row);
            }
            DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)((Object)this));
            layout.add(new JScrollPane((Component)tree));
            layout.layout();
        }

        public List<PlSqlSubProgram> getAddToSpecFragments() {
            ArrayList<PlSqlSubProgram> list = new ArrayList<PlSqlSubProgram>();
            this.addSelectedFragments(list, this.m_addToSpecNode);
            return list;
        }

        public List<PlSqlSubProgram> getAddToBodyFragments() {
            ArrayList<PlSqlSubProgram> list = new ArrayList<PlSqlSubProgram>();
            this.addSelectedFragments(list, this.m_addToBodyNode);
            return list;
        }

        private LocalTreeNode getAddToBodyNode(PlSqlSchemaObjectSpec spec) {
            if (this.m_addToBodyNode == null && spec != null) {
                this.m_addToBodyNode = new LocalTreeNode(spec);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToBodyNode));
            }
            return this.m_addToBodyNode;
        }

        private LocalTreeNode getAddToSpecNode(PlSqlSchemaObjectBody body) {
            if (this.m_addToSpecNode == null && body != null) {
                this.m_addToSpecNode = new LocalTreeNode(body);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToSpecNode));
            }
            return this.m_addToSpecNode;
        }

        private void addSelectedFragments(List<PlSqlSubProgram> list, LocalTreeNode node) {
            if (node != null && !node.isLeaf()) {
                for (LocalTreeNode child = (LocalTreeNode)((Object)node.getFirstChild()); child != null; child = (LocalTreeNode)((Object)child.getNextSibling())) {
                    if (!TriStateNode.NodeState.YES.equals((Object)child.getNodeState())) continue;
                    list.add((PlSqlSubProgram)child.getUserObject());
                }
            }
        }

        private static class LocalTreeNode
        extends TriStateNode {
            public LocalTreeNode(Object userData) {
                super(userData);
            }

            public Icon getIcon() {
                PlSqlStatement.Type type;
                Icon icon = null;
                Object obj = this.getUserObject();
                icon = obj instanceof PlSqlSubProgram ? ((type = ((PlSqlSubProgram)obj).getStatementType()) == PlSqlStatement.Type.FUNCTION || type == PlSqlStatement.Type.FUNCTION_FD ? DBTypeDisplayRegistry.getNodeIcon("FUNCTION") : (type == PlSqlStatement.Type.CURSOR ? OracleIcons.getIcon((String)"selection.png") : DBTypeDisplayRegistry.getNodeIcon("PROCEDURE"))) : (obj instanceof DBObject ? DBTypeDisplayRegistry.getNodeIcon((DBObject)obj) : OracleIcons.getIcon((String)"spacer.png"));
                return icon;
            }

            public String getLabel() {
                Object obj = this.getUserObject();
                if (obj instanceof PlSqlSchemaObject) {
                    String type = "PACKAGE BODY";
                    if (obj instanceof PackageBody) {
                        type = "PACKAGE";
                    } else if (obj instanceof Type) {
                        type = "TYPE BODY";
                    } else if (obj instanceof Type) {
                        type = "TYPE BODY";
                    }
                    return UIBundle.format("SYNCHRONIZE_SPEC_AND_BODY_ADD_TO", DBTypeDisplayRegistry.getSingularDisplayName(type));
                }
                if (obj instanceof PlSqlSubProgram) {
                    return ((PlSqlSubProgram)obj).getSignature();
                }
                return super.getLabel();
            }
        }
    }
}

