/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.model.NodeFactory;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.db.token.Token;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.util.ModelUtil;

public class PlSqlPopupContentProvider
implements HtmlContentProvider {
    private final DBObjectProvider m_pro;
    private final BaseDBObjectTextNode m_node;
    private final int m_offset;
    private final String m_anchor;
    private DBObjectID m_id;
    private String m_content;
    private static final String COLUMNS_ANCHOR = "COL";
    private static final String METHODS_ANCHOR = "METH";
    private static final String ATTRIBUTES_ANCHOR = "ATTR";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String SEMICOLON = ";";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String HASH = "#";
    private static final String NEW_LINE = "\n";
    private static final String DOUBLE_NEW_LINE = "\n\n";
    private static final String PREFORMAT = "<pre>";
    private static final String PREFORMAT_END = "</pre>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private static final String SMALL = "<small>";
    private static final String SMALL_END = "</small>";
    private static final String ARG_PREFIX = "a";

    PlSqlPopupContentProvider(BaseDBObjectTextNode node, int offset) {
        this(node.getProvider(), null, null, node, offset);
    }

    private PlSqlPopupContentProvider(DBObjectProvider pro, DBObjectID id, String anchor, BaseDBObjectTextNode node, int offset) {
        if (pro == null) {
            throw new IllegalArgumentException("m_pro is null");
        }
        if (id == null && node == null) {
            throw new IllegalArgumentException("id and node both null, one must be set");
        }
        this.m_pro = pro;
        this.m_node = node;
        this.m_offset = offset;
        this.m_id = id;
        this.m_anchor = anchor;
        this.m_content = null;
    }

    public String getHTML() {
        try {
            return this.getHTMLImpl();
        }
        catch (CancelledException ce) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getHTMLImpl() throws CancelledException {
        if (this.m_content == null) {
            PlSqlSourceObject pso;
            DBObjectPlSqlFragment childFrag;
            SourceObject sysObj;
            if (this.m_id == null && (sysObj = this.m_node.getDBObjectFromBuffer()) instanceof PlSqlSourceObject && (childFrag = (pso = (PlSqlSourceObject)sysObj).getReferenceAtOffset(this.m_offset)) instanceof PlSqlReference) {
                PlSqlReference ref = (PlSqlReference)childFrag;
                this.m_id = ref.getReferenceID();
            }
            if (this.m_id != null) {
                DBObject refObj = null;
                try {
                    refObj = this.m_id.resolveID();
                }
                catch (CancelledException ce) {
                    throw ce;
                }
                catch (DBException e) {
                    refObj = null;
                }
                if (refObj == null && this.m_id instanceof BaseObjectID && this.m_id.getParent() == null) {
                    String idName = ((BaseObjectID)this.m_id).getName();
                    StringTokenizer tz = new StringTokenizer(idName, "(),", false);
                    int args = tz.countTokens() - 1;
                    String name = tz.nextToken();
                    Iterator iterator = this.m_pro.getDescriptor().listBuiltInFunctions(name).iterator();
                    if (iterator.hasNext()) {
                        BuiltInFunction bif = (BuiltInFunction)iterator.next();
                        refObj = bif;
                    }
                }
                StringBuilder sb = new StringBuilder();
                int textLength = sb.length();
                boolean definitionAdded = false;
                if (refObj != null) {
                    String comm;
                    DBObject par = refObj.getParent();
                    if (par != null) {
                        sb.append(SMALL);
                        this.addLink(sb, this.getType(par) + SPACE + this.getName(par), par.getID());
                        sb.append(SMALL_END);
                        sb.append(DOUBLE_NEW_LINE);
                    }
                    textLength = sb.length();
                    if (refObj instanceof PlSqlCodeFragment) {
                        PlSqlCodeFragment codeFrag = (PlSqlCodeFragment)refObj;
                        Column[] so = (Column[])DBUtil.getSchemaObject((DBObject)codeFrag);
                        PlSqlSubProgram[] parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)this.m_pro);
                        if (parser != null) {
                            for (int i = 1; i < this.getLineOfset((DBObjectPlSqlFragment)codeFrag); ++i) {
                                sb.append(SPACE);
                            }
                            int start = codeFrag.getStartOffset();
                            int end = start - 1;
                            if (refObj instanceof PlSqlSubProgram) {
                                PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)refObj;
                                start = refObj == so ? parser.getRoot().getStartOffset().intValue() : plSqlSubProgram.getStartOffset().intValue();
                                if (plSqlSubProgram.getReturnTypeReference() != null) {
                                    end = plSqlSubProgram.getReturnTypeReference().getEndOffset();
                                } else if (plSqlSubProgram.getParameters().length > 0) {
                                    for (PlSqlParameter p : plSqlSubProgram.getParameters()) {
                                        int e = p.getDataTypeReference().getEndOffset();
                                        if (e <= end) continue;
                                        end = e;
                                    }
                                    if (end != start) {
                                        PlSqlToken tk = parser.getTokenAtOffset(end);
                                        tk = (PlSqlToken)tk.getNextCodeToken();
                                        end = tk.getEnd();
                                    }
                                } else {
                                    PlSqlToken tk2 = parser.getNameToken();
                                    end = tk2.getEnd();
                                }
                            } else if (refObj instanceof PlSqlDatum || refObj instanceof PlSqlDatatype) {
                                void var11_25;
                                PlSqlToken plSqlToken = parser.getTokenAtOffset(start);
                                int parens = 0;
                                while (!(var11_25.getType() == Token.Type.END_MARKER || parens == 0 && (var11_25.matches(RPAREN) || var11_25.matches(COMMA) || var11_25.matches(SEMICOLON)))) {
                                    if (var11_25.matches(LPAREN)) {
                                        ++parens;
                                    } else if (var11_25.matches(RPAREN)) {
                                        --parens;
                                    }
                                    end = var11_25.getEnd();
                                    PlSqlToken plSqlToken2 = (PlSqlToken)var11_25.getNextCodeToken();
                                }
                            }
                            if (start <= end) {
                                void var11_29;
                                PlSqlToken plSqlToken = parser.getTokenAtOffset(start);
                                boolean nameFound = false;
                                while (var11_29.getStart() <= end) {
                                    PlSqlToken plSqlToken3;
                                    DBObjectPlSqlFragment dec = codeFrag.getDeclarationAtOffset(var11_29.getStart());
                                    PlSqlReference ref = (PlSqlReference)codeFrag.getReferenceAtOffset(var11_29.getStart());
                                    if (ref != null && !(ref.getReferenceID() instanceof DataTypeID) && (dec == null || ModelUtil.areDifferent((Object)dec.getStartOffset(), (Object)ref.getStartOffset()))) {
                                        this.addLink(sb, var11_29.getSource(), ref.getReferenceID());
                                    } else if (var11_29.matches(this.getName(refObj)) && !nameFound) {
                                        sb.append(BOLD);
                                        sb.append(var11_29.getSource());
                                        sb.append(BOLD_END);
                                        nameFound = true;
                                    } else {
                                        sb.append(var11_29.getSource());
                                    }
                                    if (!(plSqlToken3 = (PlSqlToken)var11_29.getNextToken()).isEndMarker()) continue;
                                    break;
                                }
                                definitionAdded = true;
                                sb.append(DOUBLE_NEW_LINE);
                            }
                        }
                    } else if (refObj instanceof Column) {
                        sb.append(this.getType(refObj));
                        sb.append(SPACE);
                        sb.append(this.getColumnDetails((Column)refObj, false));
                        definitionAdded = true;
                        sb.append(DOUBLE_NEW_LINE);
                    } else if (refObj instanceof BuiltInFunction) {
                        this.addBuiltInFunctionDoc(sb, (BuiltInFunction)refObj, this.m_pro);
                        definitionAdded = true;
                    }
                    if (!definitionAdded) {
                        sb.append(this.getType(refObj));
                        sb.append(SPACE);
                        sb.append(BOLD);
                        sb.append(this.getName(refObj));
                        sb.append(BOLD_END);
                        sb.append(DOUBLE_NEW_LINE);
                    }
                    if (this.m_anchor == null) {
                        if (refObj instanceof Relation) {
                            this.addLink(sb, DBTypeDisplayRegistry.getDisplayName("COLUMN"), this.m_id, COLUMNS_ANCHOR);
                            sb.append(DOUBLE_NEW_LINE);
                        } else if (refObj instanceof PlSqlBlock && !(refObj instanceof PlSqlSubProgram)) {
                            this.addLink(sb, DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"), this.m_id, METHODS_ANCHOR);
                            sb.append(SPACE);
                            this.addLink(sb, DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"), this.m_id, ATTRIBUTES_ANCHOR);
                            sb.append(DOUBLE_NEW_LINE);
                        }
                    } else {
                        Boolean childrenFound = null;
                        if (COLUMNS_ANCHOR.equals(this.m_anchor)) {
                            if (refObj instanceof Relation) {
                                childrenFound = Boolean.FALSE;
                                sb.append(DBTypeDisplayRegistry.getDisplayName("COLUMN"));
                                sb.append(NEW_LINE);
                                for (Column col : ((Relation)refObj).getColumns()) {
                                    sb.append(this.getColumnDetails(col, true));
                                    sb.append(NEW_LINE);
                                    childrenFound = Boolean.TRUE;
                                }
                            }
                        } else if (refObj instanceof PlSqlBlock && !(refObj instanceof PlSqlSubProgram)) {
                            PlSqlBlock block = (PlSqlBlock)refObj;
                            if (METHODS_ANCHOR.equals(this.m_anchor)) {
                                childrenFound = Boolean.FALSE;
                                sb.append(DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"));
                                sb.append(SPACE);
                                this.addLink(sb, DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"), this.m_id, ATTRIBUTES_ANCHOR);
                                sb.append(DOUBLE_NEW_LINE);
                                for (PlSqlSubProgram plSqlSubProgram : block.getSubPrograms()) {
                                    this.addLink(sb, this.getName((DBObject)plSqlSubProgram), plSqlSubProgram.getID());
                                    sb.append(NEW_LINE);
                                    childrenFound = Boolean.TRUE;
                                }
                            } else if (ATTRIBUTES_ANCHOR.equals(this.m_anchor)) {
                                childrenFound = Boolean.FALSE;
                                this.addLink(sb, DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"), this.m_id, METHODS_ANCHOR);
                                sb.append(SPACE);
                                sb.append(DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"));
                                sb.append(DOUBLE_NEW_LINE);
                                for (PlSqlSubProgram plSqlSubProgram : block.getVariables()) {
                                    this.addLink(sb, this.getName((DBObject)plSqlSubProgram), plSqlSubProgram.getID());
                                    sb.append(NEW_LINE);
                                    childrenFound = Boolean.TRUE;
                                }
                            }
                        }
                        if (childrenFound != null) {
                            if (!childrenFound.booleanValue()) {
                                sb.append(UIBundle.get("PLSQL_DOC_NONE"));
                            }
                            sb.append(NEW_LINE);
                        }
                    }
                    boolean preformat = true;
                    if (refObj instanceof PlSqlCodeFragment) {
                        PlSqlSourceObject so;
                        PlSqlCodeFragment codeFrag = (PlSqlCodeFragment)refObj;
                        PlSqlComment comment = this.getPrecedingComment(codeFrag);
                        if (comment == null && (so = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)codeFrag)) instanceof PlSqlSchemaObjectBody) {
                            PlSqlSchemaObjectBody body = (PlSqlSchemaObjectBody)so;
                            ReferenceID referenceID = new ReferenceID((DBObject)codeFrag, this.m_pro);
                            ReferenceID otherID = (ReferenceID)ReferenceID.copyWithNewType((AbstractDBObjectID)referenceID, Collections.singletonMap(so.getType(), PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)body)));
                            PlSqlCodeFragment otherCodeFrag = null;
                            try {
                                otherCodeFrag = (PlSqlCodeFragment)otherID.resolveID();
                                if (otherCodeFrag != null) {
                                    comment = this.getPrecedingComment(otherCodeFrag);
                                }
                            }
                            catch (DBException e) {
                                DBLog.getLogger((Object)this).fine(e.getMessage());
                            }
                        }
                        if (comment != null) {
                            sb.append(BOLD);
                            sb.append(UIBundle.get("PLSQL_DOC_COMMENTS"));
                            sb.append(BOLD_END);
                            sb.append(DOUBLE_NEW_LINE);
                            for (int i = 0; i < this.getLineOfset((DBObjectPlSqlFragment)comment); ++i) {
                                sb.append(SPACE);
                            }
                            String comm2 = this.tidyComment(comment.getText(), preformat);
                            sb.append(comm2);
                            sb.append(NEW_LINE);
                        }
                    } else if (refObj != null && (comm = this.tidyComment((String)refObj.getProperty("Comment"), preformat)) != null) {
                        sb.append(BOLD);
                        sb.append(UIBundle.get("PLSQL_DOC_COMMENTS"));
                        sb.append(BOLD_END);
                        sb.append(DOUBLE_NEW_LINE);
                        sb.append(comm);
                        sb.append(NEW_LINE);
                    }
                }
                if (sb.length() == textLength) {
                    sb.append(UIBundle.get("NO_PLSQL_DOC_AVAILABLE"));
                    sb.append(NEW_LINE);
                }
                sb.insert(0, PREFORMAT);
                sb.append(PREFORMAT_END);
                this.m_content = sb.toString();
            }
        }
        return this.m_content;
    }

    public void navigate(HtmlPopupView popupView, String href) {
        String[] chunks = href.split(HASH);
        String anchor = null;
        if (chunks.length > 1) {
            anchor = chunks[1];
        }
        BaseObjectID id = BaseObjectID.createFromString((String)chunks[0]);
        id.setProvider(this.m_pro);
        DBObjectID currTopID = this.m_id == null ? null : DBUtil.getUppermostParent((DBObjectID)this.m_id);
        DBObjectID refTopID = DBUtil.getUppermostParent((DBObjectID)id);
        BaseDBObjectTextNode newNode = null;
        if (refTopID.equals(currTopID)) {
            newNode = this.m_node;
        } else {
            try {
                URL url;
                DBObject refObj = refTopID.resolveID();
                if (refObj instanceof PlSqlSourceObject && (url = DBURLFactory.getURL(this.m_pro, (SystemObject)((PlSqlSourceObject)refObj))) != null) {
                    try {
                        newNode = (BaseDBObjectTextNode)NodeFactory.findOrCreate((URL)url);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).fine("failed to find other node: " + e.getMessage());
                        newNode = null;
                    }
                }
            }
            catch (DBException e) {
                if (!(e instanceof CancelledException)) {
                    DBLog.getLogger((Object)this).fine("failed to resolve ID: " + e.getMessage());
                }
                return;
            }
        }
        PlSqlPopupContentProvider next = new PlSqlPopupContentProvider(this.m_pro, (DBObjectID)id, anchor, newNode, 0);
        popupView.push((HtmlContentProvider)next);
    }

    public boolean isError() {
        return false;
    }

    private String getName(DBObject obj) {
        if (obj == null) {
            return "";
        }
        String name = obj.getName();
        if (name != null && obj instanceof PlSqlSubProgram) {
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)name, (String[])new String[0]);
            name = tk.getSource();
        }
        if (this.m_pro != null) {
            name = this.m_pro.getExternalName(name);
        }
        return name;
    }

    private String getType(DBObject obj) {
        String type = obj.getType();
        if (obj instanceof PlSqlSubProgram) {
            PlSqlSubProgram sub = (PlSqlSubProgram)obj;
            type = sub.getReturnTypeReference() == null ? "PROCEDURE" : "FUNCTION";
        }
        return DBTypeDisplayRegistry.getSingularDisplayName(type);
    }

    private String tidyComment(String comments, boolean preformat) {
        if (comments != null) {
            comments = comments.trim();
            if (preformat) {
                comments = comments.replace("&", "&amp;");
                comments = comments.replace("<", "&lt;");
                comments = comments.replace(">", "&gt;");
            }
        }
        return comments;
    }

    private String getColumnDetails(Column col, boolean withLink) {
        Object def;
        DataTypeUsage dtu;
        StringBuilder sb = new StringBuilder();
        if (withLink) {
            this.addLink(sb, this.getName((DBObject)col), col.getID());
        } else {
            sb.append(BOLD);
            sb.append(this.getName((DBObject)col));
            sb.append(BOLD_END);
        }
        if (col.isNotNull()) {
            sb.append(" NOT NULL");
        }
        if ((dtu = col.getDataTypeUsage()) != null) {
            sb.append(SPACE);
            sb.append(DataTypeHelper.getDDL((DataTypeUsage)dtu, (DBObjectProvider)this.m_pro));
        }
        if ((def = col.getDefault()) instanceof String) {
            sb.append(" DEFAULT ");
            sb.append((String)def);
        }
        return sb.toString();
    }

    private void addLink(StringBuilder sb, String text, DBObjectID linkID) {
        this.addLink(sb, text, linkID, null);
    }

    private void addLink(StringBuilder sb, String text, DBObjectID linkID, String anchor) {
        sb.append("<a href=\"");
        sb.append(linkID.toString().replace("\"", "&quot;"));
        if (anchor != null) {
            sb.append(HASH);
            sb.append(anchor);
        }
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
    }

    private PlSqlComment getPrecedingComment(PlSqlCodeFragment frag) throws CancelledException {
        PlSqlParser parser;
        PlSqlCodeFragment top = (PlSqlCodeFragment)DBUtil.getSystemObject((DBObject)frag);
        if (top instanceof PlSqlSourceObject && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)top), (DBObjectProvider)this.m_pro)) != null) {
            PlSqlToken tk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
            tk = (PlSqlToken)tk.getPrevToken();
            while (tk.getType() == Token.Type.WHITESPACE || frag instanceof PlSqlSourceObject && (tk.matches("create") || tk.matches("or") || tk.matches("replace"))) {
                tk = (PlSqlToken)tk.getPrevToken();
            }
            if (tk.getType() == Token.Type.SINGLE_LINE_COMMENT || tk.getType() == Token.Type.MULTI_LINE_COMMENT) {
                for (PlSqlComment comm : top.getComments()) {
                    if (comm.getStartOffset() > tk.getStart() || comm.getEndOffset() < tk.getEnd()) continue;
                    return comm;
                }
            }
        }
        return null;
    }

    private void addBuiltInFunctionDoc(StringBuilder sb, BuiltInFunction refObj, DBObjectProvider pro) {
        sb.append(this.getType((DBObject)refObj));
        sb.append(SPACE);
        sb.append(BOLD);
        sb.append(this.getName((DBObject)refObj));
        sb.append(BOLD_END);
        sb.append(NEW_LINE);
        String desc = refObj.getDescription();
        if (ModelUtil.hasLength((String)desc)) {
            sb.append(NEW_LINE);
            sb.append(desc);
        }
        HashMap<String, BIFHolder> map = new HashMap<String, BIFHolder>();
        for (BuiltInFunction bif : pro.getDescriptor().listBuiltInFunctions(refObj.getName())) {
            String sig = bif.getSignature(true);
            BIFHolder bh = (BIFHolder)map.get(sig = sig.substring(0, sig.lastIndexOf("/")));
            if (bh == null) {
                bh = new BIFHolder();
                bh.m_bif = bif;
                map.put(sig, bh);
            }
            if (bif.isAggregate()) {
                bh.m_aggregate = true;
            }
            if (!bif.isWindow()) continue;
            bh.m_window = true;
        }
        for (BIFHolder bh : map.values()) {
            sb.append(NEW_LINE);
            BuiltInFunction bif = bh.m_bif;
            sb.append(bif.getName());
            if (bif.isParenthesesRequired()) {
                sb.append(LPAREN);
            }
            int i = 1;
            for (BuiltInFunctionArgument arg : bif.getArguments()) {
                if (arg.isOptional()) {
                    sb.append("[");
                }
                if (i != 1) {
                    sb.append(", ");
                }
                sb.append(ARG_PREFIX);
                sb.append(i++);
                if (!arg.isOptional()) continue;
                sb.append("]");
            }
            if (bif.isVariableArgumentList()) {
                sb.append("[");
                if (i != 1) {
                    sb.append(", ");
                }
                sb.append("...]");
            }
            if (bif.isParenthesesRequired()) {
                sb.append(RPAREN);
            }
            Integer argNo = bif.getArgumentDefiningReturnType();
            DBObjectID retType = bif.getReturnTypeID();
            if (argNo != null) {
                sb.append(NEW_LINE);
                sb.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_RETURN_TYPE_DERIVED"));
                sb.append(SPACE);
                sb.append(ARG_PREFIX);
                sb.append(argNo);
            } else if (retType != null) {
                sb.append(NEW_LINE);
                sb.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_RETURN_TYPE"));
                sb.append(SPACE);
                sb.append(DBUtil.getDBObjectName((DBObjectID)retType));
            }
            i = 1;
            for (BuiltInFunctionArgument arg : bif.getArguments()) {
                DBObjectID dtid = arg.getDataTypeID();
                if (dtid != null) {
                    sb.append(NEW_LINE);
                    sb.append(ARG_PREFIX);
                    sb.append(i);
                    sb.append(": ");
                    sb.append(DBUtil.getDBObjectName((DBObjectID)dtid));
                }
                ++i;
            }
            if (bh.m_aggregate) {
                sb.append(NEW_LINE);
                sb.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_AGGREGATE"));
                continue;
            }
            if (!bh.m_window) continue;
            sb.append(NEW_LINE);
            sb.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_WINDOWING"));
        }
    }

    private int getLineOfset(DBObjectPlSqlFragment frag) {
        int lineStart;
        int fragStart = frag.getStartOffset();
        if (this.m_node != null) {
            LineMap lm = this.m_node.acquireTextBuffer().getLineMap();
            int line = lm.getLineFromOffset(frag.getStartOffset().intValue());
            lineStart = lm.getLineStartOffset(line);
        } else {
            lineStart = 0;
        }
        int ret = fragStart - lineStart;
        if (ret > 10) {
            ret = 10;
        }
        return ret;
    }

    private static class BIFHolder {
        BuiltInFunction m_bif;
        boolean m_aggregate;
        boolean m_window;

        private BIFHolder() {
        }
    }
}

