/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;

public class TreeNodeMaker {
    private boolean m_showChildren;
    private String[] m_childTypes;
    private boolean m_fkDeep;
    private final JTree m_tree;
    private ExecutorService m_es;

    public TreeNodeMaker() {
        this.m_tree = null;
        this.m_es = null;
    }

    public TreeNodeMaker(JTree tree) {
        if (tree != null && tree.getModel() instanceof DefaultTreeModel) {
            this.m_tree = tree;
            this.m_es = Executors.newSingleThreadExecutor();
            this.m_tree.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    List<Runnable> runnables = TreeNodeMaker.this.m_es.shutdownNow();
                    for (Runnable runnable : runnables) {
                        ((NodeExpander)runnable).clearNode();
                    }
                    TreeNodeMaker.this.m_es = Executors.newSingleThreadExecutor();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        } else {
            this.m_tree = null;
            this.m_es = null;
        }
    }

    public TreeNodeMaker(boolean showChildren) {
        this.m_showChildren = showChildren;
        this.m_tree = null;
        this.m_es = null;
    }

    public TreeNodeMaker(boolean showChildren, String[] childTypes) {
        this.m_showChildren = showChildren;
        this.m_tree = null;
        this.m_es = null;
        this.setChildTypes(childTypes);
    }

    public void setShowChildren(boolean boo) {
        this.m_showChildren = boo;
    }

    public boolean getShowChildren() {
        return this.m_showChildren;
    }

    public void setChildTypes(String[] childTypes) {
        this.m_childTypes = childTypes;
        if (this.m_childTypes != null && this.m_childTypes.length == 0) {
            this.m_childTypes = null;
        }
    }

    public void setDeepFKs(boolean boo) {
        this.m_fkDeep = boo;
    }

    public DefaultMutableTreeNode createTreeNode(DBObject obj) {
        boolean lazy = false;
        if (this.m_showChildren) {
            boolean bl = lazy = obj instanceof Relation || obj instanceof Synonym;
        }
        if (!lazy && this.m_fkDeep) {
            lazy = obj instanceof FKConstraint;
        }
        if (lazy) {
            return new LazyTreeNode(obj);
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        return node;
    }

    private void createChildNodes(DBObject parent, DefaultMutableTreeNode node) {
        node.add(new DefaultMutableTreeNode(UIBundle.get("DBOBJECT_TREE_LOADING_NODE")));
        NodeExpander ne = new NodeExpander(parent, node);
        if (this.m_tree != null) {
            this.m_es.execute(ne);
        } else {
            ne.expandNode();
        }
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment obj) {
        return this.createTreeNode(obj, false);
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment obj, boolean showAvailKids) {
        DefaultMutableTreeNode node;
        block10: {
            SQLFragment exp;
            block11: {
                SchemaObject refObj;
                node = new DefaultMutableTreeNode(obj);
                if (obj instanceof FromObject && this.m_showChildren && (exp = ((FromObject)obj).getExpression()) instanceof JoinObject) {
                    DefaultMutableTreeNode leftnode = this.createTreeNode((SQLFragment)((JoinObject)exp).getLeftExpression());
                    DefaultMutableTreeNode rightnode = this.createTreeNode((SQLFragment)((JoinObject)exp).getRightExpression());
                    node.add(leftnode);
                    node.add(rightnode);
                }
                if (!showAvailKids || !(obj instanceof FromObject) || (exp = ((FromObject)obj).getExpression()) == null) break block10;
                if (!(exp instanceof DBObjectUsage)) break block11;
                Relation rel = null;
                if (exp instanceof RelationUsage) {
                    DBObjectID id = ((RelationUsage)exp).getObjectID();
                    if (id != null) {
                        try {
                            rel = (Relation)id.resolveID();
                        }
                        catch (DBException dbe) {
                            DBLog.getLogger((Object)this).warning("Couldn't resolve relation : " + dbe.getMessage());
                        }
                    }
                } else if (exp instanceof SynonymUsage && (refObj = ((SynonymUsage)exp).getReferencedObject()) instanceof Relation) {
                    rel = (Relation)refObj;
                }
                if (rel == null) break block10;
                Column[] cols = rel.getColumns();
                for (int i = 0; cols != null && i < cols.length; ++i) {
                    node.add(this.createTreeNode((DBObject)cols[i]));
                }
                break block10;
            }
            if (exp instanceof SQLQuery) {
                SelectObject[] sels = ((SQLQuery)exp).getSelectObjects();
                for (int i = 0; i < sels.length; ++i) {
                    node.add(this.createTreeNode((SQLFragment)new SelectObjectUsage(sels[i], (FromObject)obj)));
                }
            }
        }
        return node;
    }

    public static int indexOfNode(DefaultMutableTreeNode node, DefaultMutableTreeNode parent) {
        int i = 0;
        int retval = -1;
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            if (next == node) {
                retval = i;
                break;
            }
            ++i;
        }
        return retval;
    }

    public static DefaultMutableTreeNode findNode(Object userObject, DefaultMutableTreeNode root) {
        int i = 0;
        DefaultMutableTreeNode retval = null;
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.getUserObject() == userObject) {
                retval = node;
                break;
            }
            ++i;
        }
        return retval;
    }

    public static void expandAll(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    private class NodeExpander
    implements Runnable {
        final DBObject m_parent;
        final DefaultMutableTreeNode m_node;

        public NodeExpander(DBObject parent, DefaultMutableTreeNode node) {
            this.m_parent = parent;
            this.m_node = node;
        }

        @Override
        public void run() {
            this.expandNode();
        }

        public void expandNode() {
            block11: {
                try {
                    DBObject[] kids;
                    final ArrayList<DefaultMutableTreeNode> childNodes = new ArrayList<DefaultMutableTreeNode>();
                    DBObject obj = this.m_parent;
                    String[] childTypes = TreeNodeMaker.this.m_childTypes;
                    this.checkThread();
                    if (obj instanceof Synonym) {
                        if (childTypes != null) {
                            ArrayList<String> ctypelist = new ArrayList<String>(Arrays.asList(childTypes));
                            ctypelist.remove("FKConstraint");
                            childTypes = ctypelist.toArray(new String[ctypelist.size()]);
                        }
                        SchemaObject refObj = DBUtil.getSynonymReference((Synonym)((Synonym)obj));
                        obj = refObj;
                    }
                    if (childTypes == null) {
                        kids = obj.getOwnedObjects();
                        this.checkThread();
                        for (int i = 0; i < kids.length; ++i) {
                            DefaultMutableTreeNode newNode = TreeNodeMaker.this.createTreeNode(kids[i]);
                            if (newNode == null) continue;
                            childNodes.add(newNode);
                        }
                    } else if (childTypes.length > 0) {
                        kids = obj.getOwnedObjects(childTypes);
                        this.checkThread();
                        for (int j = 0; j < kids.length; ++j) {
                            DefaultMutableTreeNode newNode = TreeNodeMaker.this.createTreeNode(kids[j]);
                            if (newNode == null) continue;
                            childNodes.add(newNode);
                        }
                    }
                    Runnable addNodesRunnable = new Runnable(){

                        @Override
                        public void run() {
                            NodeExpander.this.m_node.removeAllChildren();
                            for (MutableTreeNode childNode : childNodes) {
                                NodeExpander.this.m_node.add(childNode);
                            }
                            if (TreeNodeMaker.this.m_tree != null) {
                                ((DefaultTreeModel)TreeNodeMaker.this.m_tree.getModel()).nodeStructureChanged(NodeExpander.this.m_node);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        addNodesRunnable.run();
                    } else {
                        SwingUtilities.invokeLater(addNodesRunnable);
                    }
                }
                catch (Exception ex) {
                    this.clearNode();
                    if (ex instanceof InterruptedException) break block11;
                    DBLog.getLogger((Object)TreeNodeMaker.this).log(Level.SEVERE, UIBundle.get("DBOBJECT_TREE_LOADING_ERROR_TITLE"), ex);
                }
            }
        }

        public void clearNode() {
            if (this.m_node instanceof LazyTreeNode) {
                this.m_node.removeAllChildren();
                TreeNodeMaker.this.m_tree.collapsePath(new TreePath(this.m_node.getPath()));
                ((LazyTreeNode)this.m_node).m_init = false;
            }
        }

        private void checkThread() throws InterruptedException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
    }

    private class LazyTreeNode
    extends DefaultMutableTreeNode {
        private boolean m_init;

        LazyTreeNode(DBObject obj) {
            super(obj);
        }

        private void init() {
            if (!this.m_init) {
                try {
                    this.m_init = true;
                    DBObject obj = (DBObject)this.getUserObject();
                    if (obj instanceof FKConstraint) {
                        DBObjectID id;
                        DBObject refobj;
                        if (TreeNodeMaker.this.m_fkDeep && (refobj = (id = ((FKConstraint)obj).getReferenceID()).resolveID()) != null && refobj instanceof Constraint) {
                            this.add(TreeNodeMaker.this.createTreeNode((DBObject)((Constraint)refobj).getRelation()));
                        }
                    } else if (TreeNodeMaker.this.m_showChildren) {
                        TreeNodeMaker.this.createChildNodes(obj, this);
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)this).warning("Couldn't resolve fk " + dbe.getMessage());
                }
            }
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        @Override
        public TreeNode getChildAfter(TreeNode aChild) {
            this.init();
            return super.getChildAfter(aChild);
        }

        @Override
        public TreeNode getChildAt(int index) {
            this.init();
            return super.getChildAt(index);
        }

        @Override
        public TreeNode getChildBefore(TreeNode aChild) {
            this.init();
            return super.getChildBefore(aChild);
        }

        @Override
        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        @Override
        public TreeNode getLastChild() {
            this.init();
            return super.getLastChild();
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            this.init();
            super.insert(newChild, childIndex);
        }

        @Override
        public boolean isLeaf() {
            if (this.m_init) {
                return super.isLeaf();
            }
            return false;
        }
    }
}

