/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;

public class SchemaPanel
extends DefaultTraversablePanel
implements ItemListener {
    private GridBagLayout layCenter = new GridBagLayout();
    private JLabel m_lblSchemaName = new JLabel();
    private JTextField m_txtSchemaName = new JTextField();
    private DBObjectRenderer renderer = new DBObjectRenderer();

    public SchemaPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SchemaPanel");
        reshelp.resLabel(this.m_lblSchemaName, this.m_txtSchemaName, UIBundle.get("SCHEMA_INFO_LABEL_SCHEMA_NAME"), "Schema");
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_txtSchemaName, new GridBagConstraints(20, 20, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIBundle.get("SCHEMA_HEADER");
    }

    public String getHeaderDescription() {
        return UIBundle.get("SCHEMA_HEADER_DESC");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider provider = (DBObjectProvider)dataContext.find("oracle.javatools.db.DBObjectProvider");
        Schema schema = (Schema)dataContext.find("NewObject");
        this.init(provider, schema);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            callbacks.wizardSetInitialFocus((Component)this.m_txtSchemaName);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DBObjectProvider provider = (DBObjectProvider)dataContext.find("oracle.javatools.db.DBObjectProvider");
        Schema schema = (Schema)dataContext.find("NewObject");
        String schemaName = this.m_txtSchemaName.getText();
        if (provider != null) {
            try {
                provider.validateName("SCHEMA", schemaName);
            }
            catch (InvalidNameException e) {
                throw new TraversalException(e.getMessage());
            }
            if (schema != null) {
                schema.setName(provider.getInternalName(schemaName));
            }
        }
    }

    private void init(DBObjectProvider provider, Schema model) {
        this.renderer.setProvider(provider);
        this.m_txtSchemaName.setText(provider.getExternalName(model.getName(), "SCHEMA"));
        this.m_txtSchemaName.setEnabled(true);
    }
}

