/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.List;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

class DeclarativeSQLQueryParentLocator
extends ParentLocator {
    DeclarativeSQLQueryParentLocator() {
    }

    @Override
    protected DBObject getParent(List<String> names) throws CancelledException {
        if (names.size() == 1) {
            SQLQuery query;
            String alias = names.get(0);
            if (this.getContextObjectAtOffset() instanceof SQLQuery && (query = (SQLQuery)this.getContextObjectAtOffset()).isDeclarative()) {
                for (FromObject fo : query.getFromObjects()) {
                    AbstractSchemaObjectUsage sou;
                    DBObject obj;
                    SQLFragment sf;
                    CancelledException.checkInterrupt();
                    String foAlias = fo.getAlias();
                    if (foAlias != null) {
                        foAlias = this.getProvider().getInternalName(foAlias);
                    }
                    if (!ModelUtil.areEqual((Object)alias, (Object)foAlias) || !((sf = fo.getExpression()) instanceof AbstractSchemaObjectUsage) || !((obj = DBInsightProvider.resolveIDForInsight((sou = (AbstractSchemaObjectUsage)sf).getObjectID())) instanceof SchemaObject)) continue;
                    SchemaObject so = (SchemaObject)obj;
                    names.clear();
                    names.add(so.getSchema().getName());
                    names.add(so.getName());
                    break;
                }
            }
        }
        return super.getParent(names);
    }
}

