/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.ide.db.controls.AbstractSizeChooser;
import oracle.ide.db.controls.TerabyteSizeChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;

public class TerabyteSizeChooserUnlimited
extends JPanel {
    private final JCheckBox m_chkUnlimited = new JCheckBox();
    private final TerabyteSizeChooser m_sizeChooser = new TerabyteSizeChooser();
    private final List<ChangeListener> m_listeners = new ArrayList<ChangeListener>();

    public TerabyteSizeChooserUnlimited() {
        this.init();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init() {
        this.m_chkUnlimited.setText(UIBundle.get("FILE_SPECS_INFO_LABEL_UNLIMITED_MAX_SIZE"));
        this.m_chkUnlimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                TerabyteSizeChooserUnlimited.this.m_sizeChooser.setEnabled(!((JCheckBox)src).isSelected());
                TerabyteSizeChooserUnlimited.this.notifyListeners();
            }
        });
        this.m_sizeChooser.addChangeListener(new AbstractSizeChooser.ChangeListener(){

            @Override
            public void chooserChanged(AbstractSizeChooser chooser) {
                TerabyteSizeChooserUnlimited.this.notifyListeners();
            }
        });
    }

    @Override
    public final void setName(String name) {
        this.m_sizeChooser.setName(name);
        this.m_chkUnlimited.setName(name + "_UNLIMITED");
    }

    public void setNumber(Number n) {
        if (n != null && n.equals(BigInteger.ZERO)) {
            this.m_chkUnlimited.setSelected(true);
            this.m_sizeChooser.setNumber(null);
            this.m_sizeChooser.setEnabled(false);
        } else {
            this.m_chkUnlimited.setSelected(false);
            this.m_sizeChooser.setNumber(n);
        }
    }

    public Number getNumber() {
        Number retval = this.m_chkUnlimited.isSelected() ? BigInteger.ZERO : this.m_sizeChooser.getNumber();
        return retval;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_chkUnlimited.setEnabled(enabled);
        this.m_sizeChooser.setEnabled(enabled && !this.m_chkUnlimited.isSelected());
    }

    @Override
    public boolean isEnabled() {
        return this.m_sizeChooser.isEnabled();
    }

    private void layoutComponents() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this);
        layout.setMargins(0);
        layout.add(this.m_sizeChooser);
        layout.add(this.m_chkUnlimited);
        layout.layout();
    }

    public final void addChangeListener(ChangeListener l) {
        this.m_listeners.add(l);
    }

    public Document getDocument() {
        return this.m_sizeChooser.getDocument();
    }

    public final void removeChangeListener(ChangeListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyListeners() {
        for (ChangeListener cl : this.m_listeners) {
            cl.chooserChanged(this);
        }
    }

    public static interface ChangeListener {
        public void chooserChanged(TerabyteSizeChooserUnlimited var1);
    }
}

