/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;

public abstract class DBTypeDisplayRegistryEntry {
    private Map<String, TypeEntry> m_typeEntries;

    protected final TypeEntry getEntry(String type) {
        this.checkInit();
        return this.m_typeEntries.get(type);
    }

    public void registerType(String type, String displayName, String singularDisplayName, String newMenuText, Icon folderIcon, Icon nodeIcon) {
        this.m_typeEntries.put(type, new TypeEntry(displayName, singularDisplayName, newMenuText, folderIcon, nodeIcon));
    }

    public void registerType(String type, String displayName, String singularDisplayName, String newMenuText, String nodeIconKey) {
        this.registerType(type, displayName, singularDisplayName, newMenuText, null, nodeIconKey);
    }

    public void registerType(String type, String displayName, String singularDisplayName, String newMenuText, String folderIconKey, String nodeIconKey) {
        this.m_typeEntries.put(type, new TypeEntry(displayName, singularDisplayName, newMenuText, folderIconKey, nodeIconKey));
    }

    private void checkInit() {
        if (this.m_typeEntries == null) {
            this.m_typeEntries = new HashMap<String, TypeEntry>();
            this.populateEntries();
        }
    }

    protected abstract void populateEntries();

    public String getDisplayName(String type) {
        TypeEntry entry = this.getEntry(type);
        String retval = null;
        if (entry != null) {
            retval = entry.getDisplayName();
        }
        return retval;
    }

    public String getSingularDisplayName(String type) {
        TypeEntry entry = this.getEntry(type);
        String retval = null;
        if (entry != null) {
            retval = entry.getSingularDisplayName();
        }
        return retval;
    }

    public Icon getNodeIcon(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getNodeIcon();
    }

    public Icon getFolderIcon(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getFolderIcon();
    }

    public String getNewMenuItemText(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getNewMenuItemText();
    }

    private static class TypeEntry {
        private final String m_displayName;
        private final String m_singularDisplayName;
        private final String m_newMenuText;
        private Icon m_folderIcon;
        private String m_folderIconKey;
        private Icon m_nodeIcon;
        private String m_nodeIconKey;

        protected TypeEntry(String displayName, String singularDisplayName, String newMenuText, Icon folderIcon, Icon nodeIcon) {
            this.m_displayName = displayName;
            this.m_singularDisplayName = singularDisplayName;
            this.m_folderIcon = folderIcon;
            this.m_nodeIcon = nodeIcon;
            this.m_newMenuText = newMenuText;
        }

        protected TypeEntry(String displayName, String singularDisplayName, String newMenuText, String folderIconKey, String nodeIconKey) {
            this.m_displayName = displayName;
            this.m_singularDisplayName = singularDisplayName;
            this.m_folderIconKey = folderIconKey;
            this.m_nodeIconKey = nodeIconKey;
            this.m_newMenuText = newMenuText;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getSingularDisplayName() {
            return this.m_singularDisplayName;
        }

        public String getNewMenuItemText() {
            return this.m_newMenuText;
        }

        private Icon getFromOracleIcons(String key, Icon defIcon, String what) {
            if (key != null) {
                try {
                    return OracleIcons.getIcon((String)key);
                }
                catch (OracleIcons.IconNotFoundException infe) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, "{0} {1} not found in OracleIcons", new Object[]{what, key});
                }
            }
            return defIcon;
        }

        public Icon getFolderIcon() {
            return this.getFromOracleIcons(this.m_folderIconKey, this.m_folderIcon, "Folder Icon");
        }

        public Icon getNodeIcon() {
            return this.getFromOracleIcons(this.m_nodeIconKey, this.m_nodeIcon, "Node Icon");
        }
    }
}

