/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.adfdtinternal.model.dvt.util.gui.InsertButton;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.SeparatorBorderPainter;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.HeaderAndFooterPainter;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;

public class PageSetupHeaderFooterPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
HelpContext,
FocusListener {
    private ResourceBundle rBundle = null;
    protected Locale m_locale = null;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_applicationName;
    protected JButton m_insertHeaderButton;
    protected JButton m_insertFooterButton;
    protected FontButton m_headerFontButton;
    protected FontButton m_footerFontButton;
    protected String m_translatedText;
    protected JPanel m_rightPanel;
    protected JPanel m_leftPanel;
    protected JPanel m_headerPanel;
    protected JPanel m_footerPanel;
    protected JPanel m_headerButtonPanel;
    protected JPanel m_footerButtonPanel;
    protected JLabel m_headerLabel;
    protected JLabel m_footerLabel;
    protected LineWidth m_borderBelowLineWidth;
    protected LineWidth m_borderAboveLineWidth;
    protected JTextPane m_headerTextAreaLeft;
    protected JTextPane m_headerTextAreaCenter;
    protected JTextPane m_headerTextAreaRight;
    protected JTextPane m_footerTextAreaLeft;
    protected JTextPane m_footerTextAreaCenter;
    protected JTextPane m_footerTextAreaRight;
    protected JScrollPane m_headerScrollPaneLeft;
    protected JScrollPane m_headerScrollPaneCenter;
    protected JScrollPane m_headerScrollPaneRight;
    protected JScrollPane m_footerScrollPaneLeft;
    protected JScrollPane m_footerScrollPaneCenter;
    protected JScrollPane m_footerScrollPaneRight;
    protected JPanel m_headerMultilinePanel;
    protected JPanel m_footerMultilinePanel;
    protected JPanel m_headerMultilabelPanel;
    protected JPanel m_footerMultilabelPanel;
    protected int m_lastFocus;
    protected UIViewPrinter[] m_viewPrinter;
    protected TokenSubstitution m_tokenSubstitution = null;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected boolean m_bFontNameChange = false;
    protected boolean m_bFontStyleChange = false;
    protected boolean m_bFontSizeChange = false;
    protected boolean m_bHorizontalAlignmentChange = false;
    protected Font m_Font;
    protected Font m_headerFont;
    protected Font m_footerFont;
    protected boolean m_bFontIsHeader = false;
    protected boolean m_bFontIsFooter = false;
    protected String m_eol;
    private InsertButton m_headerInsert;
    private InsertButton m_footerInsert;
    private boolean m_bSuperCalled = true;
    private int m_headerFontFocus;
    private int m_footerFontFocus;
    private static final int HF_TEXTAREA_NONE = 0;
    private static final int HF_TEXTAREA_HLEFT = 1;
    private static final int HF_TEXTAREA_HCENTER = 2;
    private static final int HF_TEXTAREA_HRIGHT = 3;
    private static final int HF_TEXTAREA_FLEFT = 4;
    private static final int HF_TEXTAREA_FCENTER = 5;
    private static final int HF_TEXTAREA_FRIGHT = 6;

    public PageSetupHeaderFooterPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupHeaderFooterPanel(UIViewPrinter[] viewPrinter) {
        this.m_viewPrinter = viewPrinter;
        this.m_tokenSubstitution = this.m_viewPrinter[0].getTokenSubstitution();
        this.m_eol = System.getProperty("line.separator");
        this.constructPanel();
        this._init();
    }

    private void constructPanel() {
        int sbutton = 3;
        int abutton = 0;
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        int iWidth = Integer.parseInt(this.rBundle.getString("HeaderFooterPanelWidth"));
        int iHeight = Integer.parseInt(this.rBundle.getString("HeaderFooterPanelHeight"));
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(iWidth, iHeight));
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_leftPanel = new JPanel();
        this.m_leftPanel.setLayout(new BoxLayout(this.m_leftPanel, 1));
        this.m_headerPanel = new JPanel();
        this.m_headerPanel.setLayout(new BoxLayout(this.m_headerPanel, 1));
        this.m_translatedText = this.rBundle.getString("HeaderLabel");
        this.m_headerLabel = new JLabel(this.m_translatedText);
        this.m_headerLabel.setMaximumSize(this.m_headerLabel.getPreferredSize());
        this.m_headerLabel.setMinimumSize(this.m_headerLabel.getPreferredSize());
        this.m_headerPanel.add(this.m_headerLabel);
        this.m_headerPanel.add(Box.createVerticalStrut(3));
        this.m_headerButtonPanel = new JPanel();
        this.m_headerButtonPanel.setLayout(new BoxLayout(this.m_headerButtonPanel, 0));
        JPanel borderSubPanel = new JPanel();
        borderSubPanel.setLayout(new BoxLayout(borderSubPanel, 0));
        this.m_translatedText = this.rBundle.getString("BorderBelow");
        JLabel borderLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        borderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        borderLabel.setMaximumSize(borderLabel.getPreferredSize());
        borderLabel.setMinimumSize(borderLabel.getPreferredSize());
        borderSubPanel.add(borderLabel);
        borderSubPanel.add(Box.createHorizontalStrut(3));
        this.m_borderBelowLineWidth = new LineWidth();
        borderSubPanel.add(this.m_borderBelowLineWidth);
        borderLabel.setLabelFor(this.m_borderBelowLineWidth);
        JPanel headerButtonSubPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.m_headerInsert = this.m_tokenSubstitution == null ? new InsertButton() : new InsertButton(this.m_tokenSubstitution.getListItems());
        if (this.m_viewPrinter[0].getLocale() != null) {
            this.m_headerInsert.setLocale(this.m_viewPrinter[0].getLocale());
        }
        this.m_headerInsert.setMaximumRowCount(4);
        this.m_headerInsert.addActionListener(this);
        this.m_translatedText = this.rBundle.getString("Header Font...");
        this.m_headerFontButton = new FontButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_headerFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_translatedText = this.rBundle.getString("Header Font Stripped");
        this.m_headerFontButton.setDialogTitle(this.m_translatedText);
        this.m_headerFontButton.setMargin(new Insets(0, 13, 0, 13));
        this.m_headerFontButton.setPaneLocale(this.m_viewPrinter[0].getLocale());
        this.m_headerFontButton.setMaximumSize(this.m_headerFontButton.getPreferredSize());
        this.m_headerFontButton.setMinimumSize(this.m_headerFontButton.getPreferredSize());
        this.m_headerFontButton.addActionListener(this);
        this.m_headerFontButton.addPropertyChangeListener(this);
        this.m_headerFontButton.setStyleButtonMask(sbutton);
        this.m_headerFontButton.setAlignmentButtonMask(abutton);
        this.m_headerFontButton.setColorComponentMask(0);
        this.m_headerInsert.setEnabled(false);
        this.m_headerFontButton.setEnabled(false);
        headerButtonSubPanel.add((Component)((Object)this.m_headerInsert));
        headerButtonSubPanel.add(Box.createHorizontalStrut(10));
        headerButtonSubPanel.add(this.m_headerFontButton);
        this.m_headerButtonPanel.add(borderSubPanel);
        this.m_headerButtonPanel.add(Box.createHorizontalGlue());
        this.m_headerButtonPanel.add(headerButtonSubPanel);
        this.m_headerButtonPanel.setMinimumSize(new Dimension(this.m_headerButtonPanel.getMinimumSize().width, this.m_headerButtonPanel.getPreferredSize().height));
        this.m_headerButtonPanel.setMaximumSize(new Dimension(this.m_headerButtonPanel.getMaximumSize().width, this.m_headerButtonPanel.getPreferredSize().height));
        final TextPanel m_headerMultilinePanel = new TextPanel();
        m_headerMultilinePanel.setLayout(new BoxLayout(m_headerMultilinePanel, 0));
        this.m_headerTextAreaLeft = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_headerMultilinePanel) {
                    m_headerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_headerTextAreaLeft.setEditable(true);
        SimpleAttributeSet hdrLeftAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(hdrLeftAttrSet, 0);
        this.m_headerTextAreaLeft.setParagraphAttributes(hdrLeftAttrSet, false);
        this.m_headerScrollPaneLeft = new JScrollPane(this.m_headerTextAreaLeft);
        this.m_headerScrollPaneLeft.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_headerScrollPaneLeft.setVerticalScrollBarPolicy(20);
        this.m_headerTextAreaCenter = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_headerMultilinePanel) {
                    m_headerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_headerTextAreaCenter.setEditable(true);
        SimpleAttributeSet hdrCenterAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(hdrCenterAttrSet, 1);
        this.m_headerTextAreaCenter.setParagraphAttributes(hdrCenterAttrSet, false);
        this.m_headerScrollPaneCenter = new JScrollPane(this.m_headerTextAreaCenter);
        this.m_headerScrollPaneCenter.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_headerScrollPaneCenter.setVerticalScrollBarPolicy(20);
        this.m_headerTextAreaRight = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_headerMultilinePanel) {
                    m_headerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_headerTextAreaRight.setEditable(true);
        SimpleAttributeSet hdrRightAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(hdrRightAttrSet, 2);
        this.m_headerTextAreaRight.setParagraphAttributes(hdrRightAttrSet, false);
        this.m_headerScrollPaneRight = new JScrollPane(this.m_headerTextAreaRight);
        this.m_headerScrollPaneRight.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_headerScrollPaneRight.setVerticalScrollBarPolicy(20);
        m_headerMultilinePanel.add(this.m_headerScrollPaneLeft);
        m_headerMultilinePanel.add(Box.createHorizontalStrut(10));
        m_headerMultilinePanel.add(this.m_headerScrollPaneCenter);
        m_headerMultilinePanel.add(Box.createHorizontalStrut(10));
        m_headerMultilinePanel.add(this.m_headerScrollPaneRight);
        this.m_headerMultilabelPanel = this.createMultiLabelPanelHeader();
        this.m_headerPanel.add(this.m_headerButtonPanel);
        this.m_headerButtonPanel.setAlignmentX(0.0f);
        this.m_headerPanel.add(this.m_headerMultilabelPanel);
        this.m_headerMultilabelPanel.setAlignmentX(0.0f);
        this.m_headerPanel.add(m_headerMultilinePanel);
        m_headerMultilinePanel.setAlignmentX(0.0f);
        this.m_footerPanel = new JPanel();
        this.m_footerPanel.setLayout(new BoxLayout(this.m_footerPanel, 1));
        this.m_translatedText = this.rBundle.getString("FooterLabel");
        this.m_footerLabel = new JLabel(this.m_translatedText);
        this.m_footerLabel.setMaximumSize(this.m_footerLabel.getPreferredSize());
        this.m_footerLabel.setMinimumSize(this.m_footerLabel.getPreferredSize());
        this.m_footerPanel.add(this.m_footerLabel);
        this.m_footerPanel.add(Box.createVerticalStrut(3));
        this.m_footerButtonPanel = new JPanel();
        this.m_footerButtonPanel.setLayout(new BoxLayout(this.m_footerButtonPanel, 0));
        JPanel borderAbovePanel = new JPanel();
        borderAbovePanel.setLayout(new BoxLayout(borderAbovePanel, 0));
        this.m_translatedText = this.rBundle.getString("BorderAbove");
        JLabel borderAboveLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        borderAboveLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        borderAboveLabel.setMaximumSize(borderAboveLabel.getPreferredSize());
        borderAboveLabel.setMinimumSize(borderAboveLabel.getPreferredSize());
        borderAbovePanel.add(borderAboveLabel);
        borderAbovePanel.add(Box.createHorizontalStrut(3));
        this.m_borderAboveLineWidth = new LineWidth();
        borderAboveLabel.setLabelFor(this.m_borderAboveLineWidth);
        borderAbovePanel.add(this.m_borderAboveLineWidth);
        JPanel footerButtonSubPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.m_footerInsert = this.m_tokenSubstitution == null ? new InsertButton() : new InsertButton(this.m_tokenSubstitution.getListItems());
        if (this.m_viewPrinter[0].getLocale() != null) {
            this.m_footerInsert.setLocale(this.m_viewPrinter[0].getLocale());
        }
        this.m_footerInsert.setType(1);
        this.m_footerInsert.setMaximumRowCount(4);
        this.m_footerInsert.addActionListener(this);
        this.m_translatedText = this.rBundle.getString("Footer Font...");
        this.m_footerFontButton = new FontButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_footerFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_translatedText = this.rBundle.getString("Footer Font Stripped");
        this.m_footerFontButton.setDialogTitle(this.m_translatedText);
        this.m_footerFontButton.setMargin(new Insets(0, 13, 0, 13));
        this.m_footerFontButton.setPaneLocale(this.m_viewPrinter[0].getLocale());
        this.m_footerFontButton.addActionListener(this);
        this.m_footerFontButton.addPropertyChangeListener(this);
        this.m_footerFontButton.setMaximumSize(this.m_footerFontButton.getPreferredSize());
        this.m_footerFontButton.setMinimumSize(this.m_footerFontButton.getPreferredSize());
        this.m_footerFontButton.setStyleButtonMask(sbutton);
        this.m_footerFontButton.setAlignmentButtonMask(abutton);
        this.m_footerFontButton.setColorComponentMask(0);
        this.m_footerInsert.setEnabled(false);
        this.m_footerFontButton.setEnabled(false);
        footerButtonSubPanel.add((Component)((Object)this.m_footerInsert));
        footerButtonSubPanel.add(Box.createHorizontalStrut(10));
        footerButtonSubPanel.add(this.m_footerFontButton);
        this.m_footerButtonPanel.add(borderAbovePanel);
        this.m_footerButtonPanel.add(Box.createHorizontalGlue());
        this.m_footerButtonPanel.add(footerButtonSubPanel);
        this.m_footerButtonPanel.setMinimumSize(new Dimension(this.m_footerButtonPanel.getMinimumSize().width, this.m_footerButtonPanel.getPreferredSize().height));
        this.m_footerButtonPanel.setMaximumSize(new Dimension(this.m_footerButtonPanel.getMaximumSize().width, this.m_footerButtonPanel.getPreferredSize().height));
        final TextPanel m_footerMultilinePanel = new TextPanel();
        m_footerMultilinePanel.setLayout(new BoxLayout(m_footerMultilinePanel, 0));
        this.m_footerTextAreaLeft = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_footerMultilinePanel) {
                    m_footerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_footerTextAreaLeft.setEditable(true);
        SimpleAttributeSet ftrLeftAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(ftrLeftAttrSet, 0);
        this.m_footerTextAreaLeft.setParagraphAttributes(ftrLeftAttrSet, false);
        this.m_footerScrollPaneLeft = new JScrollPane(this.m_footerTextAreaLeft);
        this.m_footerScrollPaneLeft.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_footerScrollPaneLeft.setVerticalScrollBarPolicy(20);
        this.m_footerTextAreaCenter = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_footerMultilinePanel) {
                    m_footerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_footerTextAreaCenter.setEditable(true);
        SimpleAttributeSet ftrCenterAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(ftrCenterAttrSet, 1);
        this.m_footerTextAreaCenter.setParagraphAttributes(ftrCenterAttrSet, false);
        this.m_footerScrollPaneCenter = new JScrollPane(this.m_footerTextAreaCenter);
        this.m_footerScrollPaneCenter.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_footerScrollPaneCenter.setVerticalScrollBarPolicy(20);
        this.m_footerTextAreaRight = new JTextPane(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() != 9) {
                    super.processKeyEvent(e);
                    return;
                }
                if (this.getParent() == m_footerMultilinePanel) {
                    m_footerMultilinePanel.processKeyEvent(e);
                    return;
                }
                if (e.getID() == 402) return;
                if (!FocusManager.isFocusManagerEnabled()) return;
                if (e.isShiftDown()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(this);
                }
                e.consume();
            }
        };
        this.m_footerTextAreaRight.setEditable(true);
        SimpleAttributeSet ftrRightAttrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(ftrRightAttrSet, 2);
        this.m_footerTextAreaRight.setParagraphAttributes(ftrRightAttrSet, false);
        this.m_footerScrollPaneRight = new JScrollPane(this.m_footerTextAreaRight);
        this.m_footerScrollPaneRight.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 66));
        this.m_footerScrollPaneRight.setVerticalScrollBarPolicy(20);
        m_footerMultilinePanel.add(this.m_footerScrollPaneLeft);
        m_footerMultilinePanel.add(Box.createHorizontalStrut(10));
        m_footerMultilinePanel.add(this.m_footerScrollPaneCenter);
        m_footerMultilinePanel.add(Box.createHorizontalStrut(10));
        m_footerMultilinePanel.add(this.m_footerScrollPaneRight);
        this.m_footerMultilabelPanel = this.createMultiLabelPanelFooter();
        this.m_footerPanel.add(this.m_footerButtonPanel);
        this.m_footerButtonPanel.setAlignmentX(0.0f);
        this.m_footerPanel.add(this.m_footerMultilabelPanel);
        this.m_footerMultilabelPanel.setAlignmentX(0.0f);
        this.m_footerPanel.add(m_footerMultilinePanel);
        m_footerMultilinePanel.setAlignmentX(0.0f);
        this.m_leftPanel.add(this.m_headerPanel);
        this.m_leftPanel.add(Box.createVerticalStrut(4));
        this.m_leftPanel.add((Component)this.createSeparator());
        this.m_leftPanel.add(Box.createVerticalStrut(4));
        this.m_leftPanel.add(this.m_footerPanel);
        this.setAlignmentX(0.0f);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setAlignmentX(0.0f);
        mainPanel.add(this.m_leftPanel);
        this.add(mainPanel);
        this.m_footerTextAreaLeft.addFocusListener(this);
        this.m_footerTextAreaRight.addFocusListener(this);
        this.m_footerTextAreaCenter.addFocusListener(this);
        this.m_headerTextAreaLeft.addFocusListener(this);
        this.m_headerTextAreaRight.addFocusListener(this);
        this.m_headerTextAreaCenter.addFocusListener(this);
        this.m_borderBelowLineWidth.addFocusListener(this);
        this.m_borderAboveLineWidth.addFocusListener(this);
        this.m_headerInsert.addFocusListener(this);
        this.m_footerInsert.addFocusListener(this);
        this.addFocusListener(this);
    }

    protected void disableButtons() {
        this.m_headerInsert.setEnabled(false);
        this.m_headerFontButton.setEnabled(false);
        this.m_footerInsert.setEnabled(false);
        this.m_footerFontButton.setEnabled(false);
    }

    protected LWComponent createSeparator() {
        LWComponent c = new LWComponent();
        BorderAdapter b = new BorderAdapter((BorderPainter)new SeparatorBorderPainter(1, false, 0));
        c.setBorder((Border)b);
        c.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 2));
        c.setMinimumSize(c.getPreferredSize());
        c.setMaximumSize(c.getPreferredSize());
        c.setAlignmentX(0.0f);
        return c;
    }

    protected JPanel createMultiLabelPanelHeader() {
        JPanel headerMultilabelPanel = new JPanel();
        headerMultilabelPanel.setLayout(new BoxLayout(headerMultilabelPanel, 0));
        this.m_translatedText = this.rBundle.getString("HLeft");
        JLabel leftLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        leftPanel.add((Component)leftLabel, "West");
        leftLabel.setLabelFor(this.m_headerTextAreaLeft);
        leftLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("HLADA"));
        this.m_translatedText = this.rBundle.getString("HCenter");
        JLabel centerLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        centerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        centerPanel.add((Component)centerLabel, "West");
        centerLabel.setLabelFor(this.m_headerTextAreaCenter);
        centerLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("HCADA"));
        this.m_translatedText = this.rBundle.getString("HRight");
        JLabel rightLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        rightPanel.add((Component)rightLabel, "West");
        rightLabel.setLabelFor(this.m_headerTextAreaRight);
        rightLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("HRADA"));
        headerMultilabelPanel.add(leftPanel);
        headerMultilabelPanel.add(Box.createHorizontalStrut(10));
        headerMultilabelPanel.add(centerPanel);
        headerMultilabelPanel.add(Box.createHorizontalStrut(10));
        headerMultilabelPanel.add(rightPanel);
        headerMultilabelPanel.setMinimumSize(new Dimension(headerMultilabelPanel.getMinimumSize().width, headerMultilabelPanel.getPreferredSize().height));
        headerMultilabelPanel.setMaximumSize(new Dimension(headerMultilabelPanel.getMaximumSize().width, headerMultilabelPanel.getPreferredSize().height));
        return headerMultilabelPanel;
    }

    protected JPanel createMultiLabelPanelFooter() {
        JPanel footerMultilabelPanel = new JPanel();
        footerMultilabelPanel.setLayout(new BoxLayout(footerMultilabelPanel, 0));
        this.m_translatedText = this.rBundle.getString("FLeft");
        JLabel leftLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        leftPanel.add((Component)leftLabel, "West");
        leftLabel.setLabelFor(this.m_footerTextAreaLeft);
        leftLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("FLADA"));
        this.m_translatedText = this.rBundle.getString("FCenter");
        JLabel centerLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        centerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        centerPanel.add((Component)centerLabel, "West");
        centerLabel.setLabelFor(this.m_footerTextAreaCenter);
        centerLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("FCADA"));
        this.m_translatedText = this.rBundle.getString("FRight");
        JLabel rightLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.setPreferredSize(new Dimension((this.getPreferredSize().width - 40) / 3, 24));
        rightPanel.add((Component)rightLabel, "West");
        rightLabel.setLabelFor(this.m_footerTextAreaRight);
        rightLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("FRADA"));
        footerMultilabelPanel.add(leftPanel);
        footerMultilabelPanel.add(Box.createHorizontalStrut(10));
        footerMultilabelPanel.add(centerPanel);
        footerMultilabelPanel.add(Box.createHorizontalStrut(10));
        footerMultilabelPanel.add(rightPanel);
        footerMultilabelPanel.setMinimumSize(new Dimension(footerMultilabelPanel.getMinimumSize().width, footerMultilabelPanel.getPreferredSize().height));
        footerMultilabelPanel.setMaximumSize(new Dimension(footerMultilabelPanel.getMaximumSize().width, footerMultilabelPanel.getPreferredSize().height));
        return footerMultilabelPanel;
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_headerFontButton != null) {
            this.m_headerFontButton.setHelpProvider(this.m_helpProvider);
        }
        if (this.m_footerFontButton != null) {
            this.m_footerFontButton.setHelpProvider(this.m_helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.m_headerTextAreaLeft) {
            this.m_lastFocus = 1;
            this.m_headerInsert.setEnabled(true);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(false);
            this.m_footerFontButton.setEnabled(true);
            this.m_headerFont = this.m_headerTextAreaLeft.getFont();
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
            this.m_footerFont = new Font("San Serif", 0, 10);
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
        } else if (e.getSource() == this.m_headerTextAreaCenter) {
            this.m_lastFocus = 2;
            this.m_headerInsert.setEnabled(true);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(false);
            this.m_footerFontButton.setEnabled(true);
            this.m_headerFont = this.m_headerTextAreaCenter.getFont();
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
            this.m_footerFont = new Font("San Serif", 0, 10);
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
        } else if (e.getSource() == this.m_headerTextAreaRight) {
            this.m_lastFocus = 3;
            this.m_headerInsert.setEnabled(true);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(false);
            this.m_footerFontButton.setEnabled(true);
            this.m_headerFont = this.m_headerTextAreaRight.getFont();
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
            this.m_footerFont = new Font("San Serif", 0, 10);
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
        } else if (e.getSource() == this.m_footerTextAreaLeft) {
            this.m_lastFocus = 4;
            this.m_headerInsert.setEnabled(false);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(true);
            this.m_footerFontButton.setEnabled(true);
            this.m_footerFont = this.m_footerTextAreaLeft.getFont();
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
            this.m_headerFont = new Font("San Serif", 0, 10);
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
        } else if (e.getSource() == this.m_footerTextAreaCenter) {
            this.m_lastFocus = 5;
            this.m_headerInsert.setEnabled(false);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(true);
            this.m_footerFontButton.setEnabled(true);
            this.m_footerFont = this.m_footerTextAreaCenter.getFont();
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
            this.m_headerFont = new Font("San Serif", 0, 10);
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
        } else if (e.getSource() == this.m_footerTextAreaRight) {
            this.m_lastFocus = 6;
            this.m_headerInsert.setEnabled(false);
            this.m_headerFontButton.setEnabled(true);
            this.m_footerInsert.setEnabled(true);
            this.m_footerFontButton.setEnabled(true);
            this.m_footerFont = this.m_footerTextAreaRight.getFont();
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
            this.m_headerFont = new Font("San Serif", 0, 10);
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
        } else if (e.getSource() == this.m_headerInsert || e.getSource() == this.m_footerInsert) {
            this.m_headerFont = new Font("San Serif", 0, 10);
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
            this.m_footerFont = new Font("San Serif", 0, 10);
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
        } else if (e.getSource() == this.m_borderBelowLineWidth || e.getSource() == this.m_borderAboveLineWidth) {
            this.m_lastFocus = -1;
            this.disableButtons();
            this.m_headerFont = new Font("San Serif", 0, 10);
            this.m_headerFontButton.setComponentFont(this.m_headerFont);
            this.m_footerFont = new Font("San Serif", 0, 10);
            this.m_footerFontButton.setComponentFont(this.m_footerFont);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this) {
            this.m_headerFontButton.setComponentFont(new Font("San Serif", 0, 10));
            this.m_footerFontButton.setComponentFont(new Font("San Serif", 0, 10));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String insertStr;
        if (e.getSource() == this.m_headerInsert) {
            String insertStr2 = this.m_headerInsert.getSelectedItem();
            if (insertStr2 != null) {
                if (this.m_tokenSubstitution != null) {
                    insertStr2 = this.m_tokenSubstitution.getToken(insertStr2);
                }
                if (this.m_lastFocus == 1) {
                    this.m_headerTextAreaLeft.replaceSelection(insertStr2);
                    this.m_headerTextAreaLeft.requestFocus();
                } else if (this.m_lastFocus == 2) {
                    this.m_headerTextAreaCenter.replaceSelection(insertStr2);
                    this.m_headerTextAreaCenter.requestFocus();
                } else if (this.m_lastFocus == 3) {
                    this.m_headerTextAreaRight.replaceSelection(insertStr2);
                    this.m_headerTextAreaRight.requestFocus();
                }
            }
        } else if (e.getSource() == this.m_footerInsert && (insertStr = this.m_footerInsert.getSelectedItem()) != null) {
            if (this.m_tokenSubstitution != null) {
                insertStr = this.m_tokenSubstitution.getToken(insertStr);
            }
            if (this.m_lastFocus == 4) {
                this.m_footerTextAreaLeft.replaceSelection(insertStr);
                this.m_footerTextAreaLeft.requestFocus();
            } else if (this.m_lastFocus == 5) {
                this.m_footerTextAreaCenter.replaceSelection(insertStr);
                this.m_footerTextAreaCenter.requestFocus();
            } else if (this.m_lastFocus == 6) {
                this.m_footerTextAreaRight.replaceSelection(insertStr);
                this.m_footerTextAreaRight.requestFocus();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Boolean b;
        boolean cancelled;
        String name;
        boolean bTemp = false;
        if (e.getSource() == this.m_headerFontButton) {
            this.m_Font = this.m_headerFont;
            this.m_bFontIsHeader = true;
            this.m_bFontIsFooter = false;
        }
        if (e.getSource() == this.m_footerFontButton) {
            this.m_Font = this.m_footerFont;
            this.m_bFontIsHeader = false;
            this.m_bFontIsFooter = true;
        }
        if ((name = e.getPropertyName()) == "fontDialogCancelled" && !(cancelled = (b = (Boolean)e.getNewValue()).booleanValue())) {
            if (this.m_bFontNameChange) {
                this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                this.m_Font = new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_Font.getSize());
                this.m_bFontNameChange = false;
            }
            if (this.m_bFontStyleChange) {
                this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                this.m_Font = new Font(this.m_Font.getName(), this.m_newFontStyle, this.m_Font.getSize());
                this.m_bFontStyleChange = false;
            }
            if (this.m_bFontSizeChange) {
                this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                this.m_Font = new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_newFontSize);
                this.m_bFontSizeChange = false;
            }
            if (this.m_bHorizontalAlignmentChange) {
                this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                this.m_bHorizontalAlignmentChange = false;
            }
            if (this.m_bFontIsHeader) {
                this.m_headerFont = this.m_Font;
                this.m_bFontIsHeader = false;
                if (this.m_lastFocus == 1) {
                    this.m_headerTextAreaLeft.setFont(this.m_headerFont);
                    this.m_headerTextAreaLeft.requestFocus();
                } else if (this.m_lastFocus == 2) {
                    this.m_headerTextAreaCenter.setFont(this.m_headerFont);
                    this.m_headerTextAreaCenter.requestFocus();
                } else if (this.m_lastFocus == 3) {
                    this.m_headerTextAreaRight.setFont(this.m_headerFont);
                    this.m_headerTextAreaRight.requestFocus();
                } else {
                    this.m_headerTextAreaLeft.setFont(this.m_headerFont);
                    this.m_headerTextAreaCenter.setFont(this.m_headerFont);
                    this.m_headerTextAreaRight.setFont(this.m_headerFont);
                }
            } else if (this.m_bFontIsFooter) {
                this.m_footerFont = this.m_Font;
                this.m_bFontIsFooter = false;
                if (this.m_lastFocus == 4) {
                    this.m_footerTextAreaLeft.setFont(this.m_footerFont);
                    this.m_footerTextAreaLeft.requestFocus();
                } else if (this.m_lastFocus == 5) {
                    this.m_footerTextAreaCenter.setFont(this.m_footerFont);
                    this.m_footerTextAreaCenter.requestFocus();
                } else if (this.m_lastFocus == 6) {
                    this.m_footerTextAreaRight.setFont(this.m_footerFont);
                    this.m_footerTextAreaRight.requestFocus();
                } else {
                    this.m_footerTextAreaLeft.setFont(this.m_footerFont);
                    this.m_footerTextAreaCenter.setFont(this.m_footerFont);
                    this.m_footerTextAreaRight.setFont(this.m_footerFont);
                }
            }
        }
        if (name == "fontHorizontalAlignment") {
            Integer oldAli = (Integer)e.getOldValue();
            Integer newAli = (Integer)e.getNewValue();
            this.m_oldHAlignment = oldAli;
            this.m_newHAlignment = newAli;
            if (this.m_oldHAlignment != this.m_newHAlignment) {
                this.m_bHorizontalAlignmentChange = true;
            }
        }
        if (name == "fontName") {
            this.m_oldFontName = (String)e.getOldValue();
            this.m_newFontName = (String)e.getNewValue();
            if (this.m_oldFontName != this.m_newFontName) {
                this.m_bFontNameChange = true;
            }
        }
        if (name == "fontStyle") {
            Integer oldIntStyle = (Integer)e.getOldValue();
            this.m_oldFontStyle = oldIntStyle;
            Integer newIntStyle = (Integer)e.getNewValue();
            this.m_newFontStyle = newIntStyle;
            if (this.m_oldFontStyle != this.m_newFontStyle) {
                this.m_bFontStyleChange = true;
            }
        }
        if (name == "fontSize") {
            Integer oldIntSize = (Integer)e.getOldValue();
            this.m_oldFontSize = oldIntSize;
            Integer newIntSize = (Integer)e.getNewValue();
            this.m_newFontSize = newIntSize;
            if (this.m_oldFontSize != this.m_newFontSize) {
                this.m_bFontSizeChange = true;
            }
        }
    }

    public boolean apply() {
        boolean bReturn = true;
        int i = 0;
        int j = 0;
        for (i = 0; i < this.m_viewPrinter.length; ++i) {
            this.m_viewPrinter[i].setLineWidth(1, this.m_borderBelowLineWidth.getSelectedIndex());
            this.m_viewPrinter[i].setLineWidth(2, this.m_borderAboveLineWidth.getSelectedIndex());
            HeaderAndFooterPainter hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(1);
            String tempText = this.m_headerTextAreaLeft.getText();
            String[] text = this.parseTextArea(tempText);
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_headerTextAreaLeft.getFont());
            hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(2);
            tempText = this.m_headerTextAreaCenter.getText();
            text = this.parseTextArea(tempText);
            j = 0;
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_headerTextAreaCenter.getFont());
            hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(4);
            tempText = this.m_headerTextAreaRight.getText();
            text = this.parseTextArea(tempText);
            j = 0;
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_headerTextAreaRight.getFont());
            hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(16);
            tempText = this.m_footerTextAreaLeft.getText();
            text = this.parseTextArea(tempText);
            j = 0;
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_footerTextAreaLeft.getFont());
            hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(32);
            tempText = this.m_footerTextAreaCenter.getText();
            text = this.parseTextArea(tempText);
            j = 0;
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_footerTextAreaCenter.getFont());
            hfpTemp = this.m_viewPrinter[i].getHeaderAndFooterPainter(64);
            tempText = this.m_footerTextAreaRight.getText();
            text = this.parseTextArea(tempText);
            j = 0;
            if (text != null && text.length > 0) {
                for (j = 0; j < text.length; ++j) {
                    if (this.m_tokenSubstitution == null || text[j] == null) continue;
                    text[j] = this.m_tokenSubstitution.getKeyString(text[j]);
                }
                hfpTemp.setStrings(text);
            } else {
                hfpTemp.setStrings(null);
            }
            hfpTemp.setFont(this.m_footerTextAreaRight.getFont());
        }
        return bReturn;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = loc;
        this.updateResourceBundle(loc);
        if (this.m_headerFontButton != null) {
            this.m_headerFontButton.setPaneLocale(loc);
        }
        if (this.m_footerFontButton != null) {
            this.m_footerFontButton.setPaneLocale(loc);
        }
    }

    private void displayErrorMessage(String strMessage) {
        JDialog tmpDialog = new JOptionPane(this.rBundle.getString(strMessage), 0, -1, new ImageIcon(ImageUtils.getImageResource(PageSetupHeaderFooterPanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        tmpDialog.show();
    }

    private String[] parseTextArea(String text) {
        if (text.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(text, this.m_eol);
        int index = 0;
        String[] subStr = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            subStr[index++] = st.nextToken();
        }
        return subStr;
    }

    private void _init() {
        this.m_lastFocus = 0;
        String[] text = null;
        int i = 0;
        HeaderAndFooterPainter hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(1);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_headerTextAreaLeft.setText(this.m_headerTextAreaLeft.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_headerTextAreaLeft.setText(this.m_headerTextAreaLeft.getText() + text[i]);
            }
        }
        this.m_headerTextAreaLeft.setFont(hfpTemp.getFont());
        hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(2);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_headerTextAreaCenter.setText(this.m_headerTextAreaCenter.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_headerTextAreaCenter.setText(this.m_headerTextAreaCenter.getText() + text[i]);
            }
        }
        this.m_headerTextAreaCenter.setFont(hfpTemp.getFont());
        hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(4);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_headerTextAreaRight.setText(this.m_headerTextAreaRight.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_headerTextAreaRight.setText(this.m_headerTextAreaRight.getText() + text[i]);
            }
        }
        this.m_headerTextAreaRight.setFont(hfpTemp.getFont());
        hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(16);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_footerTextAreaLeft.setText(this.m_footerTextAreaLeft.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_footerTextAreaLeft.setText(this.m_footerTextAreaLeft.getText() + text[i]);
            }
        }
        this.m_footerTextAreaLeft.setFont(hfpTemp.getFont());
        hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(32);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_footerTextAreaCenter.setText(this.m_footerTextAreaCenter.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_footerTextAreaCenter.setText(this.m_footerTextAreaCenter.getText() + text[i]);
            }
        }
        this.m_footerTextAreaCenter.setFont(hfpTemp.getFont());
        hfpTemp = this.m_viewPrinter[0].getHeaderAndFooterPainter(64);
        text = hfpTemp.getStrings();
        if (text != null && text.length > 0) {
            for (i = 0; i < text.length; ++i) {
                if (this.m_tokenSubstitution != null && text[i] != null) {
                    text[i] = this.m_tokenSubstitution.getTokenString(text[i]);
                }
                if (i < text.length - 1) {
                    this.m_footerTextAreaRight.setText(this.m_footerTextAreaRight.getText() + text[i] + this.m_eol);
                    continue;
                }
                this.m_footerTextAreaRight.setText(this.m_footerTextAreaRight.getText() + text[i]);
            }
        }
        this.m_footerTextAreaRight.setFont(hfpTemp.getFont());
        this.m_borderBelowLineWidth.setLineWidth(this.m_viewPrinter[0].getLineWidth(1));
        this.m_borderAboveLineWidth.setLineWidth(this.m_viewPrinter[0].getLineWidth(2));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_headerInsert.removeActionListener(this);
        this.m_headerFontButton.removeActionListener(this);
        this.m_headerFontButton.removePropertyChangeListener(this);
        this.m_footerInsert.removeActionListener(this);
        this.m_footerFontButton.removeActionListener(this);
        this.m_footerFontButton.removePropertyChangeListener(this);
        this.m_footerTextAreaLeft.removeFocusListener(this);
        this.m_footerTextAreaRight.removeFocusListener(this);
        this.m_footerTextAreaCenter.removeFocusListener(this);
        this.m_headerTextAreaLeft.removeFocusListener(this);
        this.m_headerTextAreaRight.removeFocusListener(this);
        this.m_headerTextAreaCenter.removeFocusListener(this);
        this.m_borderBelowLineWidth.removeFocusListener(this);
        this.m_borderAboveLineWidth.removeFocusListener(this);
        this.m_headerInsert.removeFocusListener(this);
        this.m_footerInsert.removeFocusListener(this);
        this.removeFocusListener(this);
        this.m_borderBelowLineWidth.cleanUp();
        this.m_borderAboveLineWidth.cleanUp();
        this.rBundle = null;
        this.m_locale = null;
        this.m_strHelpContextID = null;
        this.m_helpProvider = null;
        this.m_applicationName = null;
        this.m_insertHeaderButton = null;
        this.m_insertFooterButton = null;
        this.m_headerFontButton = null;
        this.m_footerFontButton = null;
        this.m_translatedText = null;
        this.m_rightPanel = null;
        this.m_leftPanel = null;
        this.m_headerPanel = null;
        this.m_footerPanel = null;
        this.m_headerButtonPanel = null;
        this.m_footerButtonPanel = null;
        this.m_headerLabel = null;
        this.m_footerLabel = null;
        this.m_borderBelowLineWidth = null;
        this.m_borderAboveLineWidth = null;
        this.m_headerTextAreaLeft = null;
        this.m_headerTextAreaCenter = null;
        this.m_headerTextAreaRight = null;
        this.m_footerTextAreaLeft = null;
        this.m_footerTextAreaCenter = null;
        this.m_footerTextAreaRight = null;
        this.m_headerScrollPaneLeft = null;
        this.m_headerScrollPaneCenter = null;
        this.m_headerScrollPaneRight = null;
        this.m_footerScrollPaneLeft = null;
        this.m_footerScrollPaneCenter = null;
        this.m_footerScrollPaneRight = null;
        this.m_headerMultilinePanel = null;
        this.m_footerMultilinePanel = null;
        this.m_headerMultilabelPanel = null;
        this.m_footerMultilabelPanel = null;
        this.m_viewPrinter = null;
        this.m_tokenSubstitution = null;
        this.m_oldFontName = null;
        this.m_newFontName = null;
        this.m_Font = null;
        this.m_headerFont = null;
        this.m_footerFont = null;
        this.m_eol = null;
        this.m_headerInsert = null;
        this.m_footerInsert = null;
    }

    class LineWidth
    extends JComboBox {
        private KeyListener m_keyListener;
        private Filter _filter = new Filter();

        public LineWidth() {
            for (int i = 0; i <= 6; ++i) {
                this.addItem(new Integer(i).toString());
            }
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
            this.setMaximumRowCount(7);
            CellRenderer renderer = new CellRenderer();
            this.setRenderer(renderer);
            int width = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(PageSetupHeaderFooterPanel.this.rBundle.getString("NoLine"));
            this.setPreferredSize(new Dimension(width + 25, 23));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        LineWidth.this.hidePopup();
                    }
                }
            };
            this.addKeyListener(this.m_keyListener);
        }

        public void cleanUp() {
            this.removeAllItems();
            this.removeKeyListener(this.m_keyListener);
            this.setRenderer(null);
            this.renderer = null;
        }

        @Override
        public void setLocale(Locale loc) {
            super.setLocale(loc);
            PageSetupHeaderFooterPanel.this.updateResourceBundle(loc);
            int width = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(PageSetupHeaderFooterPanel.this.rBundle.getString("NoLine"));
            this.setPreferredSize(new Dimension(width + 25, 23));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
        }

        public int getLineWidth() {
            return this.getSelectedIndex();
        }

        public void setLineWidth(int lineWidth) {
            this.setSelectedIndex(lineWidth);
        }

        private Icon _getIcon(Image image) {
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), this._filter);
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
        }

        class CellRenderer
        extends JLabel
        implements ListCellRenderer {
            public CellRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    this.setText("");
                    this.setIcon(null);
                    return this;
                }
                int tmpIndex = 0;
                try {
                    tmpIndex = new Integer((String)value);
                }
                catch (Exception exception) {
                    this.setText("");
                    this.setIcon(null);
                    return this;
                }
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                String gifFileName = "";
                gifFileName = "images/Line" + tmpIndex + ".gif";
                this.setText("");
                this.setIcon(null);
                if (tmpIndex == 0) {
                    this.setText(PageSetupHeaderFooterPanel.this.rBundle.getString("NoLine"));
                } else {
                    this.setIcon(LineWidth.this._getIcon(ImageUtils.getImageResource(LineWidth.class, (String)gifFileName)));
                }
                if (tmpIndex == 0) {
                    this.getAccessibleContext().setAccessibleName(PageSetupHeaderFooterPanel.this.rBundle.getString("NoLine"));
                } else {
                    switch (tmpIndex) {
                        case 1: {
                            this.getAccessibleContext().setAccessibleName(PageSetupHeaderFooterPanel.this.rBundle.getString("LineWidth1"));
                            break;
                        }
                        case 2: {
                            this.getAccessibleContext().setAccessibleName(PageSetupHeaderFooterPanel.this.rBundle.getString("LineWidth2"));
                            break;
                        }
                        case 3: {
                            this.getAccessibleContext().setAccessibleName(PageSetupHeaderFooterPanel.this.rBundle.getString("LineWidth3"));
                            break;
                        }
                        case 4: {
                            this.getAccessibleContext().setAccessibleName(PageSetupHeaderFooterPanel.this.rBundle.getString("LineWidth4"));
                        }
                    }
                }
                this.setMinimumSize(new Dimension(100, this.getMinimumSize().height));
                this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
                this.setMaximumSize(new Dimension(100, this.getMaximumSize().height));
                return this;
            }
        }

        private class Filter
        extends RGBImageFilter {
            public Filter() {
                this.canFilterIndexColorModel = true;
            }

            @Override
            public int filterRGB(int x, int y, int rgb) {
                return Color.black.getRGB();
            }
        }
    }

    public class TextPanel
    extends JPanel {
        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }
}

