/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PageItem;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PagingComponent;

public class LayoutPagingComponent
extends PagingComponent
implements LayoutComponent,
FocusListener {
    private int m_edge;
    private String m_accessibilityDescription = "";
    public static final String COMMAND_POPUP = "SHOW_POPUP";
    private static final KeyStroke _KEY_STROKE_SHIFT_F10 = KeyStroke.getKeyStroke(121, 1);
    private ActionListener m_keyBoardActionListener = null;
    private MouseListener m_mouseListener = null;
    protected int lastIndex = -1;

    public LayoutPagingComponent(int edge) {
        this.m_edge = edge;
    }

    @Override
    public int getEdge() {
        return this.m_edge;
    }

    @Override
    public void setEdge(int edge) {
        this.m_edge = edge;
    }

    @Override
    public String[] getItems() {
        int count = this.getComponentCount();
        String[] items = new String[count];
        for (int i = 0; i < count; ++i) {
            items[i] = this.getItem(i).getText();
        }
        return items;
    }

    public void setKeyBoardActionListener(ActionListener l) {
        this.m_keyBoardActionListener = l;
    }

    public ActionListener getKeyBoardActionListener() {
        return this.m_keyBoardActionListener;
    }

    public void setMouseListener(MouseListener ml) {
        this.m_mouseListener = ml;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            PageItem sourcePageItem = (PageItem)e.getSource();
            int index = this.getIndex(sourcePageItem);
            if (index == -1) {
                int lastIndex = this.getLastSelectedIndex();
                if (lastIndex != -1) {
                    int count = this.getComponentCount();
                    if (count > 0) {
                        PageItem pi = lastIndex > count - 1 ? this.getItem(count - 1) : this.getItem(lastIndex);
                        pi.getAccessibleContext().setAccessibleName(pi.getText() + " " + this.m_accessibilityDescription);
                        pi.getAccessibleContext().setAccessibleDescription(pi.getText() + " " + this.m_accessibilityDescription);
                        pi.requestFocus();
                    } else {
                        this.transferFocus();
                    }
                }
            } else {
                String accessibilityName = sourcePageItem.getText();
                String accessibilityDesc = sourcePageItem.getText();
                sourcePageItem.getAccessibleContext().setAccessibleName(accessibilityName + " " + this.m_accessibilityDescription);
                sourcePageItem.getAccessibleContext().setAccessibleDescription(accessibilityDesc + " " + this.m_accessibilityDescription);
            }
        }
    }

    public void setAccessibilityDescriptionString(String s) {
        this.m_accessibilityDescription = s;
    }

    public String getAccessibilityDescriptionString() {
        return this.m_accessibilityDescription;
    }

    @Override
    public void focusLost(FocusEvent e) {
        PageItem pageItem = (PageItem)e.getSource();
        this.setLastSelectedIndex(this.getIndex(pageItem));
        this.processFocusEvent(e);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.registerKeyboardAction(this.m_keyBoardActionListener, COMMAND_POPUP, _KEY_STROKE_SHIFT_F10, 0);
            if (comp instanceof PageItem && this.m_mouseListener != null) {
                PageItem pageItem = (PageItem)((Object)comp);
                pageItem.addFocusListener(this);
                int count = pageItem.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    pageItem.getComponent(i).addMouseListener(this.m_mouseListener);
                }
            }
        }
    }

    private void setLastSelectedIndex(int index) {
        this.lastIndex = index;
    }

    private int getLastSelectedIndex() {
        return this.lastIndex;
    }
}

