/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ViewLabel
extends JLabel {
    protected boolean m_Underline;
    protected boolean m_DoubleUnderline;
    protected boolean m_StrikeThrough;
    protected FontMetrics m_fm;
    protected int m_baseline;

    public ViewLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public ViewLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public ViewLabel(String text) {
        super(text);
        this.init();
    }

    public ViewLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public ViewLabel(Icon image) {
        super(image);
        this.init();
    }

    public ViewLabel() {
        this.init();
    }

    private void init() {
        this.setUnderline(false);
        this.setDoubleUnderline(false);
        this.setStrikeThrough(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isUnderline() || this.isDoubleUnderline() || this.isStrikeThrough()) {
            String strTxt = this.getText();
            Border b = this.getBorder();
            Insets insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.m_fm = this.getToolkit().getFontMetrics(this.getFont());
            this.m_baseline = this.m_fm.getMaxAscent();
            int x = insets.left;
            int y = insets.top;
            int boundx = this.getWidth() - insets.right - insets.left;
            int boundy = this.getHeight() - insets.bottom - insets.top;
            y = insets.top + (boundy - this.m_fm.getHeight()) / 2;
            this.drawAlignedString(g, strTxt, insets.left, y, boundx);
        }
    }

    protected void drawAlignedString(Graphics g, String s, int x, int y, int width) {
        int sw = this.m_fm.stringWidth(s);
        if (this.getHorizontalAlignment() != 2) {
            if (this.getHorizontalAlignment() == 0) {
                x += (width - sw) / 2;
            } else if (this.getHorizontalAlignment() == 4) {
                x = x + width - sw;
            }
        }
        this.drawEnhancedAdornments(this.m_fm, g, x, y + this.m_baseline, sw, this.isUnderline(), this.isDoubleUnderline(), this.isStrikeThrough());
    }

    protected void drawEnhancedAdornments(FontMetrics metrics, Graphics g, int x, int y, int sw, boolean underline, boolean doubleUnderline, boolean strikeThrough) {
        if (underline) {
            g.drawLine(x, y + 2, x + sw, y + 2);
        } else if (doubleUnderline) {
            g.drawLine(x, y + 2, x + sw, y + 2);
            g.drawLine(x, y + 2 + 2, x + sw, y + 2 + 2);
        }
        if (strikeThrough) {
            g.drawLine(x, y - metrics.getAscent() / 2, x + sw, y - metrics.getAscent() / 2);
        }
    }

    public boolean isUnderline() {
        return this.m_Underline;
    }

    public boolean isDoubleUnderline() {
        return this.m_DoubleUnderline;
    }

    public boolean isStrikeThrough() {
        return this.m_StrikeThrough;
    }

    public void setUnderline(boolean b) {
        this.m_Underline = b;
    }

    public void setDoubleUnderline(boolean b) {
        this.m_DoubleUnderline = b;
    }

    public void setStrikeThrough(boolean b) {
        this.m_StrikeThrough = b;
    }
}

