/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.NodeMonitorMixin;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;

public class ReportDrilldownMixin
extends NodeMonitorMixin {
    private final String connectionName;
    private final String reportPath;
    private String reportId;
    private Map<String, Object> binds;

    public static void install(Node node, String string, String string2) {
        ReportDrilldownMixin.install(node, string, string2, null);
    }

    public static void install(Node node, String string, String string2, Map<String, Object> map) {
        ReportDrilldownMixin reportDrilldownMixin = new ReportDrilldownMixin(string, string2, map);
        reportDrilldownMixin.installMixin(node);
    }

    protected ReportDrilldownMixin(String string, String string2, Map<String, Object> map) {
        this.connectionName = string;
        this.reportPath = string2;
        this.binds = map;
    }

    @Override
    protected boolean onClick(Node node, MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() > 1) {
            this.openReport();
            bl = true;
        }
        return bl;
    }

    private void openReport() {
        SwingUtilities.invokeLater(() -> {
            if (this.reportId == null) {
                RootNode.getInstance().initialize();
                for (String string : DisplayModelCache.getIds()) {
                    DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)string);
                    String string2 = displayModel.getPath();
                    if (string2 == null || !string2.equals(this.reportPath)) continue;
                    this.reportId = displayModel.getID();
                    break;
                }
            }
            if (this.reportId != null) {
                RootNode.getInstance().open(this.reportId, this.connectionName, this.binds);
            } else {
                Logger.getLogger(ReportDrilldownMixin.class.getName()).log(Level.SEVERE, "unable to find report with path ''{0}''", this.reportPath);
            }
        });
    }
}

