/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.NodeMonitorMixin;

public class MessageMixin
extends NodeMonitorMixin {
    private static final Tooltip tooltip = new Tooltip();
    private final String messageText;

    public static void install(Node node, String string) {
        MessageMixin messageMixin = new MessageMixin(string);
        messageMixin.installMixin(node);
    }

    protected MessageMixin(String string) {
        this.messageText = string;
    }

    @Override
    protected boolean onClick(Node node, MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
            this.setTooltipEnabled(node, !tooltip.isShowing(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            bl = true;
        }
        return bl;
    }

    @Override
    protected void onExit(Node node, MouseEvent mouseEvent) {
        this.setTooltipEnabled(node, false, mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void setTooltipEnabled(Node node, boolean bl, double d, double d2) {
        if (bl) {
            tooltip.setText(this.messageText);
            tooltip.show(node, d + 10.0, d2 + 5.0);
        } else {
            tooltip.hide();
        }
    }
}

