/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.ide;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.ide.MetricsPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.ide.MetricsViewerNode;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public class MetricsViewer
extends Editor {
    private MetricsPanel metricsPanel;
    private MetricsViewerNode viewerNode;

    public boolean isViewerFor(Class<? extends Region> clazz, String string) {
        return clazz.equals(this.viewerNode.getPanelClass()) && string.equals(this.viewerNode.getConnectionName());
    }

    public void open() {
        Node node = this.getContext().getNode();
        if (node instanceof MetricsViewerNode) {
            this.viewerNode = (MetricsViewerNode)node;
            if (this.viewerNode.usePanAndZoom()) {
                this.setEditorAttribute("scrollable", false);
            }
        }
    }

    public Component getGUI() {
        if (this.metricsPanel == null) {
            this.metricsPanel = new MetricsPanel(this.viewerNode.getPanelClass(), this.viewerNode.getConnectionName(), this.viewerNode.getConnection());
            if (this.viewerNode.usePanAndZoom()) {
                this.metricsPanel.enablePanAndZoom();
            }
            this.metricsPanel.setPanelAttributes(this.viewerNode.getPanelAttributes());
            Platform.runLater(() -> {
                try {
                    this.metricsPanel.open();
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
                }
            });
        }
        return this.metricsPanel;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void close() {
        this.metricsPanel.close();
        super.close();
    }
}

