/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.DbInstanceArb;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.TransitionBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class ClientPanel
extends LabelledPanel
implements PanelObject {
    @FXML
    private Label clientCount;
    @FXML
    private Label sqlResponseTime;

    public ClientPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.CONTAINER});
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        DXChannel dXChannel = panelContext.getChannel();
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ClientCount"));
        this.clientCount.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("CLIENT_PANEL_CLIENT_COUNT_LABEL", "%,d,"), (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.clientCount, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.clientCount, this.clientCount.textProperty());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/SQLResponseMillisecs"));
        this.sqlResponseTime.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("CLIENT_PANEL_SQL_RESPONSE_TIME_LABEL", "%.1f"), (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.sqlResponseTime, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.sqlResponseTime, this.sqlResponseTime.textProperty());
    }
}

