/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.util.Duration;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;

public class Monitor {
    private final IntegerProperty timeAxisTickIntervalCountProperty = new SimpleIntegerProperty((Object)this, "timeAxisTickIntervalCount", 10);
    private final ObjectProperty<Duration> timeAxisTickIntervalProperty = new SimpleObjectProperty((Object)this, "timeAxisTickInterval", (Object)Duration.seconds((double)10.0));
    private final StringProperty timeAxisFormatProperty = new SimpleStringProperty((Object)this, "timeAxisFormat", "HH:mm:ss");
    private final ObjectProperty<Duration> timeAxisFormatRoundingProperty = new SimpleObjectProperty((Object)this, "timeAxisFormatRounding");
    private final DoubleProperty valueAxisGranuleSizeProperty = new SimpleDoubleProperty((Object)this, "valueAxisGranuleSize", 1.0);
    private final IntegerProperty valueAxisMaximumTickIntervalCountProperty = new SimpleIntegerProperty((Object)this, "valueAxisMaximumTickIntervalCount", 10);
    private final DoubleProperty valueAxisMaximumLowerBoundProperty = new SimpleDoubleProperty((Object)this, "valueAxisMaximumLowerBound", Double.MAX_VALUE);
    private final DoubleProperty valueAxisMinimumUpperBoundProperty = new SimpleDoubleProperty((Object)this, "valueAxisMinimumUpperBound", Double.MIN_VALUE);
    private final StringProperty valueAxisFormatProperty = new SimpleStringProperty((Object)this, "valueAxisFormat", "%s");
    private final BooleanProperty enabledProperty = new SimpleBooleanProperty(this, "enabled", false){

        protected void invalidated() {
            boolean bl = this.get();
            if (bl) {
                Monitor.this.start();
            } else {
                Monitor.this.stop();
            }
        }
    };
    private final ObjectProperty<Duration> samplingIntervalProperty = new SimpleObjectProperty((Object)this, "samplingInterval", (Object)Duration.seconds((double)10.0));
    private final ListProperty<TimeSeriesItem> timeSeriesItemsProperty = new SimpleListProperty((Object)this, "timeSeriesItems", FXCollections.observableArrayList());
    private final XYChart<Number, Number> chart;
    private final ObjectProperty<ObservableList<XYChart.Series<Number, Number>>> data = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private final DoubleProperty timeAxisLowerBound = new SimpleDoubleProperty();
    private final DoubleProperty timeAxisUpperBound = new SimpleDoubleProperty();
    private final DoubleProperty timeAxisTickUnit = new SimpleDoubleProperty();
    private final ObjectProperty<StringConverter<Number>> timeAxisTickLabelFormatter = new SimpleObjectProperty();
    private double timeAxisTickIntervalCount;
    private final DoubleProperty valueAxisLowerBound = new SimpleDoubleProperty();
    private final DoubleProperty valueAxisUpperBound = new SimpleDoubleProperty();
    private final DoubleProperty valueAxisTickUnit = new SimpleDoubleProperty();
    private final ObjectProperty<StringConverter<Number>> valueAxisTickLabelFormatter = new SimpleObjectProperty();
    private double valueAxisGranuleSize;
    private double valueAxisMaximumLowerBound;
    private double valueAxisMinimumUpperBound;
    private final BooleanProperty falseValue = new SimpleBooleanProperty(false);
    private final IntegerProperty zeroValue = new SimpleIntegerProperty(0);
    private Timeline timeline;
    private boolean firstSample;

    protected Monitor(XYChart<Number, Number> xYChart) {
        this.chart = xYChart;
        NumberAxis numberAxis = (NumberAxis)xYChart.getXAxis();
        numberAxis.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis.minorTickVisibleProperty().bind((ObservableValue)this.falseValue);
        numberAxis.minorTickCountProperty().bind((ObservableValue)this.zeroValue);
        numberAxis.lowerBoundProperty().bind((ObservableValue)this.timeAxisLowerBound);
        numberAxis.upperBoundProperty().bind((ObservableValue)this.timeAxisUpperBound);
        numberAxis.tickUnitProperty().bind((ObservableValue)this.timeAxisTickUnit);
        numberAxis.tickLabelFormatterProperty().bind(this.timeAxisTickLabelFormatter);
        NumberAxis numberAxis2 = (NumberAxis)xYChart.getYAxis();
        numberAxis2.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis2.minorTickVisibleProperty().bind((ObservableValue)this.falseValue);
        numberAxis2.minorTickCountProperty().bind((ObservableValue)this.zeroValue);
        numberAxis2.lowerBoundProperty().bind((ObservableValue)this.valueAxisLowerBound);
        numberAxis2.upperBoundProperty().bind((ObservableValue)this.valueAxisUpperBound);
        numberAxis2.tickUnitProperty().bind((ObservableValue)this.valueAxisTickUnit);
        numberAxis2.tickLabelFormatterProperty().bind(this.valueAxisTickLabelFormatter);
        this.monitorSeriesStyles();
    }

    public int getTimeAxisTickIntervalCount() {
        return this.timeAxisTickIntervalCountProperty.get();
    }

    public void setTimeAxisTickIntervalCount(int n) {
        this.timeAxisTickIntervalCountProperty.set(n);
    }

    public IntegerProperty timeAxisTickIntervalCountProperty() {
        return this.timeAxisTickIntervalCountProperty;
    }

    public Duration getTimeAxisTickInterval() {
        return (Duration)this.timeAxisTickIntervalProperty.get();
    }

    public void setTimeAxisTickInterval(Duration duration) {
        this.timeAxisTickIntervalProperty.set((Object)duration);
    }

    public ObjectProperty<Duration> timeAxisTickIntervalProperty() {
        return this.timeAxisTickIntervalProperty;
    }

    public double getValueAxisGranuleSize() {
        return this.valueAxisGranuleSizeProperty.get();
    }

    public void setValueAxisGranuleSize(double d) {
        this.valueAxisGranuleSizeProperty.set(d);
    }

    public DoubleProperty valueAxisGranuleSizeProperty() {
        return this.valueAxisGranuleSizeProperty;
    }

    public int getValueAxisMaximumTickIntervalCount() {
        return this.valueAxisMaximumTickIntervalCountProperty.get();
    }

    public void setValueAxisMaximumTickIntervalCount(int n) {
        this.valueAxisMaximumTickIntervalCountProperty.set(n);
    }

    public IntegerProperty valueAxisMaximumTickIntervalCountProperty() {
        return this.valueAxisMaximumTickIntervalCountProperty;
    }

    public double getValueAxisMaximumLowerBound() {
        return this.valueAxisMaximumLowerBoundProperty.get();
    }

    public void setValueAxisMaximumLowerBound(double d) {
        this.valueAxisMaximumLowerBoundProperty.set(d);
    }

    public DoubleProperty valueAxisMaximumLowerBoundProperty() {
        return this.valueAxisMaximumLowerBoundProperty;
    }

    public double getValueAxisMinimumUpperBound() {
        return this.valueAxisMinimumUpperBoundProperty.get();
    }

    public void setValueAxisMinimumUpperBound(double d) {
        this.valueAxisMinimumUpperBoundProperty.set(d);
    }

    public DoubleProperty valueAxisMinimumUpperBoundProperty() {
        return this.valueAxisMinimumUpperBoundProperty;
    }

    public String getTimeAxisFormat() {
        return (String)this.timeAxisFormatProperty.get();
    }

    public void setTimeAxisFormat(String string) {
        this.timeAxisFormatProperty.set((Object)string);
    }

    public StringProperty timeAxisFormatProperty() {
        return this.timeAxisFormatProperty;
    }

    public Duration getTimeAxisFormatRounding() {
        return (Duration)this.timeAxisFormatRoundingProperty.get();
    }

    public void setTimeAxisFormatRounding(Duration duration) {
        this.timeAxisFormatRoundingProperty.set((Object)duration);
    }

    public ObjectProperty<Duration> timeAxisFormatRoundingProperty() {
        return this.timeAxisFormatRoundingProperty;
    }

    public String getValueAxisFormat() {
        return (String)this.valueAxisFormatProperty.get();
    }

    public void setValueAxisFormat(String string) {
        this.valueAxisFormatProperty.set((Object)string);
    }

    public StringProperty valueAxisFormatProperty() {
        return this.valueAxisFormatProperty;
    }

    public boolean isEnabled() {
        return this.enabledProperty.get();
    }

    public void setEnabled(boolean bl) {
        this.enabledProperty.set(bl);
    }

    public BooleanProperty enabledProperty() {
        return this.enabledProperty;
    }

    public Duration getSamplingInterval() {
        return (Duration)this.samplingIntervalProperty.get();
    }

    public void setSamplingInterval(Duration duration) {
        this.samplingIntervalProperty.set((Object)duration);
    }

    public ObjectProperty<Duration> samplingIntervalProperty() {
        return this.samplingIntervalProperty;
    }

    public ObservableList<TimeSeriesItem> getTimeSeriesItems() {
        return (ObservableList)this.timeSeriesItemsProperty.get();
    }

    public void setTimeSeriesItems(ObservableList<TimeSeriesItem> observableList) {
        this.timeSeriesItemsProperty.set(observableList);
    }

    public ListProperty<TimeSeriesItem> timeSeriesItemsProperty() {
        return this.timeSeriesItemsProperty;
    }

    public boolean isRunning() {
        return this.timeline != null;
    }

    private void start() {
        if (this.isRunning()) {
            return;
        }
        ObservableList observableList = (ObservableList)this.data.get();
        observableList.clear();
        for (TimeSeriesItem timeSeriesItem : this.getTimeSeriesItems()) {
            XYChart.Series series = new XYChart.Series();
            series.setName(timeSeriesItem.getSeriesName());
            observableList.add((Object)series);
        }
        double d = this.getTimeAxisTickInterval().toMillis();
        this.timeAxisTickIntervalCount = this.getTimeAxisTickIntervalCount();
        double d2 = System.currentTimeMillis();
        double d3 = d2 - d * this.timeAxisTickIntervalCount;
        this.timeAxisLowerBound.set(d3);
        this.timeAxisUpperBound.set(d2);
        this.timeAxisTickUnit.set(d);
        this.timeAxisTickLabelFormatter.set((Object)new StringConverter<Number>(){
            private final DateFormat dateFormatObject;
            private final double rounding;
            {
                this.dateFormatObject = new SimpleDateFormat(Monitor.this.getTimeAxisFormat());
                this.rounding = Monitor.this.getTimeAxisFormatRounding() != null ? Monitor.this.getTimeAxisFormatRounding().toMillis() : Monitor.this.getSamplingInterval().toMillis();
            }

            public String toString(Number number) {
                double d = number.doubleValue();
                long l = Math.round(d / this.rounding) * Math.round(this.rounding);
                Date date = new Date(l);
                return this.dateFormatObject.format(date);
            }

            public Number fromString(String string) {
                return Double.parseDouble(string);
            }
        });
        this.valueAxisGranuleSize = this.getValueAxisGranuleSize();
        this.valueAxisMaximumLowerBound = this.getValueAxisMaximumLowerBound();
        this.valueAxisMinimumUpperBound = this.getValueAxisMinimumUpperBound();
        this.valueAxisLowerBound.set(0.0);
        this.valueAxisUpperBound.set(this.valueAxisGranuleSize);
        this.valueAxisTickUnit.set(this.valueAxisGranuleSize);
        this.valueAxisTickLabelFormatter.set((Object)new StringConverter<Number>(){

            public String toString(Number number) {
                return String.format(Monitor.this.getValueAxisFormat(), number);
            }

            public Number fromString(String string) {
                return Double.parseDouble(string);
            }
        });
        KeyFrame keyFrame = new KeyFrame(this.getSamplingInterval(), actionEvent -> this.onSamplingIntervalExpired(), new KeyValue[0]);
        this.timeline = new Timeline(new KeyFrame[]{keyFrame});
        this.timeline.setCycleCount(-1);
        Platform.runLater(() -> {
            if (this.timeline != null && this.timeline.getStatus() != Animation.Status.RUNNING) {
                this.firstSample = true;
                this.timeline.playFromStart();
                this.onSamplingIntervalExpired();
            }
        });
    }

    private void stop() {
        if (this.isRunning()) {
            this.chart.dataProperty().unbind();
            if (this.timeline.getStatus() == Animation.Status.RUNNING) {
                this.timeline.stop();
            }
            this.timeline = null;
        }
    }

    private void onSamplingIntervalExpired() {
        long l;
        if (!this.isRunning()) {
            return;
        }
        double d = this.getTimeAxisTickInterval().toMillis();
        this.timeAxisTickIntervalCount = this.getTimeAxisTickIntervalCount();
        double d2 = System.currentTimeMillis();
        double d3 = d2 - d * this.timeAxisTickIntervalCount;
        int n = this.getTimeSeriesItems().size();
        ObservableList observableList = (ObservableList)this.data.get();
        if (this.firstSample) {
            this.firstSample = false;
            for (int i = 0; i < n; ++i) {
                Number number = this.getItemValue(i);
                XYChart.Series series = (XYChart.Series)observableList.get(i);
                series.getData().add((Object)new XYChart.Data((Object)(d2 - this.getSamplingInterval().toMillis()), (Object)number));
                series.getData().add((Object)new XYChart.Data((Object)d2, (Object)number));
            }
            this.chart.dataProperty().bind(this.data);
        }
        ObservableList observableList2 = ((XYChart.Series)observableList.get(0)).getData();
        while (observableList2.size() > 2 && ((Number)((XYChart.Data)observableList2.get(1)).getXValue()).doubleValue() < d3) {
            for (int i = 0; i < n; ++i) {
                ((XYChart.Series)observableList.get(i)).getData().remove(0);
            }
        }
        for (int i = 0; i < n; ++i) {
            ((XYChart.Series)observableList.get(i)).getData().add((Object)new XYChart.Data((Object)d2, (Object)this.getItemValue(i)));
        }
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        if (this.chart instanceof StackedAreaChart) {
            for (Object object : ((XYChart.Series)observableList.get(0)).getData()) {
                double d6 = ((Number)object.getYValue()).doubleValue();
                if (!(d6 < d4)) continue;
                d4 = d6;
            }
            int n2 = -1;
            for (XYChart.Series series : observableList) {
                ObservableList observableList3 = series.getData();
                int n3 = observableList3.size();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            for (int i = 0; i < n2; ++i) {
                double d7 = 0.0;
                for (XYChart.Series series : observableList) {
                    ObservableList observableList4 = series.getData();
                    d7 += ((Number)((XYChart.Data)observableList4.get(i)).getYValue()).doubleValue();
                }
                if (!(d7 > d5)) continue;
                d5 = d7;
            }
        } else {
            for (XYChart.Series series : observableList) {
                ObservableList observableList5 = series.getData();
                for (XYChart.Data data : observableList5) {
                    double d8 = ((Number)data.getYValue()).doubleValue();
                    if (d8 < d4) {
                        d4 = d8;
                    }
                    if (!(d8 > d5)) continue;
                    d5 = d8;
                }
            }
        }
        this.timeAxisLowerBound.set(d3);
        this.timeAxisUpperBound.set(d2);
        long l2 = (long)(d4 / this.valueAxisGranuleSize);
        long l3 = 1L + (long)(d5 / this.valueAxisGranuleSize);
        long l4 = (long)(this.valueAxisMaximumLowerBound / this.valueAxisGranuleSize);
        if (l2 > l4) {
            l2 = l4;
        }
        if (l3 < (l = 1L + (long)(this.valueAxisMinimumUpperBound / this.valueAxisGranuleSize))) {
            l3 = l;
        }
        if (l2 == l3) {
            ++l3;
        }
        int n4 = this.getValueAxisMaximumTickIntervalCount();
        long l5 = 1L + (l3 - l2) / (long)(n4 + 1);
        this.valueAxisLowerBound.set((double)l2 * this.valueAxisGranuleSize);
        this.valueAxisUpperBound.set((double)l3 * this.valueAxisGranuleSize);
        this.valueAxisTickUnit.set((double)l5 * this.valueAxisGranuleSize);
    }

    private Number getItemValue(int n) {
        Number number = (Number)((TimeSeriesItem)this.getTimeSeriesItems().get(n)).getValue().getValue();
        if (number == null) {
            number = 0.0;
        }
        return number;
    }

    private void monitorSeriesStyles() {
        ((ObservableList)this.data.get()).addListener(change -> {
            while (change.next()) {
                for (XYChart.Series series : change.getAddedSubList()) {
                    if (series.getNode() != null) {
                        this.addSeriesStyle(series.getNode(), series.getName());
                        this.addLegendStyle(this.chart);
                        this.monitorDataStyles((XYChart.Series<Number, Number>)series);
                        continue;
                    }
                    series.nodeProperty().addListener((observableValue, node, node2) -> {
                        this.addSeriesStyle((Node)node2, series.getName());
                        this.addLegendStyle(this.chart);
                        this.monitorDataStyles((XYChart.Series<Number, Number>)series);
                    });
                }
            }
        });
    }

    private void monitorDataStyles(XYChart.Series<Number, Number> series) {
        ((ObservableList)series.dataProperty().get()).addListener(change -> {
            while (change.next()) {
                for (XYChart.Data data : change.getAddedSubList()) {
                    if (data.getNode() != null) {
                        this.addSeriesStyle(data.getNode(), series.getName());
                        continue;
                    }
                    data.nodeProperty().addListener((observableValue, node, node2) -> this.addSeriesStyle(data.getNode(), series.getName()));
                }
            }
        });
    }

    private void addLegendStyle(XYChart<Number, Number> xYChart) {
        Platform.runLater(() -> {
            for (Node node : xYChart.lookupAll(".chart-legend-item")) {
                ObservableList observableList;
                Label label = (Label)node;
                Node node2 = label.getGraphic();
                String string = this.getStyleName(label.getText());
                if (string == null || (observableList = node2.getStyleClass()).contains(string)) continue;
                node2.getStyleClass().add((Object)string);
            }
        });
    }

    private void addSeriesStyle(Node node, String string) {
        Parent parent;
        String string2 = this.getStyleName(string);
        if (string2 == null) {
            return;
        }
        if (node instanceof Parent) {
            parent = (Parent)node;
            for (Node node2 : parent.getChildrenUnmodifiable()) {
                this.addSeriesStyle(node2, string2);
            }
        }
        parent = node.getStyleClass();
        parent.add((Object)string2);
        parent.addListener(arg_0 -> Monitor.lambda$addSeriesStyle$25((ObservableList)parent, string2, arg_0));
    }

    private String getStyleName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return string.replace(" ", "-").replace("/", "").toLowerCase();
    }

    private static /* synthetic */ void lambda$addSeriesStyle$25(ObservableList observableList, String string, ListChangeListener.Change change) {
        if (!observableList.contains((Object)string)) {
            observableList.add((Object)string);
        }
    }
}

