/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.Arrow;

public class LabelledArrow
extends Region {
    private final BooleanProperty clockwiseProperty = new SimpleBooleanProperty((Object)this, "clockwise", false){

        protected void invalidated() {
            LabelledArrow.this.requestLayout();
        }
    };
    private final DoubleProperty insetPercentProperty = new SimpleDoubleProperty((Object)this, "insetPercent", 50.0){

        protected void invalidated() {
            LabelledArrow.this.requestLayout();
        }
    };
    private final DoubleProperty headExtendProperty = new SimpleDoubleProperty((Object)this, "headExtendPercent", 0.0){

        protected void invalidated() {
            LabelledArrow.this.requestLayout();
        }
    };
    private final DoubleProperty tailExtendProperty = new SimpleDoubleProperty((Object)this, "tailExtendPercent", 0.0){

        protected void invalidated() {
            LabelledArrow.this.requestLayout();
        }
    };
    private final ReadOnlyObjectProperty<Arrow> arrowProperty = new SimpleObjectProperty((Object)this, "arrow", (Object)new Arrow());
    private final ReadOnlyObjectProperty<Label> labelProperty = new SimpleObjectProperty((Object)this, "label", (Object)new Label());

    public LabelledArrow() {
        this.getStyleClass().add((Object)"labelled-arrow");
        Label label = (Label)this.labelProperty.get();
        this.getChildren().setAll((Object[])new Node[]{label, (Node)this.arrowProperty.get()});
    }

    public final void setClockwise(boolean bl) {
        this.clockwiseProperty.setValue(Boolean.valueOf(bl));
    }

    public final boolean isClockwise() {
        return this.clockwiseProperty.getValue();
    }

    public final BooleanProperty clockwiseProperty() {
        return this.clockwiseProperty;
    }

    public final void setInsetPercent(double d) {
        this.insetPercentProperty.setValue((Number)d);
    }

    public final double getInsetPercent() {
        return this.insetPercentProperty.getValue();
    }

    public final DoubleProperty insetPercentProperty() {
        return this.insetPercentProperty;
    }

    public final void setHeadExtend(double d) {
        this.headExtendProperty.setValue((Number)d);
    }

    public final double getHeadExtend() {
        return this.headExtendProperty.getValue();
    }

    public final DoubleProperty headExtendProperty() {
        return this.headExtendProperty;
    }

    public final void setTailExtend(double d) {
        this.tailExtendProperty.setValue((Number)d);
    }

    public final double getTailExtend() {
        return this.tailExtendProperty.getValue();
    }

    public final DoubleProperty tailExtendProperty() {
        return this.tailExtendProperty;
    }

    public Arrow getArrow() {
        return (Arrow)((Object)this.arrowProperty.get());
    }

    public ReadOnlyObjectProperty<Arrow> arrowProperty() {
        return this.arrowProperty;
    }

    public Label getLabel() {
        return (Label)this.labelProperty.get();
    }

    public ReadOnlyObjectProperty<Label> labelProperty() {
        return this.labelProperty;
    }

    public boolean isAnimated() {
        return ((Arrow)((Object)this.arrowProperty.get())).isAnimated();
    }

    public void setAnimated(boolean bl) {
        ((Arrow)((Object)this.arrowProperty.get())).setAnimated(bl);
    }

    public BooleanProperty animatedProperty() {
        return ((Arrow)((Object)this.arrowProperty.get())).animatedProperty();
    }

    public String getText() {
        return ((Label)this.labelProperty.get()).getText();
    }

    public void setText(String string) {
        ((Label)this.labelProperty.get()).setText(string);
    }

    public StringProperty textProperty() {
        return ((Label)this.labelProperty.get()).textProperty();
    }

    protected void layoutChildren() {
        Arrow arrow = this.getArrow();
        Label label = (Label)this.labelProperty.get();
        double d = this.getWidth();
        double d2 = this.getHeight();
        Side side = arrow.getStartSide();
        double d3 = this.getInsetPercent();
        double d4 = this.getHeadExtend();
        double d5 = this.getTailExtend();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        switch (side) {
            case TOP: {
                d8 = arrow.computePrefWidth(-1.0);
                d9 = d2;
                d6 = d * d3 / 100.0 - d8 / 2.0;
                d7 = 0.0;
                d12 = d8;
                d13 = d9 + d4 + d5;
                d10 = d6;
                d11 = d7 - d5;
                break;
            }
            case BOTTOM: {
                d8 = arrow.computePrefWidth(-1.0);
                d9 = d2;
                d6 = d * d3 / 100.0 - d8 / 2.0;
                d7 = 0.0;
                d12 = d8;
                d13 = d9 + d4 + d5;
                d10 = d6;
                d11 = d7 - d4;
                break;
            }
            case LEFT: {
                d8 = d;
                d9 = arrow.computePrefHeight(-1.0);
                d6 = 0.0;
                d7 = d2 * d3 / 100.0 - d9 / 2.0;
                d12 = d8 + d4 + d5;
                d13 = d9;
                d10 = d6 - d5;
                d11 = d7;
                break;
            }
            case RIGHT: {
                d8 = d;
                d9 = arrow.computePrefHeight(-1.0);
                d6 = 0.0;
                d7 = d2 * d3 / 100.0 - d9 / 2.0;
                d12 = d8 + d4 + d5;
                d13 = d9;
                d10 = d6 - d4;
                d11 = d7;
            }
        }
        this.layoutInArea((Node)arrow, d10, d11, d12, d13, 0.0, HPos.LEFT, VPos.TOP);
        double d14 = label.prefWidth(-1.0);
        double d15 = label.prefHeight(-1.0);
        double d16 = 0.0;
        double d17 = 0.0;
        switch (side) {
            case TOP: 
            case BOTTOM: {
                d16 = this.isClockwise() ? d6 + d8 : d6 - d14;
                d17 = (d2 - d15) / 2.0;
                break;
            }
            case LEFT: 
            case RIGHT: {
                d16 = (d - d14) / 2.0;
                d17 = this.isClockwise() ? d7 + d9 : d7 - d15;
            }
        }
        this.layoutInArea((Node)label, d16, d17, d14, d15, 0.0, HPos.LEFT, VPos.TOP);
    }
}

