/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.BarLine;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.BarSegment;

public class BarGauge
extends Region {
    private final Rectangle outerRect = new Rectangle();
    private ObjectProperty<ObservableList<BarSegment>> segments;
    private ListChangeListener<BarSegment> segmentsListListener;
    private ObjectProperty<ObservableList<BarLine>> lines;
    private ListChangeListener<BarLine> linesListListener;
    private BooleanProperty verticalProperty;

    public BarGauge() {
        this.outerRect.setFill((Paint)Color.WHITE);
        this.outerRect.setStroke((Paint)Color.BLACK);
        this.outerRect.setStrokeType(StrokeType.INSIDE);
        this.outerRect.setStrokeWidth(1.0);
        this.outerRect.setArcHeight(3.0);
        this.outerRect.setArcWidth(3.0);
        this.getChildren().addAll((Object[])new Node[]{this.outerRect});
    }

    protected void layoutChildren() {
        block8: {
            ObservableList<BarLine> observableList;
            double d;
            double d2;
            block7: {
                ObservableList<BarLine> observableList2;
                d2 = this.getWidth();
                d = this.getHeight();
                this.outerRect.setWidth(d2);
                this.outerRect.setHeight(d);
                if (!this.isVertical()) break block7;
                double d3 = 0.0;
                ObservableList<BarSegment> observableList3 = this.getSegments();
                if (observableList3 != null) {
                    observableList2 = observableList3.iterator();
                    while (observableList2.hasNext()) {
                        BarSegment barSegment = (BarSegment)observableList2.next();
                        barSegment.rect.setWidth(d2 - 4.0);
                        barSegment.rect.setHeight(d * barSegment.getValue().doubleValue());
                        barSegment.rect.setTranslateX(2.0);
                        barSegment.rect.setTranslateY(2.0 + d * d3);
                        d3 += barSegment.getValue().doubleValue();
                    }
                }
                if ((observableList2 = this.getLines()) == null) break block8;
                for (BarLine barLine : observableList2) {
                    barLine.line.setStartX(2.0);
                    barLine.line.setStartY(2.0 + d * barLine.getValue().doubleValue());
                    barLine.line.setEndX(d2 - 2.0);
                    barLine.line.setEndY(2.0 + d * barLine.getValue().doubleValue());
                }
                break block8;
            }
            double d4 = 0.0;
            ObservableList<BarSegment> observableList4 = this.getSegments();
            if (observableList4 != null) {
                observableList = observableList4.iterator();
                while (observableList.hasNext()) {
                    BarSegment barSegment = (BarSegment)observableList.next();
                    barSegment.rect.setWidth(d2 * barSegment.getValue().doubleValue());
                    barSegment.rect.setHeight(d - 4.0);
                    barSegment.rect.setTranslateX(2.0 + d2 * d4);
                    barSegment.rect.setTranslateY(2.0);
                    d4 += barSegment.getValue().doubleValue();
                }
            }
            if ((observableList = this.getLines()) != null) {
                for (BarLine barLine : observableList) {
                    barLine.line.setStartX(2.0 + d2 * barLine.getValue().doubleValue());
                    barLine.line.setStartY(2.0);
                    barLine.line.setEndX(2.0 + d2 * barLine.getValue().doubleValue());
                    barLine.line.setEndY(d - 2.0);
                }
            }
        }
    }

    private void updateChildList() {
        ObservableList<BarLine> observableList;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.outerRect);
        ObservableList<BarSegment> observableList2 = this.getSegments();
        if (observableList2 != null) {
            observableList = observableList2.iterator();
            while (observableList.hasNext()) {
                BarSegment barSegment = (BarSegment)observableList.next();
                arrayList.add(barSegment.rect);
                barSegment.valueProperty().addListener(observable -> this.requestLayout());
            }
        }
        if ((observableList = this.getLines()) != null) {
            for (BarLine barLine : observableList) {
                arrayList.add(barLine.line);
                barLine.valueProperty().addListener(observable -> this.requestLayout());
            }
        }
        this.getChildren().setAll(arrayList);
        this.requestLayout();
    }

    public final void setSegments(ObservableList<BarSegment> observableList) {
        this.segmentsProperty().set(observableList);
        this.updateChildList();
    }

    public final ObservableList<BarSegment> getSegments() {
        return this.segments == null ? null : (ObservableList)this.segments.get();
    }

    public final ObjectProperty<ObservableList<BarSegment>> segmentsProperty() {
        if (this.segments == null) {
            this.segments = new SimpleObjectProperty((Object)this, "segments");
            this.segments.addListener((observableValue, observableList, observableList2) -> {
                if (this.segmentsListListener == null) {
                    this.segmentsListListener = change -> this.updateChildList();
                } else if (observableList != null) {
                    observableList.removeListener(this.segmentsListListener);
                }
                if (observableList2 != null) {
                    observableList2.addListener(this.segmentsListListener);
                }
            });
        }
        return this.segments;
    }

    public final void setLines(ObservableList<BarLine> observableList) {
        this.linesProperty().set(observableList);
        this.updateChildList();
    }

    public final ObservableList<BarLine> getLines() {
        return this.lines == null ? null : (ObservableList)this.lines.get();
    }

    public final ObjectProperty<ObservableList<BarLine>> linesProperty() {
        if (this.lines == null) {
            this.lines = new SimpleObjectProperty((Object)this, "lines");
            this.lines.addListener((observableValue, observableList, observableList2) -> {
                if (this.linesListListener == null) {
                    this.linesListListener = change -> this.updateChildList();
                } else if (observableList != null) {
                    observableList.removeListener(this.linesListListener);
                }
                if (observableList2 != null) {
                    observableList2.addListener(this.linesListListener);
                }
            });
        }
        return this.lines;
    }

    public final void setVertical(boolean bl) {
        this.verticalProperty().setValue(Boolean.valueOf(bl));
    }

    public final boolean isVertical() {
        return this.verticalProperty == null ? false : this.verticalProperty.getValue();
    }

    public final BooleanProperty verticalProperty() {
        if (this.verticalProperty == null) {
            this.verticalProperty = new SimpleBooleanProperty((Object)this, "verticalProperty", false);
        }
        return this.verticalProperty;
    }
}

