/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.metrics;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.dba.navigator.displays.metrics.DBMetricsViewer;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.value.DXList;
import oracle.dbtools.raptor.metrics.value.DXRow;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class TableViewer
extends DBMetricsViewer {
    private DXChannel itemChannel;

    @Override
    protected void closeScene() {
        if (this.itemChannel != null) {
            DXService.closeChannel((DXChannel)this.itemChannel);
        }
    }

    @Override
    protected Scene createScene() {
        this.itemChannel = DXService.createChannel();
        String string = this.getDBObject().getConnectionName();
        TableView tableView = new TableView();
        tableView.getColumns().addAll(this.getTableColumns());
        DXList dXList = DXValues.listenList((DXChannel)this.itemChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SystemEvents"));
        tableView.itemsProperty().set((Object)dXList);
        DXService.registerChannel((DXChannel)this.itemChannel);
        return SceneFactory.createScene((Parent)tableView);
    }

    Collection<TableColumn<DXRow<String>, ?>> getTableColumns() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.createTableColumn(String.class, "EventName", "Event", Pos.CENTER_LEFT, 150.0));
        arrayList.add(this.createTableColumn(Long.class, "TotalWaits", "Total # Waits", Pos.CENTER_RIGHT, 150.0));
        arrayList.add(this.createTableColumn(Long.class, "TotalTimeouts", "Total # Timeouts", Pos.CENTER_RIGHT, 150.0));
        arrayList.add(this.createTableColumn(Long.class, "TimeWaited", "Total Wait Time", Pos.CENTER_RIGHT, 150.0));
        arrayList.add(this.createTableColumn(Double.class, "AverageWait", "Average Wait Time", Pos.CENTER_RIGHT, 150.0));
        return arrayList;
    }

    private <T> TableColumn<DXRow<String>, T> createTableColumn(final Class<T> clazz, final String string, String string2, final Pos pos, double d) {
        TableColumn tableColumn = new TableColumn(string2);
        tableColumn.setMinWidth(d);
        tableColumn.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<DXRow<String>, T>, ObservableValue<T>>(){

            public ObservableValue<T> call(TableColumn.CellDataFeatures<DXRow<String>, T> cellDataFeatures) {
                return ((DXRow)cellDataFeatures.getValue()).get(string, clazz);
            }
        });
        tableColumn.setCellFactory(new Callback<TableColumn<DXRow<String>, T>, TableCell<DXRow<String>, T>>(){

            public TableCell call(TableColumn<DXRow<String>, T> tableColumn) {
                TableCell tableCell = new TableCell<DXRow<String>, T>(){

                    public void updateItem(T t, boolean bl) {
                        if (t != null) {
                            this.setText(t.toString());
                        }
                    }
                };
                tableCell.setAlignment(pos);
                return tableCell;
            }
        });
        return tableColumn;
    }
}

