/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.metrics;

import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.dba.navigator.displays.metrics.DBMetricsViewer;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.listener.DXEngineBind;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXItemType;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXJobTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSourceAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceType;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeMerge;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;
import oracle.dbtools.raptor.metrics.listener.DXUnbind;
import oracle.dbtools.raptor.metrics.value.DXDouble;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXString;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class SampleViewer
extends DBMetricsViewer {
    private boolean fullDiagnostics = false;
    private DXChannel engineChannel;
    private DXChannel itemChannel;

    @Override
    protected void closeScene() {
        if (this.engineChannel != null) {
            DXService.closeChannel((DXChannel)this.engineChannel);
        }
        if (this.itemChannel != null) {
            DXService.closeChannel((DXChannel)this.itemChannel);
        }
    }

    @Override
    protected Scene createScene() {
        this.engineChannel = DXService.createChannel();
        String string = this.getDBObject().getConnectionName();
        GridPane gridPane = new GridPane();
        this.engineChannel.addEngineListener(this.createEngineListener(string, gridPane));
        DXService.registerChannel((DXChannel)this.engineChannel);
        return SceneFactory.createScene((Parent)gridPane);
    }

    private void blinkOnChange(ObservableValue<?> observableValue, final Label label) {
        final FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)0.25), (Node)label);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.9);
        fadeTransition.setCycleCount(2);
        fadeTransition.setAutoReverse(true);
        fadeTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                label.setTextFill((Paint)Color.BLACK);
            }
        });
        observableValue.addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
                label.setTextFill((Paint)Color.RED);
                fadeTransition.play();
            }
        });
    }

    private void addStringItem(GridPane gridPane, int n, DXChannel dXChannel, URI uRI) {
        Label label = new Label(DXIds.getPath((URI)uRI) + " = ");
        Label label2 = new Label();
        gridPane.add((Node)label, 1, n);
        gridPane.add((Node)label2, 2, n);
        DXString dXString = DXValues.listenString((DXChannel)dXChannel, (URI)uRI);
        this.blinkOnChange((ObservableValue<?>)dXString, label2);
        label2.textProperty().bind((ObservableValue)dXString);
    }

    private void addIntegerItem(GridPane gridPane, int n, DXChannel dXChannel, URI uRI) {
        Label label = new Label(DXIds.getPath((URI)uRI) + " = ");
        Label label2 = new Label();
        gridPane.add((Node)label, 1, n);
        gridPane.add((Node)label2, 2, n);
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)uRI);
        this.blinkOnChange((ObservableValue<?>)dXLong, label2);
        label2.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
    }

    private void addRealItem(GridPane gridPane, int n, DXChannel dXChannel, URI uRI) {
        Label label = new Label(DXIds.getPath((URI)uRI) + " = ");
        Label label2 = new Label();
        gridPane.add((Node)label, 1, n);
        gridPane.add((Node)label2, 2, n);
        DXDouble dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)uRI);
        this.blinkOnChange((ObservableValue<?>)dXDouble, label2);
        label2.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{dXDouble}));
    }

    private DXEngineListener createEngineListener(final String string, final GridPane gridPane) {
        return new DXEngineListener(){

            private void print(String string2) {
                if (SampleViewer.this.fullDiagnostics) {
                    System.out.println(string2);
                }
            }

            private void dump(DXEngineBind dXEngineBind) {
                if (SampleViewer.this.fullDiagnostics) {
                    int n = 0;
                    int n2 = 0;
                    System.out.println("MetricsEngine");
                    System.out.println("  [sourceTypes]");
                    Map map = dXEngineBind.getSourceTypes();
                    for (URI uRI : map.keySet()) {
                        DXSourceType dXSourceType = (DXSourceType)map.get(uRI);
                        System.out.println("    " + DXIds.getConnectionTypeName((URI)uRI));
                        System.out.println("      [jobs]");
                        Map map2 = dXSourceType.getJobTypes();
                        for (URI uRI2 : map2.keySet()) {
                            DXJobType dXJobType = (DXJobType)map2.get(uRI2);
                            System.out.println("        " + uRI2);
                            System.out.println("        [items]");
                            Map map3 = dXJobType.getItemTypes();
                            for (URI uRI3 : map3.keySet()) {
                                DXItemType dXItemType = (DXItemType)map3.get(uRI3);
                                Class clazz = dXItemType.getChangeClass();
                                System.out.println("          " + uRI3 + " -> " + clazz.getName());
                            }
                        }
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "itemCount=" + n + " jobCount=" + n2);
                }
            }

            private void setupScene(final DXEngineBind dXEngineBind) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SampleViewer.this.itemChannel = DXService.createChannel();
                        int n = 1;
                        Label label = new Label("Metrics Sample using Connection '" + string + "'");
                        gridPane.add((Node)label, 1, n++);
                        Map map = dXEngineBind.getSourceTypes();
                        for (URI uRI : map.keySet()) {
                            Map map2;
                            Object object;
                            String string = DXIds.getConnectionTypeName((URI)uRI);
                            TreeMap treeMap = new TreeMap();
                            DXSourceType dXSourceType = (DXSourceType)map.get(uRI);
                            Map map3 = dXSourceType.getJobTypes();
                            for (Object object2 : map3.keySet()) {
                                object = (DXJobType)map3.get(object2);
                                map2 = object.getItemTypes();
                                for (URI uRI2 : map2.keySet()) {
                                    String string2 = DXIds.getPath((URI)uRI2);
                                    treeMap.put(string2, map2.get(uRI2));
                                }
                            }
                            for (Object object2 : treeMap.keySet()) {
                                object = DXIds.newId((String)string, (String)string, (String)object2);
                                map2 = (DXItemType)treeMap.get(object2);
                                Class clazz = map2.getChangeClass();
                                if (clazz == String.class) {
                                    SampleViewer.this.addStringItem(gridPane, n++, SampleViewer.this.itemChannel, (URI)object);
                                    continue;
                                }
                                if (clazz == Long.class) {
                                    SampleViewer.this.addIntegerItem(gridPane, n++, SampleViewer.this.itemChannel, (URI)object);
                                    continue;
                                }
                                if (clazz != Double.class) continue;
                                SampleViewer.this.addRealItem(gridPane, n++, SampleViewer.this.itemChannel, (URI)object);
                            }
                        }
                        DXService.registerChannel((DXChannel)SampleViewer.this.itemChannel);
                    }
                });
            }

            public void onBind(DXEngineBind dXEngineBind) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onBind");
                this.dump(dXEngineBind);
                this.setupScene(dXEngineBind);
            }

            public void onBindError(DXError dXError) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onBindError");
            }

            public void onUnbind(DXUnbind dXUnbind) {
                this.print(">>> [" + Thread.currentThread().getName() + "] onUnbind");
            }

            public void onAdd(DXSourceTypeAdd dXSourceTypeAdd) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onAddSourceType");
            }

            public void onMerge(DXSourceTypeMerge dXSourceTypeMerge) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onMergeSourceType");
            }

            public void onAdd(DXSourceAdd dXSourceAdd) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onAddSource");
            }

            public void onDefaultMinimumIntervalChange(DXSourceTypeUpdate dXSourceTypeUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onSourceTypeDefaultMinimumIntervalChange");
            }

            public void onDefaultMinimumIntervalChange(DXJobTypeUpdate dXJobTypeUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobTypeDefaultMinimumIntervalChange");
            }

            public void onDefaultEnable(DXJobTypeUpdate dXJobTypeUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobTypeDefaultEnable");
            }

            public void onDefaultDisable(DXJobTypeUpdate dXJobTypeUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobTypeDefaultDisable");
            }

            public void onMinimumIntervalChange(DXSourceUpdate dXSourceUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onSourceMinimumIntervalChange");
            }

            public void onMinimumIntervalChange(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobMinimumIntervalChange");
            }

            public void onConnect(DXSourceUpdate dXSourceUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onSourceConnect");
            }

            public void onDisconnect(DXSourceUpdate dXSourceUpdate, DXException dXException) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onSourceDisconnect");
            }

            public void onRemove(DXSourceUpdate dXSourceUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onSourceRemove");
            }

            public void onPin(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobPin");
            }

            public void onPin(DXItemUpdate dXItemUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onItemPin");
            }

            public void onUnpin(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobUnpin");
            }

            public void onUnpin(DXItemUpdate dXItemUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onItemUnpin");
            }

            public void onEnable(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobEnable");
            }

            public void onDisable(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobDisable");
            }

            public void onRunStart(DXJobUpdate dXJobUpdate) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobRunStart");
            }

            public void onRunFinish(DXJobUpdate dXJobUpdate, long l, long l2, DXException dXException) {
                this.print(">>> [" + Thread.currentThread().getName() + "] " + "onJobRunFinish");
            }
        };
    }
}

