/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class RMANScriptProcessor
implements ScriptProcessor {
    private String _commandFilePath;
    private boolean _saveScriptToFile;
    private boolean _detached;
    private boolean _processingDeclined;
    private boolean _scriptError;
    private boolean _scheduledActionsNotConfigured;
    private ActionDialog _dialog;
    boolean _cancelled = false;

    public RMANScriptProcessor() {
        this._detached = false;
    }

    public RMANScriptProcessor(boolean bl, ActionDialog actionDialog) {
        this._detached = bl;
        this._dialog = actionDialog;
    }

    public void setDetached(boolean bl) {
        this._detached = bl;
    }

    public BasicEditorPane getEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        return basicEditorPane;
    }

    public String getScriptEditorTabName() {
        return DbaNavigatorResources.getString("RMAN_TAB");
    }

    public String getSuccessMessage() {
        if (this._saveScriptToFile) {
            return DbaNavigatorResources.format("FILE_SAVE_SUCCESS", this._commandFilePath);
        }
        if (this._detached) {
            return DbaNavigatorResources.format("DETACHED_SCHEDULER_JOB_SUCCESS", new Object[0]);
        }
        return DbaNavigatorResources.format("RMAN_SCRIPT_SUCCESS", new Object[0]);
    }

    public String getFailureMessage(Exception exception) {
        String string = null;
        if (this._saveScriptToFile) {
            string = DbaNavigatorResources.getString("FILE_SAVE_FAILURE");
        } else {
            if (this._processingDeclined) {
                return null;
            }
            string = this._detached ? DbaNavigatorResources.format("DETACHED_SCHEDULER_JOB_FAILURE", new Object[0]) : (this._scriptError ? DbaNavigatorResources.format("RMAN_SCRIPT_FAILURE", new Object[0]) : (this._scheduledActionsNotConfigured ? DbaNavigatorResources.getString("UNABLE_TO_RUN_RMAN") : DbaNavigatorResources.format("SCHEDULER_JOB_FAILURE", new Object[0])));
        }
        String string2 = exception.getLocalizedMessage();
        if (string2 != null) {
            string = string + "\n- " + string2;
        }
        return string;
    }

    public boolean isCancellable() {
        return true;
    }

    public void cancel() {
        this._cancelled = true;
    }

    public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
        this._saveScriptToFile = scriptProcessorContext.getParameter("RMANScriptProcessor/Type").equals(RMANScriptProcessorActionControl.SAVE_TO_FILE);
        if (this._saveScriptToFile) {
            this.saveScriptToFile(scriptProcessorContext);
        } else {
            this.runSchedulerJob(scriptProcessorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScriptToFile(ScriptProcessorContext scriptProcessorContext) throws Exception {
        this._commandFilePath = scriptProcessorContext.getParameter("RMANScriptProcessor/FilePath");
        if (this._commandFilePath == null || this._commandFilePath.equals("")) {
            throw new FileNotFoundException(DbaNavigatorResources.getString("FILE_NOT_SPECIFIED"));
        }
        File file = new File(this._commandFilePath);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(scriptProcessorContext.getScript());
        }
        RMANScriptProcessorActionControl.updateDefaultSaveDir(this._commandFilePath);
    }

    private void runSchedulerJob(ScriptProcessorContext scriptProcessorContext) throws Exception {
        String string;
        this._processingDeclined = false;
        this._scriptError = false;
        if (!Boolean.parseBoolean(scriptProcessorContext.getParameter("RMANScriptProcessor/Configured"))) {
            this._scheduledActionsNotConfigured = true;
            throw new SQLException();
        }
        if (this._detached && !MessageDialog.confirm((Component)scriptProcessorContext.getParent(), (Object)DbaNavigatorResources.getString("RESTART_DATABASE_MESSAGE"), (String)DbaNavigatorResources.getString("RESTART_DATABASE_TITLE"), null)) {
            this._processingDeclined = true;
            throw new SQLException();
        }
        Connection connection = scriptProcessorContext.getConnection();
        boolean bl = this.runJob(connection, string = scriptProcessorContext.getParameter("RMANScriptProcessor/Job"), scriptProcessorContext.getActionTitle(), scriptProcessorContext.getParameter("RMANScriptProcessor/Credential"), scriptProcessorContext.getScript());
        if (!bl) {
            throw new SQLException();
        }
        if (this._detached) {
            Connections.getInstance().closeConnection(scriptProcessorContext.getConnectionName());
            this._dialog.setDBObject(null);
        } else {
            bl = this.waitForJobCompletion(connection, string);
            if (!bl) {
                this._scriptError = true;
                throw new SQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runJob(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        boolean bl = true;
        String string5 = DbaUtil.getServerHome(connection);
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        string6 = "/";
        if (string5.contains("\\")) {
            string6 = "\\";
        }
        if (!string5.endsWith(string6)) {
            string5 = string5 + string6;
        }
        String string10 = string5 + "sqldeveloper" + string6 + "dbascripts" + string6;
        string9 = string10 + "latest.properties";
        String string11 = string10 + string.replace('$', '_');
        string7 = string11 + ".rman";
        string8 = string11 + ".log";
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                Serializable serializable = new StringBuffer();
                ((StringBuffer)serializable).append("job=");
                ((StringBuffer)serializable).append(string);
                ((StringBuffer)serializable).append('\n');
                ((StringBuffer)serializable).append("action=");
                ((StringBuffer)serializable).append(string2);
                ((StringBuffer)serializable).append('\n');
                Object object = new HashMap<String, String>();
                ((HashMap)object).put("PATH", string9);
                ((HashMap)object).put("CREDENTIAL", string3);
                ((HashMap)object).put("CONTENTS", ((StringBuffer)serializable).toString());
                bl = dBUtil.execute(this.getQuery(connection, "putFile"), object);
                connection.commit();
                if (bl) {
                    serializable = new HashMap();
                    ((HashMap)serializable).put("PATH", string7);
                    ((HashMap)serializable).put("CREDENTIAL", string3);
                    ((HashMap)serializable).put("CONTENTS", string4);
                    bl = dBUtil.execute(this.getQuery(connection, "putFile"), (Map)((Object)serializable));
                    connection.commit();
                }
                if (bl) {
                    serializable = new HashMap();
                    ((HashMap)serializable).put("JOB_NAME", string);
                    ((HashMap)serializable).put("COMMENTS", string2);
                    ((HashMap)serializable).put("SCRIPT_PATH", string7);
                    ((HashMap)serializable).put("LOG_PATH", string8);
                    ((HashMap)serializable).put("CREDENTIAL", string3);
                    object = null;
                    object = this._detached ? this.getQuery(connection, "runDetachedJob") : this.getQuery(connection, "runChildJob");
                    dBUtil.execute((String)object, (Map)((Object)serializable));
                    connection.commit();
                    RMANScriptProcessorActionControl.updateDefaultCredential(string3);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForJobCompletion(Connection connection, String string) throws Exception {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                boolean bl2 = false;
                while (!bl2 && !this._cancelled) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("JOB_NAME", string);
                    ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "queryJob"), hashMap);
                    if (resultSet != null) {
                        try {
                            while (resultSet.next()) {
                                String string2 = resultSet.getString("STATUS");
                                if (string2 == null) continue;
                                bl2 = true;
                                bl = string2.equals("SUCCEEDED");
                            }
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                    }
                    connection.commit();
                    if (bl2) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    private String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), (Connection)connection, (String)string);
    }
}

