/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoveryScriptGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RestoreControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class RestoreWholeDatabaseAction
extends ActionDialog {
    private RecoveryScriptGenerator.WholeDatabaseData wholeDatabaseData;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(true, this);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("RESTORE_WHOLE_DATABASE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        Object object;
        if (Connections.getInstance().lock(connection)) {
            object = null;
            try {
                cloneable = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getWholeDatabaseInfo"), (Map)((Object)cloneable));
                if (object != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (object.next()) {
                        arrayList.add(object.getString("DATAFILE"));
                    }
                    this.wholeDatabaseData = new RecoveryScriptGenerator.WholeDatabaseData(arrayList);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = new RestoreControlGroup(connection);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        ((ArrayList)cloneable).add(new SeperatorActionControl());
        ((ArrayList)cloneable).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        RecoveryScriptGenerator recoveryScriptGenerator = new RecoveryScriptGenerator(this, (ActionDialog.Lookup)values, this.wholeDatabaseData, null, null);
        return recoveryScriptGenerator.generateScript();
    }
}

