/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.migration.applications.AppScanArb;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.rules.Rules;
import oracle.dbtools.raptor.migration.applications.rules.RulesRegistry;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class AppFilePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = -1845302785532822095L;
    public static final String INPUT_DIR = "INPUT_DIR";
    public static final String OUTPUT_DIR = "OUTPUT_DIR";
    public static final String IGNORE_LIST = "IGNORE_LIST";
    public static final String DATABASE_TYPE = "DATABASE_TYPE";
    public static final String RULESDIR = "RULESDIR";
    protected static final String INPLACE = "INPLACE";
    protected static final String SCAN_ONLY = "SCAN_ONLY";
    protected static final String OUTPUT = "OUTPUT";
    protected static final String STATE = "STATE";
    private static Logger LOGGER = Logger.getLogger(AppFilePanel.class.getName());
    private URLTextField m_appDirField = new URLTextField();
    private JButton btnNewButton;
    private JLabel lblAppDirectory;
    private MultiLineLabel m_PanelLabel;
    private JLabel lblIgnoreList;
    private JTextField m_ignoreListField;
    private URLTextField m_outputField;
    private JLabel m_outputLabel;
    private JButton btnOutDirBrowse;
    private JComboBox comboDatabaseType;
    private JLabel lblDatabaseType;
    private boolean appdirOK;
    private JCheckBox inPlaceCheckBox;
    private JLabel lblState;
    private JComboBox m_state;
    private TraversableContext ctx;
    private String m_action = "SCAN_ONLY";
    private JCheckBox m_chkRules;
    private URLTextField m_rulesdirTextField;
    private JButton m_rulesdirButton;
    private JLabel m_rulesdirLabel;

    public AppFilePanel() {
        this.initGui();
        this.addListeners();
    }

    private void addListeners() {
        this.btnNewButton.addActionListener(new FPActionListener(this.m_appDirField));
        this.btnOutDirBrowse.addActionListener(new FPActionListener(this.m_outputField));
        this.m_rulesdirButton.addActionListener(new FPActionListener(this.m_rulesdirTextField));
        this.m_rulesdirButton.addActionListener(new RulesDirActionListener(this.m_rulesdirTextField));
        this.m_rulesdirTextField.addFocusListener((FocusListener)new RulesDirFocusListener(this.m_rulesdirTextField));
        this.m_appDirField.addKeyListener((KeyListener)new FPKeyListener(this.m_appDirField));
        this.m_outputField.addKeyListener((KeyListener)new FPKeyListener(this.m_outputField));
        this.m_rulesdirTextField.addKeyListener((KeyListener)new FPKeyListener(this.m_rulesdirTextField));
    }

    private void initGui() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.m_PanelLabel = new MultiLineLabel();
        this.m_PanelLabel.setText(AppScanArb.getString("APPSCAN_FILEPANEL_LABEL"));
        this.add((Component)this.m_PanelLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(15, 15, 15, 15), 0, 0));
        this.lblAppDirectory = new JLabel();
        this.add(this.lblAppDirectory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_appDirField = new URLTextField();
        ResourceUtils.resLabel((JLabel)this.lblAppDirectory, (Component)this.m_appDirField, (String)AppScanArb.getString("APPSCAN_APP_DIR"));
        this.add((Component)this.m_appDirField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_appDirField.setColumns(10);
        this.btnNewButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.btnNewButton, (String)AppScanArb.getString("APPSCAN_BUTTON_BROWSE"));
        this.add(this.btnNewButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblDatabaseType = new JLabel();
        this.add(this.lblDatabaseType, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.comboDatabaseType = new JComboBox<String>(Rules.getInstance().getDBTypes());
        ResourceUtils.resLabel((JLabel)this.lblDatabaseType, (Component)this.comboDatabaseType, (String)AppScanArb.getString("APPSCAN_DATABASE_TYPE"));
        this.add(this.comboDatabaseType, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lblState = new JLabel();
        this.add(this.lblState, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        String[] stringArray = new String[]{"Scan Only", "In Place Changes", "Output to directory"};
        this.m_state = new JComboBox<String>(stringArray);
        ResourceUtils.resLabel((JLabel)this.lblState, (Component)this.m_state, (String)AppScanArb.getString("APPSCAN_OUTPUT_ACTIONS"));
        this.m_state.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFilePanel.this.setState(((JComboBox)actionEvent.getSource()).getSelectedIndex());
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem() != null && jComboBox.getSelectedIndex() == 2) {
                    AppFilePanel.this.setOutputFiled(true);
                } else {
                    AppFilePanel.this.setOutputFiled(false);
                }
            }
        });
        this.add(this.m_state, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_outputLabel = new JLabel();
        this.add(this.m_outputLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_outputField = new URLTextField();
        ResourceUtils.resLabel((JLabel)this.m_outputLabel, (Component)this.m_outputField, (String)AppScanArb.getString("APPSCAN_OUTPUT_DIR"));
        this.add((Component)this.m_outputField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_outputField.setColumns(10);
        this.btnOutDirBrowse = new JButton();
        ResourceUtils.resButton((AbstractButton)this.btnOutDirBrowse, (String)StringUtils.stripMnemonic((String)AppScanArb.getString("APPSCAN_BUTTON_BROWSE")));
        this.add(this.btnOutDirBrowse, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_chkRules = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_chkRules, (String)AppScanArb.getString("APPSCAN_USE_CUSTOM_RULES"));
        this.m_chkRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                AppFilePanel.this.setRulesFiled(bl);
            }
        });
        this.add(this.m_chkRules, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_rulesdirLabel = new JLabel();
        this.add(this.m_rulesdirLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_rulesdirTextField = new URLTextField();
        ResourceUtils.resLabel((JLabel)this.m_rulesdirLabel, (Component)this.m_rulesdirTextField, (String)AppScanArb.getString("APPSCAN_RULES_DIR"));
        this.add((Component)this.m_rulesdirTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_rulesdirTextField.setColumns(10);
        this.m_rulesdirButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_rulesdirButton, (String)StringUtils.stripMnemonic((String)AppScanArb.getString("APPSCAN_BUTTON_BROWSE")));
        this.add(this.m_rulesdirButton, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 9, 1, 1, 0.0, 10.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setOutputFiled(false);
        this.setRulesFiled(false);
    }

    private void setState(int n) {
        if (n == 0) {
            this.m_action = SCAN_ONLY;
        } else if (n == 1) {
            this.m_action = INPLACE;
        } else if (n == 2) {
            this.m_action = OUTPUT;
        }
    }

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public static void main(String[] stringArray) {
        AppFilePanel appFilePanel = new AppFilePanel();
        JEWTDialog jEWTDialog = new JEWTDialog();
        jEWTDialog.setTitle(AppScanArb.getString("APPSCAN_TEST_LABEL"));
        jEWTDialog.setDialogHeader((Component)new DialogHeader(AppScanArb.get("APPSCAN_TEST_LABEL"), AppScanArb.getImage("WIZARD_IMAGE")));
        jEWTDialog.add((Component)((Object)appFilePanel));
        jEWTDialog.setSize(600, 400);
        jEWTDialog.setLocationRelativeTo(null);
        jEWTDialog.setVisible(true);
    }

    private boolean testAppField() {
        if (this.m_appDirField.getText().length() == 0) {
            return false;
        }
        URL uRL = this.m_appDirField.getURL();
        if (uRL == null) {
            return false;
        }
        File file = new File(uRL.getFile());
        return file.isDirectory() && file.canRead();
    }

    private boolean testOutputDir() {
        if (!this.m_action.equals(OUTPUT)) {
            return true;
        }
        if (this.m_outputField.getURL() == null) {
            return false;
        }
        File file = new File(this.m_outputField.getURL().getFile());
        return file.isDirectory() && file.canRead();
    }

    private void setButtons() {
        if (this.ctx != null) {
            if (this.testAppField() && this.testOutputDir()) {
                this.ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            } else {
                this.ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.ctx = traversableContext;
        if (traversableContext.get(INPUT_DIR) != null) {
            this.m_appDirField.setText((String)traversableContext.get(INPUT_DIR));
        }
        if (traversableContext.get(OUTPUT_DIR) != null) {
            this.m_outputField.setText((String)traversableContext.get(OUTPUT_DIR));
        }
        if (traversableContext.get(DATABASE_TYPE) != null) {
            this.comboDatabaseType.setSelectedItem((String)traversableContext.get(DATABASE_TYPE));
        }
        if (traversableContext.get(STATE) != null) {
            if (traversableContext.get(STATE).equals(SCAN_ONLY)) {
                this.m_state.setSelectedIndex(0);
                this.setOutputFiled(false);
                this.m_action = SCAN_ONLY;
            } else if (traversableContext.get(STATE).equals(INPLACE)) {
                this.m_state.setSelectedIndex(1);
                this.setOutputFiled(false);
                this.m_action = INPLACE;
            } else if (traversableContext.get(STATE).equals(OUTPUT)) {
                this.m_state.setSelectedIndex(2);
                this.setOutputFiled(true);
                this.m_action = OUTPUT;
            } else {
                this.m_state.setSelectedIndex(0);
                this.setOutputFiled(false);
                this.m_action = SCAN_ONLY;
            }
        } else {
            this.m_state.setSelectedIndex(0);
            this.setOutputFiled(false);
            this.m_action = SCAN_ONLY;
        }
        if (traversableContext.get(RULESDIR) != null) {
            this.m_rulesdirTextField.setText((String)traversableContext.get(RULESDIR));
        }
        this.ctx.getWizardCallbacks().wizardSetInitialFocus((Component)this.m_appDirField);
        this.setButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_appDirField.getText().trim().length() > 0) {
            traversableContext.put(INPUT_DIR, (Object)this.m_appDirField.getText());
        }
        traversableContext.put(STATE, (Object)this.m_action);
        traversableContext.put(DATABASE_TYPE, (Object)this.comboDatabaseType.getSelectedItem().toString());
        if (this.m_action.equals(INPLACE)) {
            traversableContext.put(INPLACE, (Object)"true");
            if (traversableContext.contains(OUTPUT_DIR)) {
                traversableContext.remove(OUTPUT_DIR);
            }
        } else if (this.m_action.equals(OUTPUT)) {
            traversableContext.put(INPLACE, (Object)"false");
            if (this.m_outputField.getText().trim().length() > 0) {
                traversableContext.put(OUTPUT_DIR, (Object)this.m_outputField.getText());
            } else if (traversableContext.contains(OUTPUT_DIR)) {
                traversableContext.remove(OUTPUT_DIR);
            }
        } else {
            traversableContext.remove(INPLACE);
        }
        if (this.m_chkRules.isSelected()) {
            if (this.m_rulesdirTextField.getText().trim().length() > 0) {
                traversableContext.put(RULESDIR, (Object)this.m_rulesdirTextField.getText());
            } else if (traversableContext.contains(RULESDIR)) {
                traversableContext.remove(RULESDIR);
            }
        } else if (traversableContext.contains(RULESDIR)) {
            traversableContext.remove(RULESDIR);
        }
    }

    private void setOutputFiled(boolean bl) {
        this.m_outputField.setVisible(bl);
        this.btnOutDirBrowse.setVisible(bl);
        this.m_outputLabel.setVisible(bl);
        this.setButtons();
    }

    private void setRulesFiled(boolean bl) {
        this.m_rulesdirTextField.setVisible(bl);
        this.m_rulesdirButton.setVisible(bl);
        this.m_rulesdirLabel.setVisible(bl);
    }

    private void setRulesInOptions(URL uRL) {
        ScannerDetails.getInstance().addRulesDir(uRL.getPath());
        RulesRegistry.getInstance().loadXML(uRL);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(Rules.getInstance().getDBTypes());
        this.comboDatabaseType.setModel(defaultComboBoxModel);
    }

    private class FPKeyListener
    implements KeyListener {
        URLTextField target = null;

        FPKeyListener(URLTextField uRLTextField) {
            this.target = uRLTextField;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.handlekeypress();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.handlekeypress();
        }

        private void handlekeypress() {
            AppFilePanel.this.setButtons();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.handlekeypress();
        }
    }

    private class FPActionListener
    implements ActionListener {
        URLTextField target = null;

        public FPActionListener(URLTextField uRLTextField) {
            this.target = uRLTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            URL uRL = this.target.getURL();
            if (uRL != null) {
                uRL = URLFileSystem.getParent((URL)uRL);
            } else {
                string = Ide.getUserSettingsDirectory();
                uRL = URLFactory.newDirURL((String)string);
            }
            string = new URLFileChooser(uRL);
            string.clearChooseableURLFilters();
            string.setSelectionScope(1);
            string.setShowJarsAsDirs(false);
            boolean bl = false;
            String string2 = AppScanArb.getString("BROWSE_DIRECTORY");
            boolean bl2 = bl = string.showOpenDialog((Component)AppFilePanel.this.btnNewButton.getParent(), string2) == 0;
            if (!bl) {
                return;
            }
            URL uRL2 = string.getSelectedURL();
            if (uRL2 != null && URLFileSystem.isDirectoryPath((URL)uRL2)) {
                this.target.setURL(uRL2);
            }
            AppFilePanel.this.setButtons();
        }
    }

    private class RulesDirFocusListener
    implements FocusListener {
        URLTextField target = null;

        public RulesDirFocusListener(URLTextField uRLTextField) {
            this.target = uRLTextField;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            URL uRL = this.target.getURL();
            if (URLFileSystem.isDirectory((URL)uRL)) {
                AppFilePanel.this.setRulesInOptions(uRL);
            }
        }
    }

    private class RulesDirActionListener
    implements ActionListener {
        URLTextField target = null;

        public RulesDirActionListener(URLTextField uRLTextField) {
            this.target = uRLTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = this.target.getURL();
            if (URLFileSystem.isDirectory((URL)uRL)) {
                AppFilePanel.this.setRulesInOptions(uRL);
            }
        }
    }
}

