/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.controls.CustomTabbedPane;

public class FullMigrationTopPanel
extends JPanel {
    private static final String[] STEPS = new String[]{MigrationAddinArb.getString("FULLMIGRATION_TAB_CREATEREPO"), MigrationAddinArb.getString("FULLMIGRATION_TAB_CREATEPROJ"), MigrationAddinArb.getString("FULLMIGRATION_TAB_CAPTURE"), MigrationAddinArb.getString("FULLMIGRATION_TAB_CONVERT"), MigrationAddinArb.getString("FULLMIGRATION_TAB_GENERATE"), MigrationAddinArb.getString("FULLMIGRATION_TAB_DATAMOVE"), MigrationAddinArb.getString("FULLMIGRATION_TAB_REMOVEREPO")};
    private static final String[] ICONS = new String[]{"repo_add", "capture", "convert", "generate", "create", "move", "repo_remove"};
    private JPanel m_statusPanel = new JPanel();
    private JLabel[] m_stepLabels;
    private CustomTabbedPane m_tabPane = new CustomTabbedPane();
    private int m_currentStep;

    private void jbInit(boolean bl, boolean bl2) throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        Font font = new Font("Dialog", 0, 12);
        this.setLayout(borderLayout);
        BoxLayout boxLayout = new BoxLayout(this.m_statusPanel, 0);
        this.m_statusPanel.setLayout(boxLayout);
        this.m_tabPane.setBounds(new Rectangle(0, 42, 500, 278));
        borderLayout.setVgap(10);
        int n = !bl2 ? STEPS.length - 1 : STEPS.length;
        int n2 = bl ? 0 : 1;
        int n3 = 0;
        for (int i = n2; i < n; ++i) {
            this.m_stepLabels[n3] = new GreyableLabel();
            this.m_stepLabels[n3].setText(STEPS[i]);
            this.m_stepLabels[n3].setFont(font);
            this.m_stepLabels[n3].setEnabled(false);
            String string = "images/" + ICONS[i] + ".png";
            URL uRL = this.getClass().getResource(string);
            ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon();
            this.m_stepLabels[n3].setIcon(imageIcon);
            string = "images/" + ICONS[i] + "-des.png";
            uRL = this.getClass().getResource(string);
            ImageIcon imageIcon2 = uRL != null ? new ImageIcon(uRL) : new ImageIcon();
            this.m_stepLabels[n3].setDisabledIcon(imageIcon2);
            this.m_stepLabels[n3].setVerticalTextPosition(3);
            this.m_stepLabels[n3].setHorizontalTextPosition(0);
            this.m_stepLabels[n3].setAlignmentY(0.0f);
            this.m_statusPanel.add(this.m_stepLabels[n3]);
            if (n3 < this.m_stepLabels.length - 1) {
                this.m_statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            }
            ++n3;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.m_statusPanel);
        this.add((Component)jPanel, "North");
        this.add((Component)this.m_tabPane, "Center");
        this.setPreferredSize(new Dimension(500, 350));
        this.setSize(this.getPreferredSize());
    }

    public void setCurrentStep(int n) {
        if (n < 0 || n >= this.m_stepLabels.length) {
            return;
        }
        for (int i = 0; i < this.m_stepLabels.length; ++i) {
            this.m_stepLabels[i].setEnabled(i <= n);
            FullMigrationTopPanel.setBold(this.m_stepLabels[i], i == n);
        }
        this.m_tabPane.setSelectedIndex(Math.min(n, this.m_tabPane.getNumberOfTabs() - 1));
    }

    public void nextStep() {
        this.setCurrentStep(this.m_currentStep++);
    }

    public CustomTabbedPane getTabbedPane() {
        return this.m_tabPane;
    }

    public void addTab(Icon icon, String string, Component component) {
        this.m_tabPane.addTab(icon, string, component);
    }

    private static void setBold(JLabel jLabel, boolean bl) {
        Font font = jLabel.getFont();
        if (bl) {
            jLabel.setFont(font.deriveFont(1));
        } else {
            jLabel.setFont(font.deriveFont(0));
        }
    }

    private static class GreyableLabel
    extends JLabel {
        private GreyableLabel() {
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setForeground(bl ? (Color)UIManager.get("Label.foreground") : (Color)UIManager.get("Label.disabledForeground"));
        }
    }
}

