/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class ConvertedModelsFolderNode
extends DefaultContainerCustomNode
implements IPersistableObjectNode {
    protected static final Logger LOGGER = Logger.getLogger(ConvertedModelsFolderNode.class.getName());
    private DBObjectId _parentId;
    private MigrationConnectionNode _parent;
    MdConnection _convertedConnection;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ConvertedModelsFolderNode(DBObjectId dBObjectId, MigrationConnectionNode migrationConnectionNode) {
        this._parentId = dBObjectId;
        this._parent = migrationConnectionNode;
        String string = this._parentId.toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string + "/" + ConvertedModelsFolderNode.class.getSimpleName())));
    }

    public MdConnection getConvertedConnection() {
        if (null == this._convertedConnection) {
            DBObjectId dBObjectId = this.getConvertedDBObjectID(this._parentId.toString());
            this._convertedConnection = MdConnection.getExistingInstance(dBObjectId);
            try {
                this._convertedConnection.retrieve(this.getPersistenceManager());
            }
            catch (Exception exception) {
                ConvertedModelsFolderNode.log(exception);
                this._convertedConnection = null;
            }
        }
        return this._convertedConnection;
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString("CONVERTED_ROOT_LABEL");
    }

    public Icon getIcon() {
        return MigrationAddinArb.getIcon("MIGRATION_CONVERT_ICON");
    }

    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        return new ConvertedConnectionNode(string, string2, mdConnection);
    }

    protected MigrationConnectionNode addChild(MdConnection mdConnection, String string) {
        Object object2;
        for (Object object2 : this._children) {
            MigrationConnectionNode migrationConnectionNode;
            if (!(object2 instanceof MigrationConnectionNode) || (migrationConnectionNode = (MigrationConnectionNode)object2).getMdConnection().getKey().getId() != mdConnection.getKey().getId()) continue;
            this.reload();
            return null;
        }
        String string2 = mdConnection.getName();
        object2 = this.createMdConnectionNode(string2, string, mdConnection);
        this._children.add(object2);
        return object2;
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        try {
            this.close();
            this.open();
        }
        catch (IOException iOException) {
            ConvertedModelsFolderNode.log(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        boolean bl = false;
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = this.getMdConnectionsIterator();
            if (closeableIterator.hasNext()) {
                bl = true;
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        return bl;
    }

    private PersistenceUtility getPersistenceUtility() {
        return PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
    }

    private CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getPersistenceUtility().getConvertedModelsForCapturedModel(this._parentId);
    }

    static String getURLProtocol(Element element) {
        URL uRL = element instanceof Locatable ? ((Locatable)element).getURL() : null;
        return uRL != null ? uRL.getProtocol() : null;
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        if (this._parent != null) {
            AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

                protected List<Element> doWork() throws TaskException {
                    ArrayList<Element> arrayList;
                    block6: {
                        arrayList = new ArrayList<Element>();
                        ConvertedConnectionNode convertedConnectionNode = null;
                        MigrationConnectionNode migrationConnectionNode = ConvertedModelsFolderNode.this._parent;
                        MdConnection mdConnection = migrationConnectionNode.getMdConnection();
                        convertedConnectionNode = new ConvertedConnectionNode(MigrationProjectNavigatorArb.get("CONVERTED_DATABASE_OBJECT_FOLDER_LABEL"), this.getConnectionName(), ConvertedModelsFolderNode.this.getConvertedConnection());
                        if (convertedConnectionNode != null) {
                            try {
                                String string;
                                ObjectFactory objectFactory = AbstractMigrationNavigatorManager.getConvertedConnectionRegistry().getFactory(ConvertedModelsFolderNode.this.getConvertedConnection().getName(), convertedConnectionNode.getConn());
                                if (objectFactory == null || (string = ConvertedModelsFolderNode.getURLProtocol((Element)migrationConnectionNode)) == null || !objectFactory.isSupportsCatalog()) break block6;
                                DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                                try {
                                    DefaultContainerCustomNode.fillInInitialPropertiesConverted((DBItemInstance)dBCatalogsInstance, convertedConnectionNode);
                                    for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                        this.checkStatus("create catalogs");
                                        DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                        dBCatalogInstance.setProperty("CAPT_CONNECTION_OBJID", (Object)mdConnection.getKey());
                                        URL uRL = DBURLFormatHelper.getURL((String)string, (String)convertedConnectionNode.getQualifiedConnectionName(), (String)((String)dBCatalogInstance.getProperty("CATALOG")), null, null);
                                        CatalogFolderNode catalogFolderNode = new CatalogFolderNode(uRL, dBCatalogInstance, convertedConnectionNode.getMdConnection(), ((MigrationConnectionNode)convertedConnectionNode).getConnType());
                                        arrayList.add((Element)catalogFolderNode);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    ExceptionHandler.handleException((Throwable)sQLException);
                                }
                            }
                            catch (AbortException abortException) {
                                throw new TaskException((Throwable)abortException);
                            }
                        }
                    }
                    return arrayList;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
        }
    }

    @Override
    public String getObjectName() {
        return "MD_CONNECTIONS";
    }

    @Override
    public String getObjectType() {
        return "CONVERTED_MODELS_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDCONNECTION", this._parentId.toString());
            this._dict.put("CAPT_CONNECTION_OBJID", this._parentId);
            this._dict.put("IDCAPCONNECTION", this._parentId.toString());
            this._dict.put("IDCONCONNECTION", this.getConvertedID(this._parentId.toString()));
        }
        return this._dict;
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getConvertedConnection();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }
}

