/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.ide.model.Element;
import oracle.ide.net.URLFactory;

public abstract class MigrationConnectionNode
extends AbstractConnectionNode
implements CustomNode,
IPersistableObjectNode {
    protected HashMap<String, Object> m_dict = (HashMap)DefaultContainerCustomNode.getBinds(null);
    private String m_cName;
    private MdConnection m_connection;
    private String m_label;
    private Element _parentElement;

    public MigrationConnectionNode(String string, String string2, MdConnection mdConnection) {
        this.m_cName = string2;
        this.m_connection = mdConnection;
        this.setShortLabel(string);
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(string2 + "/" + mdConnection.getKey().toString())));
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getQualifiedConnectionName() {
        return this.m_cName;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public String getObjectName() {
        return this.m_label;
    }

    public abstract String getSchemaName();

    public String getObjectId() {
        return this.getMdConnection().getKey().toString();
    }

    public String getObjectType() {
        return "CONNECTION";
    }

    public String getChildName() {
        return null;
    }

    public Object getObject() {
        return this.getMdConnection();
    }

    public Connection getConn() {
        try {
            return (Connection)this.getConnection();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getCatalog() {
        return null;
    }

    public MdConnection getMdConnection() {
        return this.m_connection;
    }

    protected abstract boolean closeConnectionImpl();

    protected abstract Connection openConnectionImpl() throws IOException;

    public HashMap<String, Object> getDict() {
        return this.m_dict;
    }

    public abstract String getConnType();

    public void setShortLabel(String string) {
        this.m_label = string;
    }

    public String getToolTipText() {
        return this.getSchemaName() + ":" + this.getObjectName();
    }

    public String getLongLabel() {
        return this.getToolTipText();
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getMdConnection();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    @Override
    public void setParentElement(Element element) {
        this._parentElement = element;
    }

    @Override
    public Element getParentElement() {
        return this._parentElement;
    }
}

