/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;

public class MigrationRepositoryManager {
    private Connection m_connection;
    private String m_name;
    private Connection m_loggerConnection;
    private PersistenceManager m_persistenceManager;
    private PersistenceManager m_loggerPersistenceManager;

    public PersistenceManager getLoggerPersistenceManager() {
        if (!this.isConnected()) {
            throw new IllegalStateException(Messages.getString("MigrationRepositoryManager.1"));
        }
        if (this.m_loggerPersistenceManager == null) {
            this.m_loggerPersistenceManager = new PersistenceManager(this.m_loggerConnection);
        }
        return this.m_loggerPersistenceManager;
    }

    public PersistenceManager getPersistenceManager() {
        if (!this.isConnected()) {
            throw new IllegalStateException(Messages.getString("MigrationRepositoryManager.2"));
        }
        if (this.m_persistenceManager == null) {
            this.m_persistenceManager = new PersistenceManager(this.m_connection);
        }
        return this.m_persistenceManager;
    }

    public boolean isConnected() {
        if (this.m_name == null) {
            return false;
        }
        return this.m_connection != null;
    }

    protected String getName() {
        return this.m_name;
    }

    protected void setName(String string) {
        this.m_name = string;
    }

    public void closeConnections() {
        this.closeConnection(this.m_loggerPersistenceManager, this.m_loggerConnection);
        if (this.m_persistenceManager != null) {
            this.m_persistenceManager.releaseCache();
        }
        this.m_connection = null;
        this.m_persistenceManager = null;
        this.m_loggerConnection = null;
        this.m_loggerPersistenceManager = null;
        this.setName(null);
    }

    private void closeConnection(PersistenceManager persistenceManager, Connection connection) {
        if (connection != null) {
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseCache();
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    public boolean openConnections(String string) {
        Connections connections;
        boolean bl = true;
        if (this.isConnected()) {
            if (this.getName().equals(string)) {
                return true;
            }
            this.closeConnections();
        }
        if ((connections = Connections.getInstance()).isConnectionOpen(string)) {
            try {
                Object object;
                DBObject dBObject;
                Connection connection = connections.getConnection(string);
                int n = RepositoryManager.getCurentRepoVersion(connection);
                if (n < 62 && !(bl = RepositoryManager.upgradeRepository((dBObject = new DBObject((URL)(object = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string)))).getConnectionName(), n, this.getClass().getClassLoader()))) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("MigrationRepositoryManager.CannotUseConn"), null, null);
                    return false;
                }
                this.m_connection = connection;
                this.m_loggerConnection = connections.cloneConnection(connection);
                try {
                    object = this.m_connection.createStatement();
                    object.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Main connection'); end;");
                    object.close();
                    object = this.m_loggerConnection.createStatement();
                    object.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Migration log connection'); end;");
                    object.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                this.setName(string);
                return true;
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            catch (ConnectionException connectionException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
            }
        }
        return false;
    }
}

