/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.PluginDescriptor;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class MigrationHook {
    private static MigrationHook INSTANCE;
    private static final Logger LOGGER;
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-migration-plugin";
    public static final String DESCRIPTOR_ID = "plugin";
    public static final String PLUGIN_NAME = "name";
    public static final String PLUGIN_JDBCNAME = "jdbcname";
    public static final String PLUGIN_CLASS = "clazz";
    public static final String PLUGIN_VERSION = "version";
    public static final String PLUGIN_JDBCVERSION = "jdbcversion";
    public static final String PLUGIN_OFFLINE = "offline";
    public static final String PLUGIN_PLATFORM = "platform";
    public static final String PLUGIN_PLATFORM2 = "platform2";
    public static final String PLUGIN_PLATFORM3 = "platform3";
    public static final ElementName ELEMENT_NAME;
    private HashStructureHookListener s_listener;

    public static synchronized MigrationHook getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MigrationHook();
        }
        return INSTANCE;
    }

    public MigrationHook() {
        this.initListener();
    }

    private synchronized void initListener() {
        if (this.s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.s_listener = new Listener();
            hashStructureHook.addHashStructureHookListener(this.s_listener);
        }
    }

    static {
        LOGGER = Logger.getLogger(MigrationHook.class.getName());
        ELEMENT_NAME = new ElementName(NS, "sqldev-migration-plugin");
    }

    private final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processPlugins(hashStructureHookEvent.getNewElementHashStructure());
        }

        private void processPlugins(HashStructure hashStructure) {
            List list = hashStructure.getAsList(MigrationHook.DESCRIPTOR_ID);
            LOGGER.info(MessageFormat.format(Messages.getString("MigrationHook.0"), list.size()));
            for (HashStructure hashStructure2 : list) {
                String string = hashStructure2.getString(MigrationHook.PLUGIN_NAME);
                String string2 = hashStructure2.getString(MigrationHook.PLUGIN_JDBCNAME);
                String string3 = hashStructure2.getString(MigrationHook.PLUGIN_CLASS);
                String string4 = hashStructure2.getString(MigrationHook.PLUGIN_VERSION);
                String string5 = hashStructure2.getString(MigrationHook.PLUGIN_JDBCVERSION);
                String string6 = hashStructure2.getString(MigrationHook.PLUGIN_OFFLINE);
                String string7 = hashStructure2.getString(MigrationHook.PLUGIN_PLATFORM);
                String string8 = hashStructure2.getString(MigrationHook.PLUGIN_PLATFORM2);
                String string9 = hashStructure2.getString(MigrationHook.PLUGIN_PLATFORM3);
                LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                MetaClass metaClass = lazyClassAdapter.getMetaClass(MigrationHook.PLUGIN_CLASS);
                PluginDescriptor pluginDescriptor = this.createDescriptor(string, string2, string3, (MetaClass<? extends MigrationPlugin>)metaClass, string4, string5, string6, string7, string8, string9);
                MigrationAddin.registerPlugin(pluginDescriptor);
                LOGGER.info(MessageFormat.format(Messages.getString("MigrationHook.1"), string, string4));
            }
        }

        private PluginDescriptor createDescriptor(String string, String string2, String string3, MetaClass<? extends MigrationPlugin> metaClass, String string4, String string5, String string6, String string7, String string8, String string9) {
            PluginDescriptor pluginDescriptor = new PluginDescriptor(string, string2, string3, metaClass, string4, string5, string6);
            pluginDescriptor.addPlatform(string7);
            pluginDescriptor.addPlatform(string8);
            pluginDescriptor.addPlatform(string9);
            return pluginDescriptor;
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processPlugins(hashStructureHookEvent.getCombinedHashStructure());
        }
    }
}

