/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class TextIndexesIterator
extends PersistableObjectIterator {
    private static final String QUERY = "SELECT REF_ID_FK FROM MD_ADDITIONAL_PROPERTIES WHERE REF_TYPE = 'MD_INDEXES' AND CONNECTION_ID_FK = ?";
    private DBObjectId m_connectionId;
    private String m_whereCondition;

    public TextIndexesIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string) {
        super(MdIndexe.class, persistenceManager);
        this.m_connectionId = dBObjectId;
        this.m_whereCondition = string;
    }

    @Override
    protected PreparedStatement getPreparedStatement() throws SQLException {
        String string = QUERY;
        if (this.m_whereCondition != null) {
            string = string + " AND " + this.m_whereCondition;
        }
        PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
        preparedStatement.setLong(1, this.m_connectionId.getId());
        return preparedStatement;
    }
}

