/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CapturedConnectionIterator;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.ConstraintsIterator;
import oracle.dbtools.metadata.persistence.ConvertedConnectionIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.ForeignKeyConstraintsIterator;
import oracle.dbtools.metadata.persistence.IndexDetailPersistableMasterChildren;
import oracle.dbtools.metadata.persistence.MdApplication;
import oracle.dbtools.metadata.persistence.MdApplicationFile;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.MdFileArtifact;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdOtherObject;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTablespace;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllStoredProgramsRec;
import oracle.dbtools.metadata.persistence.MgvAllTableTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.MgvAllViewTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.MgvIterator;
import oracle.dbtools.metadata.persistence.MigrLogIterator;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.OrderedColumnsIterator;
import oracle.dbtools.metadata.persistence.PersistableMasterChildren;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.SchemaTableTriggersIterator;
import oracle.dbtools.metadata.persistence.TablesWithIdentityColumnsIterator;
import oracle.dbtools.migration.persistence.Migrlog;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.jdbc.OracleCallableStatement;

public final class PersistenceUtility {
    private PersistenceManager m_persistenceManager;
    private HashMap<Long, PersistableObject> _parentCache = new HashMap();
    private HashMap<Long, PersistableObject> _objectCache = new HashMap();
    private boolean _isCacheOn = false;
    private static Hashtable<PersistenceManager, PersistenceUtility> s_allUtils = new Hashtable();
    private HashMap<String, Integer> _objectCountCache = null;
    private static final DefaultCloseableIterator EMPTY_CLOSEABLE_ITERATOR = new DefaultCloseableIterator();

    public void setCacheOn(boolean bl) {
        this._isCacheOn = bl;
    }

    public void resetCache() {
        this._objectCache = new HashMap();
        this._parentCache = new HashMap();
    }

    public static PersistenceUtility getInstance(PersistenceManager persistenceManager) {
        PersistenceUtility persistenceUtility = s_allUtils.get(persistenceManager);
        if (persistenceUtility == null) {
            persistenceUtility = new PersistenceUtility(persistenceManager);
            s_allUtils.put(persistenceManager, persistenceUtility);
        }
        return persistenceUtility;
    }

    private PersistenceUtility(PersistenceManager persistenceManager) {
        this.setPersistenceManager(persistenceManager);
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public CloseableIterator<MgvAllCatalogsRec> getCatalogsForConnectionId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        Object object;
        String string = "SELECT * FROM MGV_ALL_CATALOGS WHERE CONNECTION_ID = ?";
        String string2 = null;
        if (migrationObjectFilterList != null && (object = migrationObjectFilterList.getFilterForType("MD_CATALOGS")) != null) {
            string2 = ((MigrationObjectFilter)object).toConditionClause("CATALOG_NAME", "CATALOG_ID");
        }
        if (string2 != null) {
            string = string + " AND " + string2;
        }
        object = new MgvIterator(MgvAllCatalogsRec.class, string, dBObjectId, this.getPersistenceManager());
        return object;
    }

    public CloseableIterator<MgvAllCatalogsRec> getCatalogsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getCatalogsForConnectionId(dBObjectId, null);
    }

    public MigrLogIterator<Migrlog> getLogsForProjectId(DBObjectId dBObjectId) throws PersistenceException {
        MigrLogIterator<Migrlog> migrLogIterator = new MigrLogIterator<Migrlog>(this.getPersistenceManager(), dBObjectId);
        return migrLogIterator;
    }

    public CloseableIterator getSchemasforCatalogId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdSchema.class, "CATALOG_ID_FK  ", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public int getSchemaCountForConnectionId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        int n;
        String string = "SELECT COUNT(*) FROM MGV_ALL_SCHEMA WHERE CONNECTION_ID = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            MigrationObjectFilter migrationObjectFilter;
            if (migrationObjectFilterList != null && (migrationObjectFilter = migrationObjectFilterList.getFilterForType("MD_SCHEMAS")) != null) {
                string = string + " AND " + migrationObjectFilter.toConditionClause("SCHEMA_NAME", "SCHEMA_ID");
            }
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return n;
    }

    public CloseableIterator getSchemasforCatalogId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getSchemasforCatalogId(dBObjectId, null);
    }

    public CloseableIterator getUsersforSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdUser.class, "SCHEMA_ID_FK  ", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public boolean userExistsInSchema(DBObjectId dBObjectId, String string) throws PersistenceException {
        ResultSet resultSet;
        block4: {
            boolean bl;
            PreparedStatement preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT COUNT(1) FROM MD_USERS WHERE SCHEMA_ID_FK = ? AND USERNAME = ?");
                preparedStatement.setLong(1, dBObjectId.getId());
                preparedStatement.setString(2, string);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int n = resultSet.getInt(1);
                if (n <= 0) break block4;
                bl = true;
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException(sQLException);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(null, resultSet);
                    throw throwable;
                }
            }
            CloseableResultSet.close(null, resultSet);
            return bl;
        }
        CloseableResultSet.close(null, resultSet);
        return false;
    }

    public CloseableIterator getUsersforSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getUsersforSchemaId(dBObjectId, null);
    }

    public CloseableIterator getAllCapturedConnections() throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = null;
        if (this.getPersistenceManager().getConn() != null) {
            persistableMasterChildren = new PersistableMasterChildren(MdConnection.class, "NVL2(TYPE, 2, 1)", new DBObjectId(1L), this.getPersistenceManager(), null);
        }
        return persistableMasterChildren;
    }

    public CloseableIterator<MgvAllSchemasRec> getSchemasForConnectionId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        Object object;
        String string = "SELECT * FROM MGV_ALL_SCHEMA WHERE CONNECTION_ID = ?";
        if (migrationObjectFilterList != null && (object = migrationObjectFilterList.getFilterForType("MD_SCHEMAS")) != null) {
            string = string + " AND " + ((MigrationObjectFilter)object).toConditionClause("SCHEMA_NAME", "SCHEMA_ID");
        }
        object = new MgvIterator(MgvAllSchemasRec.class, string, dBObjectId, this.getPersistenceManager());
        return object;
    }

    public CloseableIterator<MgvAllSchemasRec> getSchemasForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getSchemasForConnectionId(dBObjectId, null);
    }

    public CloseableIterator<MgvAllTablesRec> getTablesForConnectionId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        Object object;
        String string = "SELECT * FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?";
        if (migrationObjectFilterList != null && (object = migrationObjectFilterList.getFilterForType("MD_TABLES")) != null) {
            string = string + " AND " + ((MigrationObjectFilter)object).toWhereConditionForMigrationRepository();
        }
        string = string + "  ORDER BY CATALOG_ID, SCHEMA_ID";
        object = new MgvIterator(MgvAllTablesRec.class, string, dBObjectId, this.getPersistenceManager());
        return object;
    }

    public CloseableIterator<MgvAllTablesRec> getTablesForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getTablesForConnectionId(dBObjectId, null);
    }

    public MgvAllTablesRec getTablesForTableId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllTablesRec.class, "SELECT * FROM MGV_ALL_TABLES WHERE TABLE_ID = ?", dBObjectId, this.getPersistenceManager());
        if (mgvIterator.hasNext()) {
            return (MgvAllTablesRec)mgvIterator.next();
        }
        return null;
    }

    public CloseableIterator<MgvAllTableTriggersRec> getTableTriggersForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllTableTriggersRec.class, "SELECT * FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ?", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public CloseableIterator<MgvAllViewTriggersRec> getViewTriggersForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllViewTriggersRec.class, "SELECT * FROM MGV_ALL_VIEW_TRIGGERS WHERE CONNECTION_ID = ?", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getStoredProgramsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? ORDER BY STORED_PROGRAM_NAME", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getFunctionsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? AND PROGRAMTYPE = 'FUNCTION' ORDER BY STORED_PROGRAM_NAME", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public int getFunctionCountForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        String string = "SELECT COUNT(*) FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? AND PROGRAMTYPE = 'FUNCTION'";
        PreparedStatement preparedStatement = null;
        int n = 0;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return n;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getProceduresForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? AND PROGRAMTYPE = 'PROCEDURE' ORDER BY STORED_PROGRAM_NAME", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public int getProcedureCountForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        String string = "SELECT COUNT(*) FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? AND PROGRAMTYPE = 'PROCEDURE'";
        PreparedStatement preparedStatement = null;
        int n = 0;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return n;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getStoredProgramsForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        Object object;
        String string = null;
        String string2 = "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE SCHEMA_ID = ?";
        if (migrationObjectFilterList != null && (object = migrationObjectFilterList.getFilterForType("MD_STORED_PROGRAMS")) != null) {
            string = ((MigrationObjectFilter)object).toConditionClause("STORED_PROGRAM_NAME", "STORED_PROGRAM_ID");
        }
        if (string != null) {
            string2 = string2 + " AND " + string;
        }
        object = new MgvIterator(MgvAllStoredProgramsRec.class, string2, dBObjectId, this.getPersistenceManager());
        return object;
    }

    public CloseableIterator<MgvAllViewsRec> getViewsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllViewsRec.class, "SELECT * FROM MGV_ALL_VIEWS WHERE CONNECTION_ID = ?", dBObjectId, this.getPersistenceManager());
        return mgvIterator;
    }

    public CloseableIterator getColumnsForTableId(DBObjectId dBObjectId) throws PersistenceException {
        OrderedColumnsIterator orderedColumnsIterator = new OrderedColumnsIterator(this.getPersistenceManager(), dBObjectId);
        return orderedColumnsIterator;
    }

    public CloseableIterator getTablesForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdTable.class, "SCHEMA_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator getTablesForSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getTablesForSchemaId(dBObjectId, null);
    }

    public CloseableIterator getViewsForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdView.class, "SCHEMA_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator getViewsForSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getViewsForSchemaId(dBObjectId, null);
    }

    public CloseableIterator getConstraintsForTableId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdConstraint.class, "TABLE_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator getForeignKeyConstraintsForSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return new ForeignKeyConstraintsIterator(this.getPersistenceManager(), dBObjectId);
    }

    public CloseableIterator getConstraintsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        ConstraintsIterator constraintsIterator = new ConstraintsIterator(this.getPersistenceManager(), dBObjectId, null, null);
        return constraintsIterator;
    }

    public CloseableIterator getConstraintsForTableId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getConstraintsForTableId(dBObjectId, null);
    }

    public CloseableIterator getConstraintDetails(DBObjectId dBObjectId) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdConstraintDetail.class, "CONSTRAINT_ID_FK", dBObjectId, this.getPersistenceManager(), null);
        return persistableMasterChildren;
    }

    public CloseableIterator getIndexesForTableId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdIndexe.class, "TABLE_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator getIndexesForTableId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getIndexesForTableId(dBObjectId, null);
    }

    public CloseableIterator getIndexDetails(DBObjectId dBObjectId) throws PersistenceException {
        IndexDetailPersistableMasterChildren indexDetailPersistableMasterChildren = new IndexDetailPersistableMasterChildren(MdIndexDetail.class, "INDEX_ID_FK", dBObjectId, this.getPersistenceManager(), null);
        return indexDetailPersistableMasterChildren;
    }

    public boolean getHaveIaBlob(MdSchema mdSchema) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(" SELECT A.TABLE_NAME, B.COLUMN_NAME FROM MD_TABLES A,  MD_COLUMNS B WHERE A.SCHEMA_ID_FK = ? AND A.ID = B.TABLE_ID_FK AND UPPER(B.COLUMN_TYPE) = 'BLOB' ");
            preparedStatement.setLong(1, mdSchema.getKey().getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public DBObjectId getIdForColumn(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        DBObjectId dBObjectId2 = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK=? AND UPPER(TRIM(COLUMN_NAME))=UPPER(TRIM(?))");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            resultSet.next();
            DBObjectId dBObjectId3 = dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "Capture.NO_INDEXES", "tableId:" + dBObjectId + " columnName:" + string);
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public DBObjectId getIdForTable(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        DBObjectId dBObjectId2 = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_TABLES WHERE SCHEMA_ID_FK=? AND UPPER(TABLE_NAME)=UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            if (resultSet.next()) {
                dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            }
            DBObjectId dBObjectId3 = dBObjectId2;
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public DBObjectId getIdForStoredProgram(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            DBObjectId dBObjectId2;
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_STORED_PROGRAMS WHERE SCHEMA_ID_FK=? AND UPPER(NAME)=UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            resultSet.next();
            DBObjectId dBObjectId3 = dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public DBObjectId getIdForView(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            DBObjectId dBObjectId2;
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_VIEWS WHERE SCHEMA_ID_FK=? AND UPPER(VIEW_NAME)=UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            resultSet.next();
            DBObjectId dBObjectId3 = dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public DBObjectId getIdForSchema(DBObjectId dBObjectId, String string) throws PersistenceException {
        DBObjectId dBObjectId2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBObjectId dBObjectId3 = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_SCHEMAS WHERE CATALOG_ID_FK=? AND UPPER(NAME)=UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                dBObjectId3 = new DBObjectId(resultSet.getLong(1));
            }
            dBObjectId2 = dBObjectId3;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return dBObjectId2;
    }

    public DBObjectId getIdForColumn(DBObjectId dBObjectId, int n) throws PersistenceException {
        DBObjectId dBObjectId2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBObjectId dBObjectId3;
            preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK=? AND COLUMN_ORDER=?");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            dBObjectId2 = dBObjectId3 = new DBObjectId(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return dBObjectId2;
    }

    public DBObjectId getIdForUser(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            DBObjectId dBObjectId2;
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_USERS WHERE SCHEMA_ID_FK=? AND UPPER(USERNAME)=UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            resultSet.next();
            DBObjectId dBObjectId3 = dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public CloseableIterator getAllConvertedConnections() throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdConnection.class, "NVL2(TYPE, 1, 2)", new DBObjectId(1L), this.getPersistenceManager(), null);
        return persistableMasterChildren;
    }

    public CloseableIterator getCheckConstraintsForConectionId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        ConstraintsIterator constraintsIterator = new ConstraintsIterator(this.getPersistenceManager(), dBObjectId, "CHECK", migrationObjectFilterList);
        return constraintsIterator;
    }

    public CloseableIterator getTablesWithIdentityColsForConnectionId(DBObjectId dBObjectId) throws PersistenceException {
        TablesWithIdentityColumnsIterator tablesWithIdentityColumnsIterator = new TablesWithIdentityColumnsIterator(this.getPersistenceManager(), dBObjectId);
        return tablesWithIdentityColumnsIterator;
    }

    public CloseableIterator<MdSequence> getSequencesForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdSequence.class, "SCHEMA_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator<MdGroup> getGroupsForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        PersistableMasterChildren persistableMasterChildren = new PersistableMasterChildren(MdGroup.class, "SCHEMA_ID_FK", dBObjectId, this.getPersistenceManager(), migrationObjectFilterList);
        return persistableMasterChildren;
    }

    public CloseableIterator<MdSequence> getSequencesForSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getSequencesForSchemaId(dBObjectId, null);
    }

    public CloseableIterator<MdTrigger> getTriggersForSchemaId(DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        SchemaTableTriggersIterator schemaTableTriggersIterator = new SchemaTableTriggersIterator(this.getPersistenceManager(), dBObjectId, migrationObjectFilterList);
        return schemaTableTriggersIterator;
    }

    public CloseableIterator<MdTrigger> getTriggersForSchemaId(DBObjectId dBObjectId) throws PersistenceException {
        return this.getTriggersForSchemaId(dBObjectId, null);
    }

    public DBObjectId getSchemaIdForUser(DBObjectId dBObjectId, String string) throws PersistenceException {
        DBObjectId dBObjectId2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBObjectId dBObjectId3;
            preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT U.SCHEMA_ID_FK FROM MD_USERS U, MD_SCHEMAS S WHERE S.ID = U.SCHEMA_ID_FK AND S.CATALOG_ID_FK=? AND U.USERNAME=?");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            dBObjectId2 = dBObjectId3 = new DBObjectId(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return dBObjectId2;
    }

    public DBObjectId getSchemaIdForGroup(DBObjectId dBObjectId, String string) throws PersistenceException {
        DBObjectId dBObjectId2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBObjectId dBObjectId3;
            preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT G.SCHEMA_ID_FK FROM MD_GROUPS G, MD_SCHEMAS S WHERE S.ID = G.SCHEMA_ID_FK AND S.CATALOG_ID_FK=? AND G.GROUP_NAME=?");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            dBObjectId2 = dBObjectId3 = new DBObjectId(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return dBObjectId2;
    }

    public void updateConnectionStatistics(MdConnection mdConnection) throws PersistenceException {
        this.updateConnectionStatistics(mdConnection, "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConnectionStatistics(MdConnection mdConnection, String string) throws PersistenceException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.GATHERCONNECTIONSTATS(?,?)}");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.setLong(2, mdConnection.getKey().getId());
            oracleCallableStatement.setString(3, string);
            oracleCallableStatement.execute();
            mdConnection.retrieve(this.getPersistenceManager());
            if (oracleCallableStatement == null) return;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new PersistenceException(noSuchObjectException);
                }
            }
            catch (Throwable throwable) {
                if (oracleCallableStatement == null) throw throwable;
                CloseableResultSet.close(oracleCallableStatement, null);
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)oracleCallableStatement, null);
    }

    public PersistableObject loadPersistableObject(DBObjectId dBObjectId, String string) throws PersistenceException, NoSuchObjectException {
        PersistableObject persistableObject = null;
        if (this._isCacheOn && this._objectCache.containsKey(dBObjectId.getId())) {
            return this._objectCache.get(dBObjectId.getId());
        }
        if (string.equals("MD_ADDITIONAL_PROPERTIES")) {
            persistableObject = null;
        } else if (string.equals("MD_CATALOGS")) {
            persistableObject = MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_COLUMNS")) {
            persistableObject = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_CONNECTIONS")) {
            persistableObject = MdConnection.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_CONSTRAINT_DETAILS")) {
            persistableObject = MdConstraintDetail.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_CONSTRAINTS")) {
            persistableObject = MdConstraint.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_DERIVATIVES")) {
            persistableObject = MdDerivative.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_GROUPS")) {
            persistableObject = MdGroup.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_GROUP_MEMBERS")) {
            persistableObject = MdGroupMember.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_GROUP_PRIVILEGES")) {
            persistableObject = MdGroupPrivilege.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_INDEX_DETAILS")) {
            persistableObject = MdIndexDetail.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_INDEXES")) {
            persistableObject = MdIndexe.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_OTHER_OBJECTS")) {
            persistableObject = MdOtherObject.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_PACKAGES")) {
            persistableObject = MdPackage.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_PRIVILEGES")) {
            persistableObject = MdPrivilege.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_PROJECTS")) {
            persistableObject = MdProject.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_REPOVERSIONS")) {
            persistableObject = null;
        } else if (string.equals("MD_SCHEMAS")) {
            persistableObject = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_SEQUENCES")) {
            persistableObject = MdSequence.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_STORED_PROGRAMS")) {
            persistableObject = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_SYNONYMS")) {
            persistableObject = MdSynonym.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_TABLES")) {
            persistableObject = MdTable.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_TABLESPACES")) {
            persistableObject = MdTablespace.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_TRIGGERS")) {
            persistableObject = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_USER_DEFINED_DATA_TYPES")) {
            persistableObject = MdUserDefinedDataType.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_USERS")) {
            persistableObject = MdUser.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_USER_PRIVILEGES")) {
            persistableObject = MdUserPrivilege.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        } else if (string.equals("MD_VIEWS")) {
            persistableObject = MdView.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
        }
        if (this._isCacheOn) {
            this._objectCache.put(dBObjectId.getId(), persistableObject);
        }
        return persistableObject;
    }

    public String[] getAllDataTypesForConnection(DBObjectId dBObjectId) throws PersistenceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT DISTINCT(COLUMN_TYPE) FROM MD_COLUMNS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public String getHostForConnection(DBObjectId dBObjectId) throws PersistenceException {
        String string = new String();
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT HOST FROM MD_CONNECTIONS WHERE Id=?");
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
            String string2 = string;
            return string2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public PersistableObject loadParentPersistableObject(PersistableObject persistableObject) throws PersistenceException, NoSuchObjectException {
        PersistableObject persistableObject2 = null;
        String string = persistableObject.getObjectType();
        DBObjectId dBObjectId = null;
        if (string.equals("MD_CATALOGS")) {
            dBObjectId = ((MdCatalog)persistableObject).getConnectionId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdConnection.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_COLUMNS")) {
            dBObjectId = ((MdColumn)persistableObject).getTableId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_CONNECTIONS")) {
            persistableObject2 = null;
        } else if (string.equals("MD_CONSTRAINTS")) {
            dBObjectId = ((MdConstraint)persistableObject).getTableId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_SCHEMAS")) {
            dBObjectId = ((MdSchema)persistableObject).getCatalogId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_STORED_PROGRAMS")) {
            dBObjectId = ((MdStoredProgram)persistableObject).getSchemaId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_SYNONYMS")) {
            dBObjectId = ((MdSynonym)persistableObject).getSchemaId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_TABLES")) {
            dBObjectId = ((MdTable)persistableObject).getSchemaId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_TRIGGERS")) {
            if (((MdTrigger)persistableObject).getTriggerOnFlag().equals("T")) {
                dBObjectId = ((MdTrigger)persistableObject).getTableOrViewId();
                if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                    persistableObject2 = this._parentCache.get(dBObjectId.getId());
                } else {
                    persistableObject2 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                    if (this._isCacheOn) {
                        this._parentCache.put(dBObjectId.getId(), persistableObject2);
                    }
                }
            } else {
                dBObjectId = ((MdTrigger)persistableObject).getTableOrViewId();
                if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                    persistableObject2 = this._parentCache.get(dBObjectId.getId());
                } else {
                    persistableObject2 = MdView.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                    if (this._isCacheOn) {
                        this._parentCache.put(dBObjectId.getId(), persistableObject2);
                    }
                }
            }
        } else if (string.equals("MD_VIEWS")) {
            dBObjectId = ((MdView)persistableObject).getSchemaId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_SEQUENCES")) {
            dBObjectId = ((MdSequence)persistableObject).getSchemaId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else if (string.equals("MD_INDEXES")) {
            dBObjectId = ((MdIndexe)persistableObject).getTableId();
            if (this._isCacheOn && this._parentCache.containsKey(dBObjectId.getId())) {
                persistableObject2 = this._parentCache.get(dBObjectId.getId());
            } else {
                persistableObject2 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                if (this._isCacheOn) {
                    this._parentCache.put(dBObjectId.getId(), persistableObject2);
                }
            }
        } else {
            persistableObject2 = null;
        }
        return persistableObject2;
    }

    public DBObjectId getIdForCatalog(DBObjectId dBObjectId, String string) throws PersistenceException {
        DBObjectId dBObjectId2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBObjectId dBObjectId3;
            preparedStatement = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_CATALOGS WHERE CONNECTION_ID_FK=?  AND UPPER(CATALOG_NAME) =UPPER(?)");
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            dBObjectId2 = dBObjectId3 = new DBObjectId(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return dBObjectId2;
    }

    public MgvAllStoredProgramsRec getStoredProgramForProgramId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE STORED_PROGRAM_ID = ?", dBObjectId, this.getPersistenceManager());
        if (mgvIterator.hasNext()) {
            return (MgvAllStoredProgramsRec)mgvIterator.next();
        }
        return null;
    }

    public MgvAllViewsRec getViewRecordForViewId(DBObjectId dBObjectId) throws PersistenceException {
        MgvIterator mgvIterator = new MgvIterator(MgvAllViewsRec.class, "SELECT * FROM MGV_ALL_VIEWS WHERE VIEW_ID = ?", dBObjectId, this.getPersistenceManager());
        if (mgvIterator.hasNext()) {
            return (MgvAllViewsRec)mgvIterator.next();
        }
        return null;
    }

    public MdPackage getEmulationPackageForSchema(DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdPackage mdPackage;
        ResultSet resultSet;
        block5: {
            String string = " SELECT A.ID FROM MD_PACKAGES  A, MD_ADDITIONAL_PROPERTIES B WHERE A.ID = B.REF_ID_FK AND B.PROP_KEY = 'MIGRATIONEMULATION' AND B.VALUE = 'Y' AND A.SCHEMA_ID_FK = ?";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            DBObjectId dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            MdPackage mdPackage2 = MdPackage.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId2);
            CloseableResultSet.close(null, resultSet);
            return mdPackage2;
        }
        try {
            mdPackage = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return mdPackage;
    }

    public MdSynonym getEmulationSynonymForSchema(DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdSynonym mdSynonym;
        ResultSet resultSet;
        block5: {
            String string = "SELECT A.ID FROM MD_SYNONYMS A, MD_ADDITIONAL_PROPERTIES B WHERE A.ID = B.REF_ID_FK AND B.PROP_KEY = 'MIGRATIONEMULATION' AND B.VALUE = 'Y' AND A.SCHEMA_ID_FK = ?";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            DBObjectId dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            MdSynonym mdSynonym2 = MdSynonym.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId2);
            CloseableResultSet.close(null, resultSet);
            return mdSynonym2;
        }
        try {
            mdSynonym = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        return mdSynonym;
    }

    public DBObjectId getIdForTrigger(DBObjectId dBObjectId, String string) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            DBObjectId dBObjectId2;
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(" SELECT TRIGGER_ID FROM MGV_ALL_VIEW_TRIGGERS  WHERE UPPER(TRIGGER_NAME)=UPPER(?) AND SCHEMA_ID =?  UNION  SELECT TRIGGER_ID FROM MGV_ALL_TABLE_TRIGGERS   WHERE UPPER(TRIGGER_NAME)=UPPER(?) AND SCHEMA_ID =? ");
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, dBObjectId.getId());
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            resultSet.next();
            DBObjectId dBObjectId3 = dBObjectId2 = new DBObjectId(resultSet.getLong(1));
            return dBObjectId3;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public ArrayList<String> getEmulationFuncsForSchema(DBObjectId dBObjectId) throws PersistenceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(" SELECT DISTINCT(child_name)  FROM md_migr_weakdep WHERE schema_id_fk =?");
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public ArrayList<String> getEmulationFuncsForConnection(DBObjectId dBObjectId) throws PersistenceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(" SELECT DISTINCT(child_name) FROM md_migr_weakdep WHERE connection_id_fk =?");
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    public static boolean isColumnNullable(MdColumn mdColumn) {
        return mdColumn.getNullable().equalsIgnoreCase("Y");
    }

    public CloseableIterator getAllProjects() throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new PersistableMasterChildren(MdProject.class, "1", new DBObjectId(1L), this.getPersistenceManager(), null);
        }
        return closeableIterator;
    }

    public MdProject getNamedProject(String string) throws PersistenceException {
        MdProject mdProject = null;
        CloseableIterator closeableIterator = this.getAllProjects();
        while (closeableIterator.hasNext()) {
            MdProject mdProject2 = (MdProject)closeableIterator.next();
            if (!mdProject2.getProjectName().equals(string)) continue;
            mdProject = mdProject2;
            break;
        }
        return mdProject;
    }

    public MdProject findOrCreateNamedProject(String string) throws PersistenceException {
        MdProject mdProject = this.getNamedProject(string);
        if (null == mdProject) {
            mdProject = new MdProject(string);
        }
        return mdProject;
    }

    public CloseableIterator getCapturedConnectionsForProjectId(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new CapturedConnectionIterator(this.getPersistenceManager(), dBObjectId);
        }
        return closeableIterator;
    }

    public CloseableIterator getConvertedModelsForCapturedModel(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new ConvertedConnectionIterator(this.getPersistenceManager(), dBObjectId);
        }
        return closeableIterator;
    }

    public CloseableIterator getApplicationsForCapturedModel(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new PersistableMasterChildren(MdApplication.class, "CONNECTION_ID_FK", dBObjectId, this.getPersistenceManager(), null);
        }
        return closeableIterator;
    }

    public CloseableIterator getApplicationsForProject(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new PersistableMasterChildren(MdApplication.class, "PROJECT_ID_FK", dBObjectId, this.getPersistenceManager(), null);
        }
        return closeableIterator;
    }

    public CloseableIterator getFilesForApplication(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new PersistableMasterChildren(MdApplicationFile.class, "APPLICATIONS_ID_FK", dBObjectId, this.getPersistenceManager(), null);
        }
        return closeableIterator;
    }

    public CloseableIterator getArtifactsForFile(DBObjectId dBObjectId) throws PersistenceException {
        CloseableIterator closeableIterator = EMPTY_CLOSEABLE_ITERATOR;
        if (this.getPersistenceManager().getConn() != null) {
            closeableIterator = new PersistableMasterChildren(MdFileArtifact.class, "APPLICATIONFILES_ID", dBObjectId, this.getPersistenceManager(), null);
        }
        return closeableIterator;
    }

    public int getObjectCount(DBObjectId dBObjectId, String string) {
        int n = 0;
        if (this._objectCountCache == null) {
            this.initObjectCountCache(dBObjectId);
        }
        if (this._objectCountCache != null && this._objectCountCache.containsKey(string.toUpperCase())) {
            n = this._objectCountCache.get(string.toUpperCase());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initObjectCountCache(DBObjectId dBObjectId) {
        this._objectCountCache = new HashMap();
        String string = "SELECT UPPER(objtype),UPPER(mainobjtype), COUNT(*) FROM mgv_all_details WHERE connid = ? GROUP BY objType,mainobjtype";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            resultSet = preparedStatement.executeQuery();
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                n = resultSet.getInt(3);
                if (string2.equalsIgnoreCase("MD_TRIGGERS")) {
                    string3 = resultSet.getString(2);
                    string2 = string3.equalsIgnoreCase("MD_TABLES") ? string2 + "T" : string2 + "V";
                }
                this._objectCountCache.put(string2, n);
            }
        }
        catch (SQLException sQLException) {
            CloseableResultSet.close(null, resultSet);
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
    }

    public boolean isDBObjectEnabled(Long l) throws PersistenceException {
        String string = "SELECT ENABLED FROM MD_DERIVATIVES WHERE DERIVED_ID = ?";
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        String string2 = "";
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException(sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, resultSet);
        if (string2.equalsIgnoreCase("Y")) {
            bl = true;
        }
        return bl;
    }

    private static class DefaultCloseableIterator
    implements CloseableIterator {
        private DefaultCloseableIterator() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

