/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.statemanager.StateManager;

public class DefaultContext
implements Context {
    public static final String ENV_STATE_MANAGER_CLASS_NAME = "oracle.adf.share.statemanager.class_name";
    public static final String STATE_MANAGER_JNDI_NAME = "__state_manager__";
    private final Hashtable mEnvironment;

    public DefaultContext(Hashtable environment) {
        this.mEnvironment = environment;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getStateManager();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.getStateManager();
    }

    private StateManager getStateManager() {
        StateManager mgr = null;
        if (mgr == null) {
            String className = (String)this.mEnvironment.get(ENV_STATE_MANAGER_CLASS_NAME);
            if (className == null) {
                try {
                    className = System.getProperty(ENV_STATE_MANAGER_CLASS_NAME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (className == null) {
                ADFContext adfCtx = ADFContext.getCurrent();
                className = adfCtx.getContextType() == 2 && adfCtx.hasSession() ? "oracle.adf.share.http.HttpSessionStateManagerImpl" : "oracle.adf.share.statemanager.j2ee.StateManagerImpl";
            }
            try {
                Class managerClass = ClassUtils.forName((String)className, DefaultContext.class);
                mgr = (StateManager)managerClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            mgr.init(this.mEnvironment);
        }
        return mgr;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.mEnvironment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.mEnvironment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.mEnvironment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }

    private class StateManagerHolder {
        private StateManager mPortletStateManager = null;
        private StateManager mDefaultStateManager = null;

        private StateManagerHolder() {
        }

        private StateManager getStateManager() {
            ADFContext adfCtx = ADFContext.getCurrent();
            if (adfCtx.getContextType() == 3) {
                return this.mPortletStateManager;
            }
            return this.mDefaultStateManager;
        }

        private void setStateManager(StateManager mgr) {
            ADFContext adfCtx = ADFContext.getCurrent();
            if (adfCtx.getContextType() == 3) {
                this.mPortletStateManager = mgr;
            } else {
                this.mDefaultStateManager = mgr;
            }
        }
    }
}

