/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.io.Serializable;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialStoreContext;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage2;

public class CredentialStore {
    CredentialStoreContext _credentialStoreCtx = CredentialStoreContext.getInstance();
    CredentialStorage _storage = null;
    static final String CLASS_NAME = CredentialStore.class.getName();
    static final ADFLogger sLogger = ADFSecurityUtil.getADFLogger();

    public CredentialStore() {
        this._storage = this._credentialStoreCtx.getDefaultCredentialStoreProvider();
    }

    public CredentialStore(String contextName) {
        this._storage = this._credentialStoreCtx.getCredentialStorage(contextName);
    }

    public void storeCredential(Credential cred, String credKey) {
        this.storeCredential(cred, null, null, credKey);
    }

    public void storeCredential(Credential cred, String mapName, String adfCredKey, String credKey) {
        String METHOD_NAME = "storeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        CredentialStoreContext.checkSerializable(CLASS_NAME, "storeCredential", cred, adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._storage instanceof CredentialStorage2) {
            CredentialStorage2 _storage2 = (CredentialStorage2)this._storage;
            _storage2.storeCredential(cred, mapName, adfCredKey, credKey);
            return;
        }
        this._storage.storeCredential(cred, credKey);
    }

    public void storeSessionCredential(Credential cred, String credKey) {
        this.storeSessionCredential(cred, null, null, credKey);
    }

    public void storeSessionCredential(Credential cred, String mapName, String adfCredKey, String credKey) {
        String METHOD_NAME = "storeSessionCredential";
        String ckey = adfCredKey == null ? credKey : adfCredKey;
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "Credential Key", ckey);
        CredentialStoreContext.storeSessionCredential(cred, ckey);
    }

    public Credential fetchSessionCredential(String credKey) throws CredentialNotFoundException {
        return this.fetchSessionCredential(null, null, credKey);
    }

    public Credential fetchSessionCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSessionCredential";
        String ckey = adfCredKey == null ? credKey : adfCredKey;
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSessionCredential", "Credential Key", ckey);
        return CredentialStoreContext.fetchSessionCredential(ckey);
    }

    public Credential fetchCredential(String credKey) throws CredentialNotFoundException {
        return this.fetchCredential(null, null, credKey);
    }

    public Credential fetchCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._storage instanceof CredentialStorage2) {
            CredentialStorage2 _storage2 = (CredentialStorage2)this._storage;
            return _storage2.fetchCredential(mapName, adfCredKey, credKey);
        }
        return this._storage.fetchCredential(credKey);
    }

    public Serializable fetchSerializableCredential(String credKey) throws CredentialNotFoundException {
        return this.fetchSerializableCredential(null, null, credKey);
    }

    public Serializable fetchSerializableCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSerializableCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSerializableCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._storage instanceof CredentialStorage2) {
            CredentialStorage2 _storage2 = (CredentialStorage2)this._storage;
            return _storage2.fetchSerializableCredential(mapName, adfCredKey, credKey);
        }
        return this._storage.fetchSerializableCredential(credKey);
    }

    public Serializable fetchSerializableCredentialForCurrentUser(String credKey) throws CredentialNotFoundException {
        return this.fetchSerializableCredentialForCurrentUser(null, null, credKey);
    }

    public Serializable fetchSerializableCredentialForCurrentUser(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSerializableCredentialForCurrentUser";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSerializableCredentialForCurrentUser", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._storage instanceof CredentialStorage2) {
            CredentialStorage2 _storage2 = (CredentialStorage2)this._storage;
            return _storage2.fetchSerializableCredentialForCurrentUser(mapName, adfCredKey, credKey);
        }
        return this._storage.fetchSerializableCredentialForCurrentUser(credKey);
    }

    public void removeCredential(String credKey) throws CredentialNotFoundException {
        this.removeCredential(null, null, credKey);
    }

    public void removeCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "removeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "removeCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._storage instanceof CredentialStorage2) {
            CredentialStorage2 _storage2 = (CredentialStorage2)this._storage;
            _storage2.removeCredential(mapName, adfCredKey, credKey);
            return;
        }
        this._storage.removeCredential(credKey);
    }
}

