/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.RefAddr;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlRefAddr
extends RefAddr {
    private static final long serialVersionUID = -7152338982425662223L;
    private DocumentFragment mFragment;
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)XmlRefAddr.class.getName(), null);
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    public XmlRefAddr(String addrType, DocumentFragment doc) {
        super(addrType);
        this.mFragment = doc;
    }

    @Override
    public Object getContent() {
        return this.getDocumentFragment();
    }

    public DocumentFragment getDocumentFragment() {
        return this.mFragment;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof XmlRefAddr) {
            XmlRefAddr xmlRefAddr = (XmlRefAddr)obj;
            if (this.getLogger().isFinest()) {
                this.getLogger().finest("Source XmlRefAddr \n" + this.toString() + "\n Target XmlRefAddr \n" + xmlRefAddr.toString());
            }
            return this.compareNodes(this.getDocumentFragment(), xmlRefAddr.getDocumentFragment());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("Type: " + this.addrType + "\n");
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult strResult = new StreamResult(new StringWriter());
            DOMSource domSource = new DOMSource(this.getDocumentFragment());
            transformer.transform(domSource, strResult);
            str.append("Content: " + strResult.getWriter().toString() + "\n");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return str.toString();
    }

    private ADFLogger getLogger() {
        return mLogger;
    }

    private boolean compareNodes(Node srcXmlRefAddr, Node targetXmlRefAddr) {
        Node targetChild;
        if (this.isSameNode(srcXmlRefAddr, targetXmlRefAddr)) {
            return true;
        }
        if (srcXmlRefAddr.getNodeType() != targetXmlRefAddr.getNodeType()) {
            return false;
        }
        if (!this.getNodeNameInternal(srcXmlRefAddr).equals(this.getNodeNameInternal(targetXmlRefAddr))) {
            return false;
        }
        if (!this.equalStrWithNull(srcXmlRefAddr.getNamespaceURI(), targetXmlRefAddr.getNamespaceURI())) {
            return false;
        }
        if (!this.equalStrWithNull(srcXmlRefAddr.getNodeValue(), targetXmlRefAddr.getNodeValue())) {
            return false;
        }
        if (srcXmlRefAddr.getNodeType() == 1) {
            List<Attr> srcAttrs = this.getFilteredAttributeList(srcXmlRefAddr);
            List<Attr> targetAttrs = this.getFilteredAttributeList(targetXmlRefAddr);
            if (srcAttrs.size() != targetAttrs.size()) {
                return false;
            }
            for (Attr srcAttr : srcAttrs) {
                boolean foundMatch = false;
                for (Attr targetAttr : targetAttrs) {
                    if (!this.compareNodes(srcAttr, targetAttr)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                return false;
            }
        }
        Node srcChild = srcXmlRefAddr.getFirstChild();
        for (targetChild = targetXmlRefAddr.getFirstChild(); srcChild != null && targetChild != null; srcChild = srcChild.getNextSibling(), targetChild = targetChild.getNextSibling()) {
            srcChild.normalize();
            targetChild.normalize();
            if (this.compareNodes(srcChild, targetChild)) continue;
            return false;
        }
        return srcChild == null && targetChild == null;
    }

    private List<Attr> getFilteredAttributeList(Node node) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return Collections.emptyList();
        }
        int mapLength = map.getLength();
        if (mapLength == 0) {
            return Collections.emptyList();
        }
        ArrayList<Attr> filteredAttrList = new ArrayList<Attr>(mapLength);
        Attr currentAttr = null;
        for (int i = 0; i < mapLength; ++i) {
            currentAttr = (Attr)map.item(i);
            if (XMLNS_NAMESPACE.equals(currentAttr.getNamespaceURI())) continue;
            filteredAttrList.add(currentAttr);
        }
        if (this.getLogger().isFinest()) {
            StringBuffer strAttributes = new StringBuffer("");
            for (int j = 0; j < filteredAttrList.size(); ++j) {
                Attr curAttr = (Attr)filteredAttrList.get(j);
                String curAttrName = curAttr.getLocalName() != null ? curAttr.getLocalName() : curAttr.getNodeName();
                strAttributes.append(curAttrName);
                if (j >= filteredAttrList.size() - 1) continue;
                strAttributes.append(",");
            }
            this.getLogger().finest("Node Name = " + node.getLocalName() != null ? node.getLocalName() : node.getNodeName() + ", Attributes" + strAttributes.toString());
        }
        return filteredAttrList;
    }

    private boolean isSameNode(Node source, Node target) {
        return source == target;
    }

    private boolean equalStrWithNull(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private String getNodeNameInternal(Node n) {
        String strNodeName = n.getLocalName();
        if (this.getLogger().isFinest()) {
            this.getLogger().finest("Node Local Name = " + strNodeName);
        }
        if (null == strNodeName) {
            strNodeName = n.getNodeName();
            if (this.getLogger().isFinest()) {
                this.getLogger().finest("Node Name = " + strNodeName);
            }
        }
        return strNodeName;
    }
}

