/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class WasPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private String localCellName;
    private String localNodeName;
    private String localSeverName;
    private String localClusterName;
    private boolean isNDEdition;
    private transient ServerConfig runningServer;
    private static final String ENDPOINT_JNDI = "BOOTSTRAP_ADDRESS";

    protected WasPortConfig(boolean isNDEdition) throws Exception {
        this.isNDEdition = isNDEdition;
        this.initRunningServerConfig();
        this.localCellName = this.runningServer.cellName;
        this.localNodeName = this.runningServer.nodeName;
        this.localSeverName = this.runningServer.name;
        this.localClusterName = this.runningServer.clusterName;
        this.parseXmls(this.runningServer);
        this.parsePortConfigPropertiesFile(this.getUserPropertiesFile());
    }

    protected WasPortConfig(String cellName, String nodeName, String serverName, boolean isNDEdition) throws Exception {
        this.isNDEdition = isNDEdition;
        this.localCellName = cellName;
        this.localNodeName = nodeName;
        this.localSeverName = serverName;
        this.initRunningServerConfig();
        ServerConfig localServerConfig = new ServerConfig(this.localSeverName, this.localNodeName, this.localCellName);
        this.localClusterName = localServerConfig.clusterName;
        this.parseXmls(localServerConfig);
        this.parsePortConfigPropertiesFile(this.getUserPropertiesFile());
    }

    private void initRunningServerConfig() throws Exception {
        AdminService service = AdminServiceFactory.getAdminService();
        ObjectName localServerBean = service.getLocalServer();
        String runningCellName = ObjectNameHelper.getCellName((ObjectName)localServerBean);
        String runningNodeName = ObjectNameHelper.getNodeName((ObjectName)localServerBean);
        String runningServerName = ServerPlatformSupportFactory.getInstance().getServerName();
        this.runningServer = new ServerConfig(runningServerName, runningNodeName, runningCellName);
    }

    protected static String internalGetClusterName() throws PortabilityLayerException {
        AdminService service = AdminServiceFactory.getAdminService();
        ObjectName localServerBean = service.getLocalServer();
        String currentCellName = ObjectNameHelper.getCellName((ObjectName)localServerBean);
        String currentNodeName = ObjectNameHelper.getNodeName((ObjectName)localServerBean);
        String currentSeverName = ServerPlatformSupportFactory.getInstance().getServerName();
        try {
            return new ServerConfig((String)currentSeverName, (String)currentNodeName, (String)currentCellName).clusterName;
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "corbaloc:iiop", "iiop"};
    }

    @Override
    public boolean isClustered() {
        return this.isNDEdition && this.localClusterName != null;
    }

    private static Element getXmlDom(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        return dbf.newDocumentBuilder().parse(xmlFile).getDocumentElement();
    }

    private void parseXmls(ServerConfig localServer) throws Exception {
        if (localServer.clusterName != null) {
            ClusterConfig cluster = new ClusterConfig(localServer.clusterName, localServer.cellName, localServer);
            HashMap<String, ServerEntryNodeConfig> clusterServerEntryList = new HashMap<String, ServerEntryNodeConfig>();
            for (ServerConfig member : cluster.members) {
                ServerEntryNodeConfig memberEntryNode = (ServerEntryNodeConfig)clusterServerEntryList.get(member.nodeName);
                if (memberEntryNode == null) {
                    memberEntryNode = new ServerEntryNodeConfig(member.nodeName);
                    clusterServerEntryList.put(member.nodeName, memberEntryNode);
                }
                this.initWebPortsFromXml(member, memberEntryNode);
                this.initJndiPortsFromXml(member, memberEntryNode);
            }
        } else {
            ServerEntryNodeConfig serverEntryNode = new ServerEntryNodeConfig(this.localNodeName);
            this.initWebPortsFromXml(localServer, serverEntryNode);
            this.initJndiPortsFromXml(localServer, serverEntryNode);
        }
    }

    private void initJndiPortsFromXml(ServerConfig server, ServerEntryNodeConfig serverEntryNode) throws UnknownHostException {
        Map<String, EndpointConfig> memberEndpoints = serverEntryNode.endpoints.get(server.name);
        EndpointConfig endpoint = memberEndpoints.get(ENDPOINT_JNDI);
        boolean isLocalServer = this.localSeverName.equals(server.name) && this.localNodeName.equals(server.nodeName);
        this.addPort(isLocalServer, "corbaloc:iiop", endpoint);
        if (isLocalServer) {
            this.addServerPort(new Port("iiop", endpoint.host, endpoint.port, this));
        }
    }

    private void initWebPortsFromXml(ServerConfig server, ServerEntryNodeConfig serverEntryNode) throws Exception {
        boolean isLocalServer = this.localSeverName.equals(server.name) && this.localNodeName.equals(server.nodeName);
        boolean isRunningServer = this.runningServer.name.equals(server.name) && this.runningServer.nodeName.equals(server.nodeName);
        Map<String, EndpointConfig> memberEndpoints = serverEntryNode.endpoints.get(server.name);
        boolean isDmgr = "dmgr".equals(server.name);
        String httpEndPointName = isDmgr ? server.adminHttpEndPointName : server.defaultHttpEndPointName;
        EndpointConfig endpoint = null;
        if (httpEndPointName != null) {
            endpoint = memberEndpoints.get(httpEndPointName);
        }
        this.addPort(isLocalServer, "http", endpoint);
        String httpSslEndPointName = isDmgr ? server.adminHttpSslEndPointName : server.defaultHttpSslEndPointName;
        endpoint = null;
        if (httpSslEndPointName != null) {
            endpoint = memberEndpoints.get(httpSslEndPointName);
        }
        this.addPort(isLocalServer, "https", endpoint);
    }

    private Port getPortFromDmgr(String cellName, String nodeName, String serverName, String protocol) throws Exception {
        AdminClient dmgrClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
        Set res = dmgrClient.queryNames(new ObjectName("oracle.jrf:name=JRFService,*"), null);
        ObjectName mbeanName = (ObjectName)res.iterator().next();
        String serverId = "/Cell:" + cellName + "/Node:" + nodeName + "/Server:" + serverName;
        Object url = dmgrClient.invoke(mbeanName, "getServerURL", new Object[]{serverId, protocol}, new String[]{"java.lang.String", "java.lang.String"});
        return url == null ? null : new Port((String)url, this);
    }

    private void addPort(boolean isLocalServer, String protocol, EndpointConfig endpoint) throws UnknownHostException {
        if (endpoint != null) {
            Port port = new Port(protocol, endpoint.host, endpoint.port, this);
            if (isLocalServer) {
                this.addServerPort(port);
            }
            if (this.isClustered()) {
                this.addClusterMemberPort(port);
            }
        }
    }

    private static File getCellConfigDir() throws Exception {
        String domainConfigdir = ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory();
        return new File(domainConfigdir, "../");
    }

    private static File getServerIndex(String nodeName) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + nodeName + "/serverindex.xml");
    }

    private static File getServerXml(String nodeName, String serverName) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + nodeName + "/servers/" + serverName + "/server.xml");
    }

    private static File getClusterXml(String cluserName) throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "clusters/" + cluserName + "/cluster.xml");
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"corbaloc:iiop", "iiop"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return this.getDefaultJndiProtocols();
    }

    @Override
    public String getJndiSslProviderURL() {
        return this.getJndiProviderURL();
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener listener) throws PortabilityLayerException {
        try {
            MBeanServer mbeanServer = new PortableMBeanFactory().getPrivilegedMBeanServer();
            Set<ObjectName> configRepositoryMBeans = mbeanServer.queryNames(new ObjectName("WebSphere:type=ConfigRepository,name=repository,cell=" + this.localCellName + ",node=" + this.localNodeName + ",process=" + this.localSeverName + ",*"), null);
            ObjectName configRepositoryMBeanName = configRepositoryMBeans.iterator().next();
            mbeanServer.addNotificationListener(configRepositoryMBeanName, listener, (NotificationFilter)new RepositoryChangeListenerFilter(), null);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    protected String getClusterName() {
        return this.localClusterName;
    }

    protected String getCellName() {
        return this.localCellName;
    }

    protected String getlNodeName() {
        return this.localNodeName;
    }

    protected String getSeverName() {
        return this.localSeverName;
    }

    @Override
    protected String getClusterJNDISeparator() {
        return ",:";
    }

    protected File getUserPropertiesFile() throws Exception {
        return new File(WasPortConfig.getCellConfigDir(), "nodes/" + this.localNodeName + "/servers/" + this.localSeverName + "/fmwconfig/" + "jrf-port-config.properties");
    }

    private static class TransPortChannel {
        private String id;
        private String endPointName;
        List<TransPortChain> chains;
        boolean isEnable;
        boolean isSSL;
        boolean isDefaultHttp;
        boolean isAdminHttp;

        TransPortChannel(String id, String endPointName, List<TransPortChain> chains) {
            this.id = id;
            this.endPointName = endPointName;
            this.chains = chains;
            this.init();
        }

        private void init() {
            this.isDefaultHttp = false;
            for (TransPortChain chain : this.chains) {
                if (!chain.channels.contains("HTTP") || !chain.name.contains("WCInboundDefault")) continue;
                this.isDefaultHttp = true;
                break;
            }
            this.isAdminHttp = false;
            for (TransPortChain chain : this.chains) {
                if (!chain.channels.contains("HTTP") || !chain.name.contains("WCInboundAdmin")) continue;
                this.isAdminHttp = true;
                break;
            }
            this.isEnable = this.chains.size() > 0;
            for (TransPortChain chain : this.chains) {
                if (chain.isEnable()) continue;
                this.isEnable = false;
                break;
            }
            this.isSSL = this.chains.size() > 0;
            for (TransPortChain chain : this.chains) {
                if (chain.isSSL()) continue;
                this.isSSL = false;
                break;
            }
        }
    }

    private static class TransPortChain {
        String name;
        String enable;
        String channels;

        TransPortChain(String name, String enable, String channels) {
            this.channels = channels;
            this.enable = enable;
            this.name = name;
        }

        public boolean isSSL() {
            return this.channels.contains("SSL");
        }

        public boolean isEnable() {
            return "true".equals(this.enable);
        }
    }

    private static class RepositoryChangeListenerFilter
    implements NotificationFilter {
        private static final long serialVersionUID = 1L;

        private RepositoryChangeListenerFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return "websphere.repository.change".equals(notification.getType());
        }
    }

    private static class ServerConfig {
        protected String name;
        protected String nodeName;
        protected String cellName;
        protected String clusterName;
        protected String adminHttpEndPointName;
        protected String adminHttpSslEndPointName;
        protected String defaultHttpEndPointName;
        protected String defaultHttpSslEndPointName;

        ServerConfig(String name, String nodeName, String cellName) throws Exception {
            this.name = name;
            this.nodeName = nodeName;
            this.cellName = cellName;
            this.parseConfig(WasPortConfig.getServerXml(nodeName, name));
        }

        ServerConfig(String name, String nodeName, String cellName, String clusterName) throws Exception {
            this.name = name;
            this.nodeName = nodeName;
            this.cellName = cellName;
            this.clusterName = clusterName;
            this.parseConfig(WasPortConfig.getServerXml(nodeName, name));
        }

        private void parseConfig(File serverXml) throws Exception {
            if (!serverXml.exists()) {
                return;
            }
            Element server = WasPortConfig.getXmlDom(serverXml);
            String clsName = server.getAttribute("clusterName").trim();
            if (clsName != null && !clsName.isEmpty()) {
                this.clusterName = clsName;
            }
            this.parseTransPortChannels(server);
        }

        private void parseTransPortChannels(Element serverDomElem) throws Exception {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            String xpathStr = "/Server/services[@type='channelservice:TransportChannelService' and @enable='true']/transportChannels[@endPointName]";
            XPathExpression xPathExpression = xPath.compile(xpathStr);
            Object result = xPathExpression.evaluate(serverDomElem, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                String endPointName = elem.getAttribute("endPointName");
                String id = elem.getAttribute("xmi:id");
                List<TransPortChain> chains = this.getTransPortChains(elem.getParentNode(), id);
                TransPortChannel tpChannel = new TransPortChannel(id, endPointName, chains);
                if (!tpChannel.isEnable) continue;
                if (tpChannel.isSSL) {
                    if (tpChannel.isAdminHttp) {
                        this.adminHttpSslEndPointName = tpChannel.endPointName;
                        continue;
                    }
                    if (!tpChannel.isDefaultHttp) continue;
                    this.defaultHttpSslEndPointName = tpChannel.endPointName;
                    continue;
                }
                if (tpChannel.isAdminHttp) {
                    this.adminHttpEndPointName = tpChannel.endPointName;
                    continue;
                }
                if (!tpChannel.isDefaultHttp) continue;
                this.defaultHttpEndPointName = tpChannel.endPointName;
            }
        }

        private List<TransPortChain> getTransPortChains(Node tpServiceNode, String transPortChannelId) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
            ArrayList<TransPortChain> tpChains = new ArrayList<TransPortChain>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            String xpathStr = "chains[contains(@transportChannels, '" + transPortChannelId + "')]";
            XPathExpression xPathExpression = xPath.compile(xpathStr);
            Object result = xPathExpression.evaluate(tpServiceNode, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                String tpChannels = elem.getAttribute("transportChannels");
                String enable = elem.getAttribute("enable");
                String name = elem.getAttribute("name");
                TransPortChain chain = new TransPortChain(name, enable, tpChannels);
                tpChains.add(chain);
            }
            return tpChains;
        }

        public String toString() {
            return "ServerConfig [name=" + this.name + ", cellName=" + this.cellName + ", nodeName=" + this.nodeName + ", clusterName=" + this.clusterName + "]";
        }
    }

    private static class ClusterConfig {
        protected String name;
        protected String cellName;
        List<ServerConfig> members;
        ServerConfig localServerMember;

        ClusterConfig(String name, String cellName, ServerConfig localServerMember) throws Exception {
            this.name = name;
            this.cellName = cellName;
            this.members = new ArrayList<ServerConfig>();
            this.localServerMember = localServerMember;
            this.members.add(localServerMember);
            this.parseConfig(WasPortConfig.getClusterXml(name));
        }

        private void parseConfig(File clusterXml) throws Exception {
            Element cluster = WasPortConfig.getXmlDom(clusterXml);
            NodeList serverList = cluster.getElementsByTagName("members");
            if (serverList != null) {
                for (int i = 0; i < serverList.getLength(); ++i) {
                    Element server = (Element)serverList.item(i);
                    String serverName = server.getAttribute("memberName").trim();
                    String serverNodeName = server.getAttribute("nodeName").trim();
                    if (serverName.equals(this.localServerMember.name) && serverNodeName.equals(this.localServerMember.nodeName)) continue;
                    this.members.add(new ServerConfig(serverName, serverNodeName, this.cellName, this.name));
                }
            }
        }

        public String toString() {
            return "ClusterConfig [name=" + this.name + ", cellName=" + this.cellName + ", members=" + this.members + "]";
        }
    }

    private static class ServerEntryNodeConfig {
        protected String host;
        protected String nodeName;
        protected Map<String, Map<String, EndpointConfig>> endpoints;

        ServerEntryNodeConfig(String nodeName) throws Exception {
            this.nodeName = nodeName;
            this.endpoints = new HashMap<String, Map<String, EndpointConfig>>();
            this.parseConfig(WasPortConfig.getServerIndex(nodeName));
        }

        private void parseConfig(File config) throws Exception {
            Element serverIndex = WasPortConfig.getXmlDom(config);
            this.host = serverIndex.getAttribute("hostName").trim();
            NodeList serverEntriesList = serverIndex.getElementsByTagName("serverEntries");
            if (serverEntriesList != null) {
                for (int i = 0; i < serverEntriesList.getLength(); ++i) {
                    Element serverEntries = (Element)serverEntriesList.item(i);
                    String serverName = serverEntries.getAttribute("serverName").trim();
                    HashMap<String, EndpointConfig> serverEndpoints = new HashMap<String, EndpointConfig>();
                    NodeList specialEndpointList = serverEntries.getElementsByTagName("specialEndpoints");
                    if (specialEndpointList != null) {
                        for (int j = 0; j < specialEndpointList.getLength(); ++j) {
                            Element specialEndpoint = (Element)specialEndpointList.item(j);
                            String endpointName = specialEndpoint.getAttribute("endPointName").trim();
                            NodeList endPointList = specialEndpoint.getElementsByTagName("endPoint");
                            if (endPointList == null) continue;
                            Element endpoint = (Element)endPointList.item(0);
                            String endpointHost = endpoint.getAttribute("host").trim();
                            if (endpointHost.indexOf("*") >= 0) {
                                endpointHost = this.host;
                            }
                            String endpointPort = endpoint.getAttribute("port").trim();
                            serverEndpoints.put(endpointName, new EndpointConfig(endpointName, endpointHost, endpointPort, this.nodeName, serverName));
                        }
                    }
                    this.endpoints.put(serverName, serverEndpoints);
                }
            }
        }

        public String toString() {
            return "NodeServerEntryConfig [nodeName=" + this.nodeName + ", host=" + this.host + ", endpoints=" + this.endpoints + "]";
        }
    }

    private static class EndpointConfig {
        protected String name;
        protected String host;
        protected String serverName;
        protected String nodeName;
        protected int port;

        private EndpointConfig(String name, String host, String port, String nodeName, String serverName) throws UnknownHostException {
            this.name = name;
            this.host = host;
            if (host.indexOf("${LOCALHOST") >= 0) {
                this.host = "localhost";
            }
            this.port = port == null ? -1 : Integer.valueOf(port);
            this.nodeName = nodeName;
            this.serverName = serverName;
        }

        public String toString() {
            return "EndpointConfig [name=" + this.name + ", host=" + this.host + ", port=" + this.port + ", serverName=" + this.serverName + ", nodeName=" + this.nodeName + "]";
        }
    }
}

