/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import oracle.jrf.JRFInternalPlatform;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.was.WasPortConfig;
import oracle.jrf.was.WasServerPlatformSupport;

public class WasNDJrfInternalPlatform
extends WasServerPlatformSupport
implements JRFInternalPlatform {
    private String clusterName;

    @Override
    public boolean isWebSphereND() {
        return true;
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        if (this.adminServerName == null) {
            this.adminServerName = System.getProperty(ORACLE_ADMIN_SERVER_NAME);
            if (this.adminServerName == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10002"));
            }
        }
        return this.adminServerName;
    }

    @Override
    public boolean isTargeted(String[] targets) throws PortabilityLayerException {
        boolean isDmgr = this.isDeploymentManagerServer();
        boolean isManagedServer = !isDmgr && !this.isAdminServer();
        for (String target : targets) {
            if (!("%ALLManagedServers%".equals(target) && isManagedServer || "%AdminServer%".equals(target) && this.isAdminServer()) && (!"%DmgrServer%".equals(target) || !isDmgr)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDeploymentManagerServer() throws PortabilityLayerException {
        return "dmgr".equals(this.getServerName());
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        if (this.clusterName == null) {
            this.clusterName = WasPortConfig.internalGetClusterName();
        }
        return this.clusterName;
    }

    @Override
    protected PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new WasPortConfig(true);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    @Override
    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        String[] strSubs = serverId.split("\\/");
        String theCellName = null;
        String theNodeName = null;
        String theServerName = null;
        for (String subStr : strSubs) {
            if (subStr.startsWith("Cell:")) {
                theCellName = subStr.substring(5);
            }
            if (subStr.startsWith("Node:")) {
                theNodeName = subStr.substring(5);
            }
            if (!subStr.startsWith("Server:")) continue;
            theServerName = subStr.substring(7);
        }
        if (theCellName == null || theNodeName == null || theServerName == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{serverId}));
        }
        WasPortConfig currentSrvPortConfig = (WasPortConfig)this.getPortConfig();
        if (theCellName.equals(currentSrvPortConfig.getCellName()) && theNodeName.equals(currentSrvPortConfig.getlNodeName()) && theServerName.equals(currentSrvPortConfig.getSeverName())) {
            return currentSrvPortConfig;
        }
        try {
            return new WasPortConfig(theCellName, theNodeName, theServerName, true);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }
}

