/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.AbstractTemplate;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.TemplateHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTemplateBuilder {
    protected AbstractTemplate template;
    private File templateDir;
    protected static final String TEMPLATE_INFO_XML = "template-info.xml";
    protected static final String NAME = "name";
    protected static final String VERSION = "version";
    protected static final String CONFIG_GROUPS_XML = "config-groups.xml";
    protected static final String GROUP = "group";
    protected static final String GROUP_REF = "group-ref";
    protected static final String LIBRARY = "library";

    public Template getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTemplate(File templateFile) throws PortabilityLayerException {
        JarFile templateJar = null;
        try {
            try {
                templateJar = new JarFile(templateFile);
            }
            catch (IOException ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10008", new String[]{templateFile.getName()}), ex);
            }
            this.template.oracleHome = templateFile.getParentFile().getParentFile().getParentFile().getParent();
            this.templateDir = templateFile.getParentFile();
            this.readTemplateInfo(templateJar);
            this.readConfigXml(templateJar);
            this.readConfigGroups(templateJar);
            this.readJvmConfig(templateJar);
            this.safeClose(templateJar);
        }
        catch (Throwable throwable) {
            this.safeClose(templateJar);
            throw throwable;
        }
    }

    private void readTemplateInfo(JarFile templateJar) throws PortabilityLayerException {
        Element root = this.getDocumentElement(templateJar, TEMPLATE_INFO_XML);
        this.template.name = root.getAttribute(NAME);
        this.template.version = root.getAttribute(VERSION);
        NodeList dependencies = root.getElementsByTagName("requires");
        for (int i = 0; i < dependencies.getLength(); ++i) {
            String depVersion;
            Node dep = dependencies.item(i);
            String depName = dep.getAttributes().getNamedItem(NAME).getNodeValue();
            Template depTemplate = this.findDependentTemplate(depName, depVersion = "12.1.4.0");
            if (depTemplate == null && (depName.equals("WebLogic Coherence Cluster Extension") || depName.equals("WebLogic Template for JRF Domain"))) continue;
            if (depTemplate == null && (depTemplate = this.findDependentTemplate(depName, "12.1.3.0")) == null) {
                depTemplate = this.findDependentTemplate(depName, "12.1.4");
            }
            this.template.subTemplates.add(depTemplate);
        }
    }

    private Template findDependentTemplate(String name, String version) throws PortabilityLayerException {
        File depTemplateFile;
        if (this.template.isWebLogic()) {
            depTemplateFile = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/wls/"), name, version);
            if (depTemplateFile == null) {
                depTemplateFile = this.findTemplateFile(new File(this.template.getOracleHome(), "../wlserver/common/templates/wls/"), name, version);
            }
            if (depTemplateFile == null) {
                depTemplateFile = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/applications/"), name, version);
            }
        } else {
            depTemplateFile = this.findTemplateFile(new File(this.template.getOracleHome(), "common/templates/was/"), name, version);
        }
        if (depTemplateFile != null) {
            return TemplateHelper.getInstance().getTemplate(this.template.isWebLogic(), this.template.getOracleHome(), depTemplateFile.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findTemplateFile(File aTemplateDir, String name, String version) throws PortabilityLayerException {
        if (!aTemplateDir.isDirectory()) {
            System.out.println("Warning: " + aTemplateDir.toString() + " is not a dir for loading template file");
            return null;
        }
        for (File templateFile : aTemplateDir.listFiles()) {
            if (templateFile.getName().indexOf(".jar") <= 0) continue;
            JarFile templateJar = null;
            try {
                try {
                    templateJar = new JarFile(templateFile);
                }
                catch (IOException ex) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10008", new String[]{templateFile.getName()}), ex);
                }
                Element root = this.getDocumentElement(templateJar, TEMPLATE_INFO_XML);
                if (name.equals(root.getAttribute(NAME))) {
                    File file = templateFile;
                    this.safeClose(templateJar);
                    return file;
                }
                this.safeClose(templateJar);
            }
            catch (Throwable throwable) {
                this.safeClose(templateJar);
                throw throwable;
            }
        }
        return null;
    }

    protected abstract void readConfigXml(JarFile var1) throws PortabilityLayerException;

    protected void readApplications(NodeList apps) {
        for (int i = 0; i < apps.getLength(); ++i) {
            Application app = new Application();
            NodeList children = apps.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                this.processApplicationChildNode(app, children.item(j).getNodeName(), children.item(j).getTextContent());
            }
            this.template.allApplications.put(app.getName(), app);
        }
    }

    protected abstract void processApplicationChildNode(Application var1, String var2, String var3);

    protected void readLibraries(NodeList libs) {
        for (int i = 0; i < libs.getLength(); ++i) {
            Library lib = new Library();
            NodeList children = libs.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                this.processLibraryChildNode(lib, children.item(j).getNodeName(), children.item(j).getTextContent());
            }
            this.template.allLibraries.put(lib.getName(), lib);
        }
    }

    protected abstract void processLibraryChildNode(Library var1, String var2, String var3);

    protected void readConfigGroups(JarFile templateJar) throws PortabilityLayerException {
        Element root = this.getDocumentElement(templateJar, CONFIG_GROUPS_XML);
        if (root == null) {
            return;
        }
        NodeList groups = root.getElementsByTagName(GROUP);
        for (int i = 0; i < groups.getLength(); ++i) {
            String groupName = groups.item(i).getAttributes().getNamedItem(NAME).getNodeValue();
            this.template.applications.put(groupName, new ArrayList());
            this.template.libraries.put(groupName, new ArrayList());
            this.template.startupClasses.put(groupName, new ArrayList());
            this.template.shutdownClasses.put(groupName, new ArrayList());
            this.template.urlProviders.put(groupName, new ArrayList());
            this.template.wldfSystemResources.put(groupName, new ArrayList());
            this.template.jdbcSystemResources.put(groupName, new ArrayList());
            this.template.configGroupReferences.put(groupName, new ArrayList());
            NodeList children = groups.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                String nodeName = children.item(j).getNodeName();
                if (nodeName.equals("#text") || nodeName.equals("#comment")) continue;
                this.processConfigGroupResource(nodeName, children.item(j).getAttributes().getNamedItem(NAME).getNodeValue(), groupName);
            }
        }
    }

    protected void processConfigGroupResource(String nodeName, String nodeValue, String groupName) {
        if (nodeName.equals(LIBRARY)) {
            this.template.libraries.get(groupName).add(this.template.allLibraries.get(nodeValue));
        } else if (nodeName.equals(GROUP_REF)) {
            this.template.configGroupReferences.get(groupName).add(nodeValue);
        }
    }

    protected void readJvmConfig(JarFile templateJar) throws PortabilityLayerException {
    }

    protected Element getDocumentElement(JarFile templateJar, String xmlFileName) throws PortabilityLayerException {
        InputStream xmlStream = null;
        try {
            ZipEntry entry = templateJar.getEntry(xmlFileName);
            if (entry == null) {
                return null;
            }
            xmlStream = templateJar.getInputStream(entry);
        }
        catch (IOException ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10009", new String[]{templateJar.getName() + ":" + xmlFileName}), ex);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        try {
            return dbf.newDocumentBuilder().parse(xmlStream).getDocumentElement();
        }
        catch (Exception ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20019", new String[]{ex.getMessage()}), ex);
        }
    }

    private void safeClose(JarFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

