/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.Serializable;
import java.net.UnknownHostException;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public final class Port
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String protocol;
    private String host;
    private Integer port;
    private String path;
    private String urlString;
    private String resolvedDNSHost;
    private String dnsUrlString;
    private PortConfig portConfig;

    public Port(String protocol, String host, Integer port, PortConfig portConfig) throws UnknownHostException {
        this(protocol, host, port, portConfig, null, false);
    }

    public Port(String protocol, String host, Integer port, PortConfig portConfig, String path, boolean resolveDNSHost) throws UnknownHostException {
        this.protocol = protocol;
        this.host = host;
        this.port = port == null ? -1 : port;
        this.portConfig = portConfig;
        this.path = path;
        this.resolvedDNSHost = resolveDNSHost ? PortConfig.resolveHost(host) : host;
    }

    public Port(String url, PortConfig portConfig) throws UnknownHostException, PortabilityLayerException {
        this.portConfig = portConfig;
        this.parse(url);
        this.resolvedDNSHost = PortConfig.resolveHost(this.host);
    }

    private void parse(String url) throws PortabilityLayerException {
        String[] subStrs = url.split("://");
        if (subStrs.length != 2) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20035"));
        }
        this.protocol = subStrs[0];
        if ((subStrs = subStrs[1].split(":")).length > 2) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20035"));
        }
        this.host = subStrs[0];
        this.port = subStrs.length == 2 ? new Integer(subStrs[1]) : -1;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getDnsResolvedHost() {
        return this.resolvedDNSHost;
    }

    public boolean isLocal() {
        return this.resolvedDNSHost.equals(this.portConfig.getLocalHost());
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getURLString() {
        if (this.urlString == null) {
            if (this.port > 0) {
                this.urlString = this.protocol + "://" + this.host + ":" + this.port;
                if (this.path != null) {
                    this.urlString = this.urlString + "/" + this.path;
                }
            } else {
                this.urlString = this.protocol + "://" + this.host;
                if (this.path != null) {
                    this.urlString = this.urlString + "/" + this.path;
                }
            }
        }
        return this.urlString;
    }

    public String getDnsResolvedURLString() {
        if (this.dnsUrlString == null) {
            String protocolPrefix;
            String string = protocolPrefix = this.protocol.equals("corbaloc:iiop") ? this.protocol + ":" : this.protocol + "://";
            if (this.port > 0) {
                this.dnsUrlString = protocolPrefix + this.resolvedDNSHost + ":" + this.port;
                if (this.path != null) {
                    this.dnsUrlString = this.dnsUrlString + "/" + this.path;
                }
            } else {
                this.dnsUrlString = protocolPrefix + this.resolvedDNSHost;
                if (this.path != null) {
                    this.dnsUrlString = this.dnsUrlString + "/" + this.path;
                }
            }
        }
        return this.dnsUrlString;
    }
}

