/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnDPlugin;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchField;
import oracle.olap.dml.editor.OLAPDMLController;
import oracle.olap.dml.editor.OLAPDMLPinningTracker;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLEditorToolbar
implements Controller,
EditorPlugin,
Observer {
    private ToggleToolButton pinToggle;
    private ToggleToolButton roToggle;
    private IdeAction pinAction;
    private IdeAction roAction;
    private final String TYPE_OLAPDMLPROGRAM = "OLAPDMLPROGRAM";
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    static final int RO_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"RO_Pin_Editor");
    private CodeEditor parent;
    private Toolbar toolbar;
    private List<IdeAction> actions = new LinkedList<IdeAction>();
    public static final String ACCEL_FILE = "oracle/olap/dml/editor/accelerators.xml";

    public OLAPDMLEditorToolbar() {
        OLAPDMLController.getInstance();
    }

    public void install(BasicEditorPane basicEditorPane) {
        OLAPDMLNode oLAPDMLNode;
        this.parent = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.toolbar = this.parent.getToolbar();
        basicEditorPane.installPlugin((EditorPlugin)new RaptorDnDPlugin());
        Node node = this.parent.getContext().getNode();
        this.addPinAction(this.parent, this.toolbar);
        this.addRunActions(this.parent, this.toolbar, node);
        this.addCompileActions(this.parent, this.toolbar, node);
        if (DBURLFormatHelper.isDBURL((URL)node.getURL())) {
            this.addROAction(this.parent, this.toolbar);
        }
        if (node instanceof OLAPDMLNode) {
            oLAPDMLNode = (OLAPDMLNode)node;
            oLAPDMLNode.addListener(this);
        }
        oLAPDMLNode = new DBConnectionComboBox();
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof SearchField)) continue;
            component.setMinimumSize(new Dimension(225, component.getHeight()));
            component.setPreferredSize(new Dimension(225, component.getHeight()));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)oLAPDMLNode.getJComboBox());
        final OLAPDMLNode oLAPDMLNode2 = (OLAPDMLNode)node;
        String string = null;
        if (DBURLFormatHelper.isDBURL((URL)node.getURL())) {
            string = oLAPDMLNode2.getConnectionName();
        }
        if (string != null) {
            oLAPDMLNode.setCurrentConnection(string);
        }
        ItemListener itemListener = new ItemListener((DBConnectionComboBox)oLAPDMLNode){
            private String m_currConn;
            final /* synthetic */ DBConnectionComboBox val$dbSelector;
            {
                this.val$dbSelector = dBConnectionComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        String string = (String)itemEvent.getItem();
                        try {
                            Connections.getInstance().getConnection(string);
                            this.m_currConn = string;
                            oLAPDMLNode2.setConnectionName(string);
                        }
                        catch (DBException dBException) {
                            Throwable throwable = dBException.getCause();
                            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                            }
                            this.val$dbSelector.setCurrentConnection(this.m_currConn);
                        }
                        View.updateToolbarActions((Toolbar)OLAPDMLEditorToolbar.this.toolbar);
                        break;
                    }
                }
            }
        };
        if (DBURLFormatHelper.isDBURL((URL)node.getURL())) {
            oLAPDMLNode.getJComboBox().setEnabled(false);
            oLAPDMLNode.getJComboBox().setFocusable(false);
        } else {
            oLAPDMLNode.getJComboBox().addItemListener(itemListener);
        }
        View.updateToolbarActions((Toolbar)this.toolbar);
    }

    private void addPinAction(CodeEditor codeEditor, Toolbar toolbar) {
        this.pinAction = IdeAction.findOrCreate((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)codeEditor);
        this.pinAction.addController((Controller)this);
        this.pinToggle = new ToggleToolButton((ToggleAction)this.pinAction);
        toolbar.add((Component)this.pinToggle);
        Node node = codeEditor.getContext().getNode();
        boolean bl = OLAPDMLPinningTracker.isPinned(node);
        this.pinAction.setState(bl);
        if (!bl) {
            this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            this.pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
        }
    }

    private void addROAction(CodeEditor codeEditor, Toolbar toolbar) {
        this.roAction = IdeAction.findOrCreate((int)RO_EDITOR_CMD_ID, null, (String)Messages.getString((String)"PLSQLEditorToolbar.switchWrite"), null, null, null, null, (boolean)true).newLocalAction((View)codeEditor);
        this.roAction.addController((Controller)this);
        this.roToggle = new ToggleToolButton((ToggleAction)this.roAction);
        toolbar.add((Component)this.roToggle);
        OLAPDMLNode oLAPDMLNode = (OLAPDMLNode)codeEditor.getContext().getNode();
        boolean bl = OLAPDMLPinningTracker.isPinned((Node)oLAPDMLNode);
        this.roAction.setState(bl);
        this.toggleROIcon(oLAPDMLNode);
    }

    private void addCompileActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        String string = ((OLAPDMLNode)node).getType();
        if (!string.equalsIgnoreCase("OLAPDMLPROGRAM")) {
            return;
        }
        IdeAction[] ideActionArray = new IdeAction[]{this.createLocalAction((View)codeEditor, CompileArb.getIcon((String)"COMPILECODE_ICON"), Messages.getString((String)"Compile"), OLAPDMLController.COMPILE_COMMAND)};
        IdeAction ideAction = this.createLocalAction((View)codeEditor, CompileArb.getIcon((String)"MAKE_ICON"), Messages.getString((String)"Compile"), OLAPDMLController.MAKE_COMMAND);
        ToolButton toolButton = new ToolButton((Action)ideAction);
        int n = this.searchFieldIndex(toolbar);
        toolbar.add((Component)toolButton);
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        String string = ((OLAPDMLNode)node).getType();
        if (!string.equalsIgnoreCase("OLAPDMLPROGRAM")) {
            return;
        }
        int n = this.searchFieldIndex(toolbar);
        ToolButton toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, OracleIcons.getIcon((String)"run.png"), Messages.getString((String)"Run"), OLAPDMLController.RUN_COMMAND));
        toolbar.add((Component)toolButton);
    }

    private int searchFieldIndex(Toolbar toolbar) {
        int n = toolbar.getComponentCount() - 1;
        for (int i = 0; i < toolbar.getComponentCount(); ++i) {
            Component component = toolbar.getComponent(i);
            if (!(component instanceof SearchField)) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        Node node = this.parent.getContext().getNode();
        if (node instanceof OLAPDMLNode) {
            ((OLAPDMLNode)node).removeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, int n) {
        IdeAction ideAction = this.createLocalAction(view, n);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.putValue("ShortDescription", (Object)string);
        this.actions.add(ideAction);
        return ideAction;
    }

    private IdeAction createLocalAction(View view, int n) {
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        ideAction.setEnabled(false);
        return ideAction;
    }

    private void setupAcceleratorToolTip(IdeAction ideAction, int n) {
        try {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContextRegistry.getContext(ACCEL_FILE));
            if (keyStrokeMap == null) {
                return;
            }
            List list = keyStrokeMap.getKeyStrokesFor(n);
            if (list != null && list.size() > 0) {
                KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
                StringBuffer stringBuffer = new StringBuffer(20);
                stringBuffer.append(" (");
                for (int i = 0; i < keyStrokes.getLength(); ++i) {
                    KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                    if (keyStroke == null) continue;
                    String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(string);
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                }
                stringBuffer.append(")");
                ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            Logger.warn(OLAPDMLEditorToolbar.class, (String)("Exception in setupAcceleratorToolTip():" + exception.getMessage()));
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            Node node = context.getNode();
            boolean bl = OLAPDMLPinningTracker.isPinned(node);
            if (!bl) {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
                OLAPDMLPinningTracker.pinNode(node);
            } else {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                OLAPDMLPinningTracker.unpinNode(node);
            }
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        if (n == RO_EDITOR_CMD_ID) {
            OLAPDMLNode oLAPDMLNode = (OLAPDMLNode)context.getNode();
            oLAPDMLNode.toggleReadOnly();
            this.toggleROIcon(oLAPDMLNode);
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        return false;
    }

    private void toggleROIcon(OLAPDMLNode oLAPDMLNode) {
        BasicEditorPane basicEditorPane = this.parent.getFocusedEditorPane();
        basicEditorPane.setEditable(!oLAPDMLNode.isReadOnly());
        if (oLAPDMLNode.isReadOnly() || "BLOCK".equals(oLAPDMLNode.getObjectType())) {
            this.roToggle.setIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"));
            this.roToggle.setToolTipText(Messages.getString((String)"PLSQLEditorToolbar.switchWrite"));
        } else {
            this.roToggle.setIcon(RaptorImagesArb.getIcon((String)"EDIT_CODE_WRITE"));
            this.roToggle.setToolTipText(Messages.getString((String)"PLSQLEditorToolbar.switchReadOnly"));
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof OLAPDMLNode) {
            OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)node);
        }
        return true;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (object instanceof OLAPDMLNode) {
            for (Component component : this.toolbar.getComponents()) {
                AbstractButton abstractButton;
                Action action;
                if (!(component instanceof AbstractButton) || !((action = (abstractButton = (AbstractButton)component).getAction()) instanceof IdeAction)) continue;
                IdeAction ideAction = (IdeAction)action;
                OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)object);
            }
        }
    }
}

