/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.olap.dml.editor.OLAPDMLPinningTracker;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public final class OLAPDMLBufferPinning
extends NodeListener {
    private Map<Node, ReadTextBuffer> pinnedBuffers = new TreeMap<Node, ReadTextBuffer>();

    public void nodeOpened(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        TextBuffer textBuffer = ((OLAPDMLNode)node).acquireTextBuffer();
        this.pinnedBuffers.put(node, (ReadTextBuffer)textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("AUTOPINPLSQLEDITORS").booleanValue() && !node.getURL().getFile().contains("anon_block")) {
            OLAPDMLPinningTracker.pinNode(node);
        }
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        ((OLAPDMLNode)node).releaseTextBuffer();
        this.pinnedBuffers.remove(node);
        OLAPDMLPinningTracker.unpinNode(node);
    }
}

